/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Touch
extends Task {
    private File file;
    private long millis = -1L;
    private String dateTime;
    private Vector filesets = new Vector();
    private Vector filelists = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public void setDatetime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void addFilelist(FileList list) {
        this.filelists.addElement(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        long savedMillis = this.millis;
        if (this.file == null && this.filesets.size() == 0 && this.filelists.size() == 0) {
            throw new BuildException("Specify at least one source - a file, filelist or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to touch directories.");
        }
        try {
            if (this.dateTime != null) {
                DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.US);
                try {
                    this.setMillis(df.parse(this.dateTime).getTime());
                }
                catch (ParseException pe) {
                    df = DateFormat.getDateTimeInstance(3, 2, Locale.US);
                    try {
                        this.setMillis(df.parse(this.dateTime).getTime());
                    }
                    catch (ParseException pe2) {
                        throw new BuildException(pe2.getMessage(), pe, this.getLocation());
                    }
                }
                if (this.millis < 0L) {
                    throw new BuildException("Date of " + this.dateTime + " results in negative " + "milliseconds value " + "relative to epoch " + "(January 1, 1970, " + "00:00:00 GMT).");
                }
            }
            this.touch();
            Object var7_5 = null;
            this.millis = savedMillis;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.millis = savedMillis;
            throw throwable;
        }
    }

    protected void touch() throws BuildException {
        String[] srcFiles;
        File fromDir;
        boolean resetMillis = false;
        if (this.millis < 0L) {
            resetMillis = true;
            this.millis = System.currentTimeMillis();
        }
        if (this.file != null) {
            this.touch(this.file);
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            fromDir = fs.getDir(this.getProject());
            srcFiles = ds.getIncludedFiles();
            String[] srcDirs = ds.getIncludedDirectories();
            int j = 0;
            while (j < srcFiles.length) {
                this.touch(new File(fromDir, srcFiles[j]));
                ++j;
            }
            int j2 = 0;
            while (j2 < srcDirs.length) {
                this.touch(new File(fromDir, srcDirs[j2]));
                ++j2;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.filelists.size()) {
            FileList fl = (FileList)this.filelists.elementAt(i2);
            fromDir = fl.getDir(this.getProject());
            srcFiles = fl.getFiles(this.getProject());
            int j = 0;
            while (j < srcFiles.length) {
                this.touch(new File(fromDir, srcFiles[j]));
                ++j;
            }
            ++i2;
        }
        if (resetMillis) {
            this.millis = -1L;
        }
    }

    protected void touch(File file) throws BuildException {
        if (!file.exists()) {
            this.log("Creating " + file, 2);
            try {
                this.fileUtils.createNewFile(file);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create " + file, ioe, this.getLocation());
            }
        }
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        this.fileUtils.setFileLastModified(file, this.millis);
    }
}

