/*
** Copyright (C) 2006 Arturo 'Ciaraan' MANN, <arturo.mann@gmail.com>
** Contributions by Diego 'Flameeyes' Pettenò, September, 2006.	
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
* $Id: picoxine.c,v 1.4 2006/05/20 14:34:42  Exp $
*/
/* PicoXine: A small Xine implementation to play audio events in KDE/Gnome */
/** Includes **/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#include <xine.h>
#include <xine/xineutils.h>
#include <unistd.h>
/** Define version**/
#ifndef VERSION
#define VERSION                   "0.0.7"
#endif
/** Required variables **/
static xine_t              *xine;
static xine_stream_t       *stream;
static xine_audio_port_t   *ao_port;
static xine_event_queue_t  *event_queue;
static int		   running = 1;
static int		   volume = 100;
/** Event Listener for Stopping the app **/

static void event_listener(void *user_data, const xine_event_t *event) {
  switch(event->type) { 
  case XINE_EVENT_UI_PLAYBACK_FINISHED:
    running = 0;
    break;
  }
}
  
/** Main program block **/
int main(int argc, char **argv) {
  char              configfile[2048];
  char             *mrl = NULL;
  int		   i;

  char		   *ao_drv = "alsa";
/** Parsing the command line **/
for (i = 1; i < argc; i++) {
if (strcmp(argv[i], "-v") == 0) {
volume = *argv[++i];
}
else if (strcmp(argv[i], "-ao") == 0) {
ao_drv = argv[++i];
} else
mrl = argv[i];
}
/** No Mrl? woops. **/
  if(!mrl) {
    printf("PicoXine: The Xine audio event player for KDE/Gnome v%s\n"
	   "(c) 2006: By Arturo MANN, <arturo.mann@gmail.com>\n",VERSION);
    printf("Usage: picoxine [options] [filename]\n Where Options:\n -v [0-100] (Volume)\n -ao [driver: alsa,oss,esd, etc..] (Audio Driver)\n");
    return -1;
  }
/** Init Xine **/
  xine = xine_new();
  snprintf(configfile, sizeof(configfile), "%s%s", xine_get_homedir(), "/.xine/config");
  xine_config_load(xine, configfile);
  xine_init(xine);
  ao_port     = xine_open_audio_driver(xine , ao_drv, NULL);
  stream      = xine_stream_new(xine, ao_port, NULL);
  event_queue = xine_event_new_queue(stream);
  xine_event_create_listener_thread(event_queue, event_listener, NULL);
/** Set volume **/
xine_set_param(stream,XINE_PARAM_AUDIO_AMP_LEVEL,volume);
/** Start the Playback **/
  if(!xine_open(stream, mrl)) {
    printf("Unable to open file '%s'\n", mrl);
    return -2;
  }
xine_play(stream,0,0);

while (running) {
	xine_usec_sleep(40000);
}
/** sleep! **/
  sleep(1);	
/** Clean up **/
  xine_close(stream);
  xine_event_dispose_queue(event_queue);
  xine_dispose(stream);
  xine_close_audio_driver(xine, ao_port);  
  xine_exit(xine);
return 0;
}
/*
*
*Compile line:  gcc -Wall -O2 `xine-config --cflags` `xine-config --libs` -I/usr/X11R6/include -L/usr/X11R6/lib -lX11 -lXext -lm -o picoxine picoxine.c
*
*/

