/* MoleInvasion - Copyright (C) - Guillaume Chambraud (linuxprocess@free.fr)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version. */

# include "menu.h"

void draw_select(char action, int pos)
{	static mySprite select;

	if(action==DO_DRAW)
	{	displaySprite(select,g_SDL_screen,589,600 - select.imgH - 22 - pos*63);
	}
	else if(action==DO_INIT)
	{	char * element="gfx/ihm/select.png";
		if(LoadImgSprite(&select,element))
			fprintf(stderr,"Cannot load : %s\n",element);
	}
	else if(action==DO_FREE)
	{	FreeImgSprite(select);
	}
}

mySprite * draw_backgrnd(char action, void * element)
{	mySprite * backgrnd;

	if(action==DO_DRAW)
	{	if(element)
			displaySprite( *(mySprite *)element,g_SDL_screen,0,0);
		return NULL;
	}
	else if(action==DO_INIT)
	{	backgrnd=(mySprite *)malloc(sizeof(mySprite));
		if(LoadImgSprite(backgrnd,(char*)element))
			fprintf(stderr,"Cannot load : %s\n",(char*)element);
		return backgrnd;
	}
	else if(action==DO_FREE)
	{	if(element)
		{	FreeImgSprite(*(mySprite*)element);
			free(element);
			element=NULL;
		}
		return NULL;
	}
	assert(action!=action);
	return NULL;
}

void draw_menu(char action, int displaylevels)
{	static mySprite choice, levels, history;
	static int progress;
	
	if(action==DO_INIT)
	{	choice=font_long_text("[CHOICE]",0,0);
		levels=font_long_text("[LEVEL_CHOICE]",0,0);
		history=font_long_text("[HISTORY]",0,0);
		progress=-120<<1;
	}
	else if(action==DO_FREE)
	{	FreeImgSprite(choice);
		FreeImgSprite(levels);
		FreeImgSprite(history);
	}
	else if(action==DO_DRAW)
	{	SDL_Rect src, dest;

		if(displaylevels)
			displaySprite(levels,g_SDL_screen,615, 600 - levels.imgH - 30);
		else
			displaySprite(choice,g_SDL_screen,615, 600 - choice.imgH - 30);
		
		src.x = 0;		src.y = progress>>1;
		src.w = 400;		src.h = 120;
		dest.x = 160;		dest.y = 440;
		SDL_BlitSurface(history.image, &src, g_SDL_screen, &dest);
		
		progress++;
		if( progress>>1 > history.imgH)
			progress=-120<<1;
	}
}

void main_credits(Uint8 show_FPS)
{	mySprite * background;
	mySprite text;

	/* font initialisation */
	{SDL_Color myText_bg={255,255,255};
	SDL_Color myText_fg={255,20,20};
	font_select(FONT_NAME,30,myText_fg,myText_bg,180);
	}
	
	text=font_long_text("[CREDITS]",0,0);
	text.posY=600 - text.imgH - 40;
	text.posX=g_SDL_screen->w/2 - text.imgH/2;
	background=draw_backgrnd(DO_INIT,"gfx/ihm/beach.jpg");

	/* r-init des vnements */
	events_init();
		
	while(!any_event_found())
	{	all_events_status events;
	
		draw_backgrnd(DO_DRAW,background);
		displaySprite(text,g_SDL_screen,0,0);

		/* envoi au hard */
		My_Flip();

		/* on bloque  30 FPS */
		coef_frame_rate(show_FPS);

		events=events_get_all();	
		if(events.f_kp)
		{	SDL_WM_ToggleFullScreen(g_SDL_screen);
			events_init();
		}
	}
	draw_backgrnd(DO_FREE,background);
	SDL_FreeSurface(text.image);
}

int level_menu(Uint8 show_FPS,char ** worldname,mySprite * background)
{
	int action=0;
	static int pos=0;
	char goout;
	
	char *level_list[]={"lvl/mole_hill/world.wld",		/* start taupiniere */
			"lvl/island/world.wld",			/* start contributors */
			"lvl/sandisland/world.wld",		/* start contributors 2 */
			"lvl/supertux_revisited/world.wld",	/* start supertux_revisited */
			"lvl/tux_strikes_back/world.wld"};	/* start tux_strikes_back */
	
	/* font initialisation */
	SDL_Color myText_bg={255,255,255};
	SDL_Color myText_fg={255,20,20};
	font_select(FONT_NAME,20,myText_fg,myText_bg,180);

	/* r-init des vnements */
	events_init();

	goout=0;
	while(!goout)
	{	all_events_status events;
	
		draw_backgrnd(DO_DRAW,background);
		draw_menu(DO_DRAW,1);
		draw_select(DO_DRAW,pos);

		/* envoi au hard */
		My_Flip();

		/* on bloque  30 FPS */
		coef_frame_rate(show_FPS);

		events_init();
		events=events_get_all();
		if(events.f_kp)
			SDL_WM_ToggleFullScreen(g_SDL_screen);
		if(events.arrow_up_kp && pos> 0 )
			pos--;
		if(events.arrow_down_kp && pos< sizeof(level_list)/sizeof(level_list[0]) )
			pos++;
		if(events.quit || events.esc)
		{	action=2;
			goout=1;
		}

		if(events.space || events.accel || events.return_kp)
		{	if(pos == sizeof(level_list)/sizeof(level_list[0]))
			{	action=2;
				goout=1;
			}
			else
			{	action=0;
				*worldname=level_list[pos];
				goout=1;
			}
		}
	}
	return action;
}

int main_menu(Uint8 show_FPS,char ** worldname)
{
	int action=0;
	mySprite * background;
	static int pos=0;
	char goout;
	
	/* font initialisation */
	SDL_Color myText_bg={255,255,255};
	SDL_Color myText_fg={255,20,20};
	font_select(FONT_NAME,20,myText_fg,myText_bg,180);

	/* r-init des vnements */
	events_init();

	background=draw_backgrnd(DO_INIT,"gfx/ihm/menu.png");
	draw_menu(DO_INIT,0);
	draw_select(DO_INIT,0);

	goout=0;
	while(!goout)
	{	all_events_status events;
	
		draw_backgrnd(DO_DRAW,background);
		draw_menu(DO_DRAW,0);
		draw_select(DO_DRAW,pos);
	
		/* envoi au hard */
		My_Flip();

		/* on bloque  30 FPS */
		coef_frame_rate(show_FPS);

		events_init();
		events=events_get_all();
		if(events.f_kp)
			SDL_WM_ToggleFullScreen(g_SDL_screen);
		if(events.arrow_up_kp && pos> 0 )
			pos--;
		if(events.arrow_down_kp && pos< 4 )
			pos++;
		if(events.quit || events.esc)
		{	action=2;
			goout=1;
		}

		if(events.space || events.accel || events.return_kp)
		{	switch(pos)
			{case 0:/* start games */
				if(level_menu(show_FPS, worldname, background) == 0)
				{	action=0;
					goout=1;
				}
				break;
			case 1: /* configure keys */
				main_edit_keys(show_FPS);
				break;
			case 2: /* configure joy */
				main_edit_joy(show_FPS);
				break;
			case 3: /* credits */
				main_credits(show_FPS);
				break;
			case 4: /* quit */
				action=2;
				goout=1;
				break;
			}
		}
	}

	draw_select(DO_FREE,0);
	draw_menu(DO_FREE,0);
	draw_backgrnd(DO_FREE,background);

	return action;
}
