// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The request was rejected because multiple requests to change this object were
// submitted simultaneously. Wait a few minutes and submit your request again.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ConcurrentModification"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the most recent credential report has expired.
// To generate a new credential report, use GenerateCredentialReport. For more
// information about credential report expiration, see Getting credential reports
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html) in
// the IAM User Guide.
type CredentialReportExpiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CredentialReportExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CredentialReportExpiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CredentialReportExpiredException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReportExpired"
	}
	return *e.ErrorCodeOverride
}
func (e *CredentialReportExpiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the credential report does not exist. To
// generate a credential report, use GenerateCredentialReport.
type CredentialReportNotPresentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CredentialReportNotPresentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CredentialReportNotPresentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CredentialReportNotPresentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReportNotPresent"
	}
	return *e.ErrorCodeOverride
}
func (e *CredentialReportNotPresentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request was rejected because the credential report is still being generated.
type CredentialReportNotReadyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CredentialReportNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CredentialReportNotReadyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CredentialReportNotReadyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReportInProgress"
	}
	return *e.ErrorCodeOverride
}
func (e *CredentialReportNotReadyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it attempted to delete a resource that has
// attached subordinate entities. The error message describes these entities.
type DeleteConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DeleteConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeleteConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeleteConflictException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DeleteConflict"
	}
	return *e.ErrorCodeOverride
}
func (e *DeleteConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the same certificate is associated with an IAM
// user in the account.
type DuplicateCertificateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateCertificateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateCertificateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateCertificateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DuplicateCertificate"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateCertificateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the SSH public key is already associated with
// the specified IAM user.
type DuplicateSSHPublicKeyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateSSHPublicKeyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateSSHPublicKeyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateSSHPublicKeyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DuplicateSSHPublicKey"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateSSHPublicKeyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it attempted to create a resource that already
// exists.
type EntityAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityAlreadyExistsException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EntityAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it referenced an entity that is temporarily
// unmodifiable, such as a user name that was deleted and then recreated. The error
// indicates that the request is likely to succeed if you try again after waiting
// several minutes. The error message describes the entity.
type EntityTemporarilyUnmodifiableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityTemporarilyUnmodifiableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityTemporarilyUnmodifiableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityTemporarilyUnmodifiableException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "EntityTemporarilyUnmodifiable"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityTemporarilyUnmodifiableException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request was rejected because the authentication code was not recognized. The
// error message describes the specific error.
type InvalidAuthenticationCodeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidAuthenticationCodeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidAuthenticationCodeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidAuthenticationCodeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidAuthenticationCode"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidAuthenticationCodeException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request was rejected because the certificate is invalid.
type InvalidCertificateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCertificateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCertificateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCertificateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidCertificate"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCertificateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because an invalid or out-of-range value was supplied
// for an input parameter.
type InvalidInputException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInputException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInputException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidInput"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInputException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the public key is malformed or otherwise
// invalid.
type InvalidPublicKeyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPublicKeyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPublicKeyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPublicKeyException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidPublicKey"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPublicKeyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the type of user for the transaction was
// incorrect.
type InvalidUserTypeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidUserTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidUserTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidUserTypeException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidUserType"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidUserTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the public key certificate and the private key
// do not match.
type KeyPairMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KeyPairMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KeyPairMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KeyPairMismatchException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "KeyPairMismatch"
	}
	return *e.ErrorCodeOverride
}
func (e *KeyPairMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it attempted to create resources beyond the
// current Amazon Web Services account limits. The error message describes the
// limit exceeded.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "LimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the certificate was malformed or expired. The
// error message describes the specific error.
type MalformedCertificateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MalformedCertificateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedCertificateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedCertificateException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MalformedCertificate"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedCertificateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the policy document was malformed. The error
// message describes the specific error.
type MalformedPolicyDocumentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedPolicyDocumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedPolicyDocumentException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "MalformedPolicyDocument"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedPolicyDocumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because it referenced a resource entity that does not
// exist. The error message describes the resource.
type NoSuchEntityException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoSuchEntityException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoSuchEntityException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoSuchEntityException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NoSuchEntity"
	}
	return *e.ErrorCodeOverride
}
func (e *NoSuchEntityException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the provided password did not meet the
// requirements imposed by the account password policy.
type PasswordPolicyViolationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PasswordPolicyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PasswordPolicyViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PasswordPolicyViolationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PasswordPolicyViolation"
	}
	return *e.ErrorCodeOverride
}
func (e *PasswordPolicyViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request failed because a provided policy could not be successfully
// evaluated. An additional detailed message indicates the source of the failure.
type PolicyEvaluationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyEvaluationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyEvaluationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyEvaluationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PolicyEvaluation"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyEvaluationException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The request failed because Amazon Web Services service role policies can only be
// attached to the service-linked role for that service.
type PolicyNotAttachableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyNotAttachableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyNotAttachableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyNotAttachableException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "PolicyNotAttachable"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyNotAttachableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request failed because the maximum number of concurrent requests for this
// account are already running.
type ReportGenerationLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReportGenerationLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReportGenerationLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReportGenerationLimitExceededException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ReportGenerationLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ReportGenerationLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The request processing has failed because of an unknown error, exception or
// failure.
type ServiceFailureException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceFailureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceFailureException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ServiceFailure"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceFailureException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The specified service does not support service-specific credentials.
type ServiceNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceNotSupportedException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "NotSupportedService"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because only the service that depends on the
// service-linked role can modify or delete the role on your behalf. The error
// message includes the name of the service that depends on this service-linked
// role. You must request the change through that service.
type UnmodifiableEntityException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnmodifiableEntityException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnmodifiableEntityException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnmodifiableEntityException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "UnmodifiableEntity"
	}
	return *e.ErrorCodeOverride
}
func (e *UnmodifiableEntityException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request was rejected because the public key encoding format is unsupported
// or unrecognized.
type UnrecognizedPublicKeyEncodingException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnrecognizedPublicKeyEncodingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnrecognizedPublicKeyEncodingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnrecognizedPublicKeyEncodingException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "UnrecognizedPublicKeyEncoding"
	}
	return *e.ErrorCodeOverride
}
func (e *UnrecognizedPublicKeyEncodingException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
