// Code generated by sdkgen. DO NOT EDIT.

// nolint
package organizationmanager

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	organizationmanager "github.com/yandex-cloud/go-genproto/yandex/cloud/organizationmanager/v1"
)

//revive:disable

// UserSshKeyServiceClient is a organizationmanager.UserSshKeyServiceClient with
// lazy GRPC connection initialization.
type UserSshKeyServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements organizationmanager.UserSshKeyServiceClient
func (c *UserSshKeyServiceClient) Create(ctx context.Context, in *organizationmanager.CreateUserSshKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserSshKeyServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements organizationmanager.UserSshKeyServiceClient
func (c *UserSshKeyServiceClient) Delete(ctx context.Context, in *organizationmanager.DeleteUserSshKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserSshKeyServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements organizationmanager.UserSshKeyServiceClient
func (c *UserSshKeyServiceClient) Get(ctx context.Context, in *organizationmanager.GetUserSshKeyRequest, opts ...grpc.CallOption) (*organizationmanager.UserSshKey, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserSshKeyServiceClient(conn).Get(ctx, in, opts...)
}

// List implements organizationmanager.UserSshKeyServiceClient
func (c *UserSshKeyServiceClient) List(ctx context.Context, in *organizationmanager.ListUserSshKeysRequest, opts ...grpc.CallOption) (*organizationmanager.ListUserSshKeysResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserSshKeyServiceClient(conn).List(ctx, in, opts...)
}

type UserSshKeyIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *UserSshKeyServiceClient
	request *organizationmanager.ListUserSshKeysRequest

	items []*organizationmanager.UserSshKey
}

func (c *UserSshKeyServiceClient) UserSshKeyIterator(ctx context.Context, req *organizationmanager.ListUserSshKeysRequest, opts ...grpc.CallOption) *UserSshKeyIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &UserSshKeyIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *UserSshKeyIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.SshKeys
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *UserSshKeyIterator) Take(size int64) ([]*organizationmanager.UserSshKey, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*organizationmanager.UserSshKey

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *UserSshKeyIterator) TakeAll() ([]*organizationmanager.UserSshKey, error) {
	return it.Take(0)
}

func (it *UserSshKeyIterator) Value() *organizationmanager.UserSshKey {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *UserSshKeyIterator) Error() error {
	return it.err
}

// Update implements organizationmanager.UserSshKeyServiceClient
func (c *UserSshKeyServiceClient) Update(ctx context.Context, in *organizationmanager.UpdateUserSshKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return organizationmanager.NewUserSshKeyServiceClient(conn).Update(ctx, in, opts...)
}
