// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/mongodb/v1/cluster.proto

package mongodb

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	config "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/mongodb/v1/config"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy: only hotfixes
	// are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions
	// are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// State of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is alive and well ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

type Host_Type int32

const (
	// Type of the host is unspecified. Default value.
	Host_TYPE_UNSPECIFIED Host_Type = 0
	// A mongod host.
	Host_MONGOD Host_Type = 1
	// A mongos host.
	Host_MONGOS Host_Type = 2
	// A mongocfg host.
	Host_MONGOCFG Host_Type = 3
	// A mongoinfra (mongos+mongocfg) host.
	Host_MONGOINFRA Host_Type = 4
)

// Enum value maps for Host_Type.
var (
	Host_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MONGOD",
		2: "MONGOS",
		3: "MONGOCFG",
		4: "MONGOINFRA",
	}
	Host_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MONGOD":           1,
		"MONGOS":           2,
		"MONGOCFG":         3,
		"MONGOINFRA":       4,
	}
)

func (x Host_Type) Enum() *Host_Type {
	p := new(Host_Type)
	*p = x
	return p
}

func (x Host_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[3].Descriptor()
}

func (Host_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[3]
}

func (x Host_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Type.Descriptor instead.
func (Host_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 0}
}

type Host_Role int32

const (
	// Role of the host in the cluster is unknown. Default value.
	Host_ROLE_UNKNOWN Host_Role = 0
	// Host is the primary MongoDB server in the cluster.
	Host_PRIMARY Host_Role = 1
	// Host is a secondary MongoDB server in the cluster.
	Host_SECONDARY Host_Role = 2
)

// Enum value maps for Host_Role.
var (
	Host_Role_name = map[int32]string{
		0: "ROLE_UNKNOWN",
		1: "PRIMARY",
		2: "SECONDARY",
	}
	Host_Role_value = map[string]int32{
		"ROLE_UNKNOWN": 0,
		"PRIMARY":      1,
		"SECONDARY":    2,
	}
)

func (x Host_Role) Enum() *Host_Role {
	p := new(Host_Role)
	*p = x
	return p
}

func (x Host_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[4].Descriptor()
}

func (Host_Role) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[4]
}

func (x Host_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Role.Descriptor instead.
func (Host_Role) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 1}
}

type Host_Health int32

const (
	// Health of the host is unknown. Default value.
	Host_HEALTH_UNKNOWN Host_Health = 0
	// The host is performing all its functions normally.
	Host_ALIVE Host_Health = 1
	// The host is inoperable, and cannot perform any of its essential functions.
	Host_DEAD Host_Health = 2
	// The host is degraded, and can perform only some of its essential functions.
	Host_DEGRADED Host_Health = 3
)

// Enum value maps for Host_Health.
var (
	Host_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
	}
	Host_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
	}
)

func (x Host_Health) Enum() *Host_Health {
	p := new(Host_Health)
	*p = x
	return p
}

func (x Host_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Host_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[5].Descriptor()
}

func (Host_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[5]
}

func (x Host_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Host_Health.Descriptor instead.
func (Host_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 2}
}

type Service_Type int32

const (
	// Service type of the host is unspecified. Default value.
	Service_TYPE_UNSPECIFIED Service_Type = 0
	// The host is running a mongod daemon.
	Service_MONGOD Service_Type = 1
	// The host is running a mongos daemon.
	Service_MONGOS Service_Type = 2
	// The host is running a MongoDB config server.
	Service_MONGOCFG Service_Type = 3
)

// Enum value maps for Service_Type.
var (
	Service_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MONGOD",
		2: "MONGOS",
		3: "MONGOCFG",
	}
	Service_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MONGOD":           1,
		"MONGOS":           2,
		"MONGOCFG":         3,
	}
)

func (x Service_Type) Enum() *Service_Type {
	p := new(Service_Type)
	*p = x
	return p
}

func (x Service_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[6].Descriptor()
}

func (Service_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[6]
}

func (x Service_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Type.Descriptor instead.
func (Service_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{15, 0}
}

type Service_Health int32

const (
	// Health of the server is unknown.
	Service_HEALTH_UNKNOWN Service_Health = 0
	// The server is working normally.
	Service_ALIVE Service_Health = 1
	// The server is dead or unresponsive.
	Service_DEAD Service_Health = 2
)

// Enum value maps for Service_Health.
var (
	Service_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
	}
	Service_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
	}
)

func (x Service_Health) Enum() *Service_Health {
	p := new(Service_Health)
	*p = x
	return p
}

func (x Service_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Service_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[7].Descriptor()
}

func (Service_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes[7]
}

func (x Service_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Service_Health.Descriptor instead.
func (Service_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{15, 1}
}

// A managed MongoDB cluster. For more information, see the [documentation](/docs/managed-mongodb/concepts).
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the MongoDB cluster.
	// This ID is assigned by MDB at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the MongoDB cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the MongoDB cluster.
	// The name is unique within the folder. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the MongoDB cluster. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the MongoDB cluster as “ key:value “ pairs. Maximum 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deployment environment of the MongoDB cluster.
	Environment Cluster_Environment `protobuf:"varint,7,opt,name=environment,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the MongoDB cluster.
	Monitoring []*Monitoring `protobuf:"bytes,8,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the MongoDB cluster.
	Config *ClusterConfig `protobuf:"bytes,9,opt,name=config,proto3" json:"config,omitempty"`
	// ID of the network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,10,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,11,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,12,opt,name=status,proto3,enum=yandex.cloud.mdb.mongodb.v1.Cluster_Status" json:"status,omitempty"`
	// Indicates current sharding status of the cluster.
	Sharded bool `protobuf:"varint,13,opt,name=sharded,proto3" json:"sharded,omitempty"`
	// Maintenance window for the cluster.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,14,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Planned maintenance operation to be started for the cluster within the nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,15,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// User security groups
	SecurityGroupIds []string `protobuf:"bytes,16,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Deletion Protection inhibits deletion of the cluster
	DeletionProtection bool `protobuf:"varint,17,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetConfig() *ClusterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetSharded() bool {
	if x != nil {
		return x.Sharded
	}
	return false
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

// Monitoring system.
type Monitoring struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the MongoDB cluster.
	Link string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type ClusterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of MongoDB server software. Possible values: `3.6`, `4.0`, `4.2`, `4.4`, `4.4-enterprise`, `5.0`, `5.0-enterprise`, `6.0`, `6.0-enterprise`, `7.0`, `7.0-enterprise`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// MongoDB feature compatibility version. See usage details in [MongoDB documentation](https://docs.mongodb.com/manual/reference/command/setFeatureCompatibilityVersion/).
	//
	// Possible values:
	// * `3.6` - persist data compatibility for version 3.6. After setting this option the data will not be compatible with 3.4 or lower.
	// * `4.0` - persist data compatibility for version 4.0. After setting this option the data will not be compatible with 3.6 or lower.
	// * `4.2` - persist data compatibility for version 4.2. After setting this option the data will not be compatible with 4.0 or lower.
	// * `4.4` - persist data compatibility for version 4.4. After setting this option the data will not be compatible with 4.2 or lower.
	// * `5.0` - persist data compatibility for version 5.0. After setting this option the data will not be compatible with 5.0 or lower.
	// * `6.0` - persist data compatibility for version 6.0. After setting this option the data will not be compatible with 6.0 or lower.
	FeatureCompatibilityVersion string `protobuf:"bytes,5,opt,name=feature_compatibility_version,json=featureCompatibilityVersion,proto3" json:"feature_compatibility_version,omitempty"`
	// Configuration for MongoDB servers in the cluster.
	//
	// Types that are assignable to Mongodb:
	//
	//	*ClusterConfig_Mongodb_3_6
	//	*ClusterConfig_Mongodb_4_0
	//	*ClusterConfig_Mongodb_4_2
	//	*ClusterConfig_Mongodb_4_4
	//	*ClusterConfig_Mongodb_5_0
	//	*ClusterConfig_Mongodb_6_0
	//	*ClusterConfig_Mongodb_4_4Enterprise
	//	*ClusterConfig_Mongodb_5_0Enterprise
	//	*ClusterConfig_Mongodb_6_0Enterprise
	Mongodb isClusterConfig_Mongodb `protobuf_oneof:"mongodb"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Retain period of automatically created backup in days
	BackupRetainPeriodDays *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	// Performance Diagnostic
	PerformanceDiagnostics *PerformanceDiagnosticsConfig `protobuf:"bytes,13,opt,name=performance_diagnostics,json=performanceDiagnostics,proto3" json:"performance_diagnostics,omitempty"`
	// Access policy to DB
	Access *Access `protobuf:"bytes,6,opt,name=access,proto3" json:"access,omitempty"`
	// Configuration and resource allocation for a MongoDB Enterprise cluster.
	MongodbConfig *Mongodb `protobuf:"bytes,19,opt,name=mongodb_config,json=mongodbConfig,proto3" json:"mongodb_config,omitempty"`
}

func (x *ClusterConfig) Reset() {
	*x = ClusterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfig) ProtoMessage() {}

func (x *ClusterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfig.ProtoReflect.Descriptor instead.
func (*ClusterConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ClusterConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ClusterConfig) GetFeatureCompatibilityVersion() string {
	if x != nil {
		return x.FeatureCompatibilityVersion
	}
	return ""
}

func (m *ClusterConfig) GetMongodb() isClusterConfig_Mongodb {
	if m != nil {
		return m.Mongodb
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_3_6() *Mongodb3_6 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_3_6); ok {
		return x.Mongodb_3_6
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_0() *Mongodb4_0 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_0); ok {
		return x.Mongodb_4_0
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_2() *Mongodb4_2 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_2); ok {
		return x.Mongodb_4_2
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_4() *Mongodb4_4 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_4); ok {
		return x.Mongodb_4_4
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_5_0() *Mongodb5_0 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_5_0); ok {
		return x.Mongodb_5_0
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_6_0() *Mongodb6_0 {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_6_0); ok {
		return x.Mongodb_6_0
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_4_4Enterprise() *Mongodb4_4Enterprise {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_4_4Enterprise); ok {
		return x.Mongodb_4_4Enterprise
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_5_0Enterprise() *Mongodb5_0Enterprise {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_5_0Enterprise); ok {
		return x.Mongodb_5_0Enterprise
	}
	return nil
}

func (x *ClusterConfig) GetMongodb_6_0Enterprise() *Mongodb6_0Enterprise {
	if x, ok := x.GetMongodb().(*ClusterConfig_Mongodb_6_0Enterprise); ok {
		return x.Mongodb_6_0Enterprise
	}
	return nil
}

func (x *ClusterConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *ClusterConfig) GetBackupRetainPeriodDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

func (x *ClusterConfig) GetPerformanceDiagnostics() *PerformanceDiagnosticsConfig {
	if x != nil {
		return x.PerformanceDiagnostics
	}
	return nil
}

func (x *ClusterConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *ClusterConfig) GetMongodbConfig() *Mongodb {
	if x != nil {
		return x.MongodbConfig
	}
	return nil
}

type isClusterConfig_Mongodb interface {
	isClusterConfig_Mongodb()
}

type ClusterConfig_Mongodb_3_6 struct {
	// Configuration and resource allocation for a MongoDB 3.6 cluster.
	Mongodb_3_6 *Mongodb3_6 `protobuf:"bytes,2,opt,name=mongodb_3_6,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_0 struct {
	// Configuration and resource allocation for a MongoDB 4.0 cluster.
	Mongodb_4_0 *Mongodb4_0 `protobuf:"bytes,4,opt,name=mongodb_4_0,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_2 struct {
	// Configuration and resource allocation for a MongoDB 4.2 cluster.
	Mongodb_4_2 *Mongodb4_2 `protobuf:"bytes,7,opt,name=mongodb_4_2,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_4 struct {
	// Configuration and resource allocation for a MongoDB 4.4 cluster.
	Mongodb_4_4 *Mongodb4_4 `protobuf:"bytes,8,opt,name=mongodb_4_4,proto3,oneof"`
}

type ClusterConfig_Mongodb_5_0 struct {
	// Configuration and resource allocation for a MongoDB 5.0 cluster.
	Mongodb_5_0 *Mongodb5_0 `protobuf:"bytes,10,opt,name=mongodb_5_0,proto3,oneof"`
}

type ClusterConfig_Mongodb_6_0 struct {
	// Configuration and resource allocation for a MongoDB 6.0 cluster.
	Mongodb_6_0 *Mongodb6_0 `protobuf:"bytes,14,opt,name=mongodb_6_0,proto3,oneof"`
}

type ClusterConfig_Mongodb_4_4Enterprise struct {
	// Configuration and resource allocation for a MongoDB 4.4 Enterprise cluster.
	Mongodb_4_4Enterprise *Mongodb4_4Enterprise `protobuf:"bytes,11,opt,name=mongodb_4_4_enterprise,proto3,oneof"`
}

type ClusterConfig_Mongodb_5_0Enterprise struct {
	// Configuration and resource allocation for a MongoDB 5.0 Enterprise cluster.
	Mongodb_5_0Enterprise *Mongodb5_0Enterprise `protobuf:"bytes,12,opt,name=mongodb_5_0_enterprise,proto3,oneof"`
}

type ClusterConfig_Mongodb_6_0Enterprise struct {
	// Configuration and resource allocation for a MongoDB 6.0 Enterprise cluster.
	Mongodb_6_0Enterprise *Mongodb6_0Enterprise `protobuf:"bytes,15,opt,name=mongodb_6_0_enterprise,proto3,oneof"`
}

func (*ClusterConfig_Mongodb_3_6) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_2) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_4) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_5_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_6_0) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_4_4Enterprise) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_5_0Enterprise) isClusterConfig_Mongodb() {}

func (*ClusterConfig_Mongodb_6_0Enterprise) isClusterConfig_Mongodb() {}

type Mongodb3_6 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 3.6 cluster.
	Mongod *Mongodb3_6_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 3.6 cluster.
	Mongocfg *Mongodb3_6_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 3.6 cluster.
	Mongos *Mongodb3_6_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 3.6 cluster.
	Mongoinfra *Mongodb3_6_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb3_6) Reset() {
	*x = Mongodb3_6{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6) ProtoMessage() {}

func (x *Mongodb3_6) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6.ProtoReflect.Descriptor instead.
func (*Mongodb3_6) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *Mongodb3_6) GetMongod() *Mongodb3_6_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb3_6) GetMongocfg() *Mongodb3_6_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb3_6) GetMongos() *Mongodb3_6_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb3_6) GetMongoinfra() *Mongodb3_6_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_0 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.0 cluster.
	Mongod *Mongodb4_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.0 cluster.
	Mongocfg *Mongodb4_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.0 cluster.
	Mongos *Mongodb4_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.0 cluster.
	Mongoinfra *Mongodb4_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_0) Reset() {
	*x = Mongodb4_0{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0) ProtoMessage() {}

func (x *Mongodb4_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0.ProtoReflect.Descriptor instead.
func (*Mongodb4_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Mongodb4_0) GetMongod() *Mongodb4_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_0) GetMongocfg() *Mongodb4_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_0) GetMongos() *Mongodb4_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_0) GetMongoinfra() *Mongodb4_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_2 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.2 cluster.
	Mongod *Mongodb4_2_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.2 cluster.
	Mongocfg *Mongodb4_2_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.2 cluster.
	Mongos *Mongodb4_2_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.2 cluster.
	Mongoinfra *Mongodb4_2_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_2) Reset() {
	*x = Mongodb4_2{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2) ProtoMessage() {}

func (x *Mongodb4_2) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2.ProtoReflect.Descriptor instead.
func (*Mongodb4_2) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *Mongodb4_2) GetMongod() *Mongodb4_2_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_2) GetMongocfg() *Mongodb4_2_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_2) GetMongos() *Mongodb4_2_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_2) GetMongoinfra() *Mongodb4_2_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_4 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.4 cluster.
	Mongod *Mongodb4_4_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster.
	Mongocfg *Mongodb4_4_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.4 cluster.
	Mongos *Mongodb4_4_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster.
	Mongoinfra *Mongodb4_4_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_4) Reset() {
	*x = Mongodb4_4{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4) ProtoMessage() {}

func (x *Mongodb4_4) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4.ProtoReflect.Descriptor instead.
func (*Mongodb4_4) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *Mongodb4_4) GetMongod() *Mongodb4_4_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_4) GetMongocfg() *Mongodb4_4_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_4) GetMongos() *Mongodb4_4_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_4) GetMongoinfra() *Mongodb4_4_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb4_4Enterprise struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 4.4 cluster.
	Mongod *Mongodb4_4Enterprise_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 4.4 cluster.
	Mongocfg *Mongodb4_4Enterprise_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 4.4 cluster.
	Mongos *Mongodb4_4Enterprise_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 4.4 cluster.
	Mongoinfra *Mongodb4_4Enterprise_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb4_4Enterprise) Reset() {
	*x = Mongodb4_4Enterprise{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise) ProtoMessage() {}

func (x *Mongodb4_4Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *Mongodb4_4Enterprise) GetMongod() *Mongodb4_4Enterprise_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb4_4Enterprise) GetMongocfg() *Mongodb4_4Enterprise_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb4_4Enterprise) GetMongos() *Mongodb4_4Enterprise_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb4_4Enterprise) GetMongoinfra() *Mongodb4_4Enterprise_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb5_0 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 5.0 cluster.
	Mongod *Mongodb5_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 5.0 cluster.
	Mongocfg *Mongodb5_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 5.0 cluster.
	Mongos *Mongodb5_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 5.0 cluster.
	Mongoinfra *Mongodb5_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb5_0) Reset() {
	*x = Mongodb5_0{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0) ProtoMessage() {}

func (x *Mongodb5_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0.ProtoReflect.Descriptor instead.
func (*Mongodb5_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *Mongodb5_0) GetMongod() *Mongodb5_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb5_0) GetMongocfg() *Mongodb5_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb5_0) GetMongos() *Mongodb5_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb5_0) GetMongoinfra() *Mongodb5_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb5_0Enterprise struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 5.0 cluster.
	Mongod *Mongodb5_0Enterprise_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 5.0 cluster.
	Mongocfg *Mongodb5_0Enterprise_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 5.0 cluster.
	Mongos *Mongodb5_0Enterprise_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 5.0 cluster.
	Mongoinfra *Mongodb5_0Enterprise_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb5_0Enterprise) Reset() {
	*x = Mongodb5_0Enterprise{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise) ProtoMessage() {}

func (x *Mongodb5_0Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *Mongodb5_0Enterprise) GetMongod() *Mongodb5_0Enterprise_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb5_0Enterprise) GetMongocfg() *Mongodb5_0Enterprise_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb5_0Enterprise) GetMongos() *Mongodb5_0Enterprise_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb5_0Enterprise) GetMongoinfra() *Mongodb5_0Enterprise_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb6_0 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 6.0 cluster.
	Mongod *Mongodb6_0_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 6.0 cluster.
	Mongocfg *Mongodb6_0_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 6.0 cluster.
	Mongos *Mongodb6_0_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 6.0 cluster.
	Mongoinfra *Mongodb6_0_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb6_0) Reset() {
	*x = Mongodb6_0{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0) ProtoMessage() {}

func (x *Mongodb6_0) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0.ProtoReflect.Descriptor instead.
func (*Mongodb6_0) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *Mongodb6_0) GetMongod() *Mongodb6_0_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb6_0) GetMongocfg() *Mongodb6_0_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb6_0) GetMongos() *Mongodb6_0_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb6_0) GetMongoinfra() *Mongodb6_0_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb6_0Enterprise struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB 6.0 cluster.
	Mongod *Mongodb6_0Enterprise_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB 6.0 cluster.
	Mongocfg *Mongodb6_0Enterprise_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB 6.0 cluster.
	Mongos *Mongodb6_0Enterprise_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB 6.0 cluster.
	Mongoinfra *Mongodb6_0Enterprise_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb6_0Enterprise) Reset() {
	*x = Mongodb6_0Enterprise{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise) ProtoMessage() {}

func (x *Mongodb6_0Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *Mongodb6_0Enterprise) GetMongod() *Mongodb6_0Enterprise_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb6_0Enterprise) GetMongocfg() *Mongodb6_0Enterprise_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb6_0Enterprise) GetMongos() *Mongodb6_0Enterprise_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb6_0Enterprise) GetMongoinfra() *Mongodb6_0Enterprise_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Mongodb struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration and resource allocation for mongod in a MongoDB cluster.
	Mongod *Mongodb_Mongod `protobuf:"bytes,1,opt,name=mongod,proto3" json:"mongod,omitempty"`
	// Configuration and resource allocation for mongocfg in a MongoDB cluster.
	Mongocfg *Mongodb_MongoCfg `protobuf:"bytes,2,opt,name=mongocfg,proto3" json:"mongocfg,omitempty"`
	// Configuration and resource allocation for mongos in a MongoDB cluster.
	Mongos *Mongodb_Mongos `protobuf:"bytes,3,opt,name=mongos,proto3" json:"mongos,omitempty"`
	// Configuration and resource allocation for mongoinfra (mongos+mongocfg) in a MongoDB cluster.
	Mongoinfra *Mongodb_MongoInfra `protobuf:"bytes,4,opt,name=mongoinfra,proto3" json:"mongoinfra,omitempty"`
}

func (x *Mongodb) Reset() {
	*x = Mongodb{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb) ProtoMessage() {}

func (x *Mongodb) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb.ProtoReflect.Descriptor instead.
func (*Mongodb) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *Mongodb) GetMongod() *Mongodb_Mongod {
	if x != nil {
		return x.Mongod
	}
	return nil
}

func (x *Mongodb) GetMongocfg() *Mongodb_MongoCfg {
	if x != nil {
		return x.Mongocfg
	}
	return nil
}

func (x *Mongodb) GetMongos() *Mongodb_Mongos {
	if x != nil {
		return x.Mongos
	}
	return nil
}

func (x *Mongodb) GetMongoinfra() *Mongodb_MongoInfra {
	if x != nil {
		return x.Mongoinfra
	}
	return nil
}

type Shard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the shard.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the cluster that the shard belongs to.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
}

func (x *Shard) Reset() {
	*x = Shard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shard) ProtoMessage() {}

func (x *Shard) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shard.ProtoReflect.Descriptor instead.
func (*Shard) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *Shard) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Shard) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

type Host struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the MongoDB host. The host name is assigned by MDB at creation time, and cannot be changed.
	// 1-63 characters long.
	//
	// The name is unique across all MDB hosts that exist on the platform, as it defines the FQDN of the host.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the MongoDB host. The ID is assigned by MDB at creation time.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// ID of the availability zone where the MongoDB host resides.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Resources allocated to the MongoDB host.
	Resources *Resources `protobuf:"bytes,4,opt,name=resources,proto3" json:"resources,omitempty"`
	// Role of the host in the cluster. If the field has default value, it is not returned in the response.
	Role Host_Role `protobuf:"varint,5,opt,name=role,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Role" json:"role,omitempty"`
	// Aggregated health of the host. If the field has default value, it is not returned in the response.
	Health Host_Health `protobuf:"varint,6,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Health" json:"health,omitempty"`
	// Services provided by the host.
	Services []*Service `protobuf:"bytes,7,rep,name=services,proto3" json:"services,omitempty"`
	// ID of the subnet that the host belongs to.
	SubnetId string `protobuf:"bytes,8,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Flag showing public IP assignment status to this host.
	AssignPublicIp bool `protobuf:"varint,9,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Shard which this host belongs to.
	ShardName string `protobuf:"bytes,10,opt,name=shard_name,json=shardName,proto3" json:"shard_name,omitempty"`
	// Host type. If the field has default value, it is not returned in the response.
	Type Host_Type `protobuf:"varint,11,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Host_Type" json:"type,omitempty"`
	// Host parameters
	HostParameters *Host_HostParameters `protobuf:"bytes,12,opt,name=host_parameters,json=hostParameters,proto3" json:"host_parameters,omitempty"`
}

func (x *Host) Reset() {
	*x = Host{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host) ProtoMessage() {}

func (x *Host) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host.ProtoReflect.Descriptor instead.
func (*Host) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14}
}

func (x *Host) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Host) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Host) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Host) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Host) GetRole() Host_Role {
	if x != nil {
		return x.Role
	}
	return Host_ROLE_UNKNOWN
}

func (x *Host) GetHealth() Host_Health {
	if x != nil {
		return x.Health
	}
	return Host_HEALTH_UNKNOWN
}

func (x *Host) GetServices() []*Service {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Host) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Host) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *Host) GetShardName() string {
	if x != nil {
		return x.ShardName
	}
	return ""
}

func (x *Host) GetType() Host_Type {
	if x != nil {
		return x.Type
	}
	return Host_TYPE_UNSPECIFIED
}

func (x *Host) GetHostParameters() *Host_HostParameters {
	if x != nil {
		return x.HostParameters
	}
	return nil
}

type Service struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the service provided by the host. If the field has default value, it is not returned in the response.
	Type Service_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Type" json:"type,omitempty"`
	// Aggregated health of the service. If the field has default value, it is not returned in the response.
	Health Service_Health `protobuf:"varint,2,opt,name=health,proto3,enum=yandex.cloud.mdb.mongodb.v1.Service_Health" json:"health,omitempty"`
}

func (x *Service) Reset() {
	*x = Service{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{15}
}

func (x *Service) GetType() Service_Type {
	if x != nil {
		return x.Type
	}
	return Service_TYPE_UNSPECIFIED
}

func (x *Service) GetHealth() Service_Health {
	if x != nil {
		return x.Health
	}
	return Service_HEALTH_UNKNOWN
}

type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the preset for computational resources available to a host (CPU, memory etc.).
	// All available presets are listed in the [documentation](/docs/managed-mongodb/concepts/instance-types).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host, in bytes.
	DiskSize int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	// Type of the storage environment for the host.
	// Possible values:
	// * network-hdd - network HDD drive,
	// * network-ssd - network SSD drive,
	// * local-ssd - local SSD storage.
	DiskTypeId string `protobuf:"bytes,3,opt,name=disk_type_id,json=diskTypeId,proto3" json:"disk_type_id,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{16}
}

func (x *Resources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *Resources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

func (x *Resources) GetDiskTypeId() string {
	if x != nil {
		return x.DiskTypeId
	}
	return ""
}

type Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allow access for DataLens.
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allow access for Web SQL.
	WebSql bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	// Allow access for DataTransfer.
	DataTransfer bool `protobuf:"varint,3,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
}

func (x *Access) Reset() {
	*x = Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{17}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

func (x *Access) GetWebSql() bool {
	if x != nil {
		return x.WebSql
	}
	return false
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

type PerformanceDiagnosticsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ProfilingEnabled bool `protobuf:"varint,1,opt,name=profiling_enabled,json=profilingEnabled,proto3" json:"profiling_enabled,omitempty"`
}

func (x *PerformanceDiagnosticsConfig) Reset() {
	*x = PerformanceDiagnosticsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PerformanceDiagnosticsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerformanceDiagnosticsConfig) ProtoMessage() {}

func (x *PerformanceDiagnosticsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerformanceDiagnosticsConfig.ProtoReflect.Descriptor instead.
func (*PerformanceDiagnosticsConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{18}
}

func (x *PerformanceDiagnosticsConfig) GetProfilingEnabled() bool {
	if x != nil {
		return x.ProfilingEnabled
	}
	return false
}

type DiskSizeAutoscaling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Amount of used storage for automatic disk scaling in the maintenance window, 0 means disabled, in percent.
	PlannedUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=planned_usage_threshold,json=plannedUsageThreshold,proto3" json:"planned_usage_threshold,omitempty"`
	// Amount of used storage for immediately  automatic disk scaling, 0 means disabled, in percent.
	EmergencyUsageThreshold *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=emergency_usage_threshold,json=emergencyUsageThreshold,proto3" json:"emergency_usage_threshold,omitempty"`
	// Limit on how large the storage for database instances can automatically grow, in bytes.
	DiskSizeLimit *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=disk_size_limit,json=diskSizeLimit,proto3" json:"disk_size_limit,omitempty"`
}

func (x *DiskSizeAutoscaling) Reset() {
	*x = DiskSizeAutoscaling{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskSizeAutoscaling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskSizeAutoscaling) ProtoMessage() {}

func (x *DiskSizeAutoscaling) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskSizeAutoscaling.ProtoReflect.Descriptor instead.
func (*DiskSizeAutoscaling) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{19}
}

func (x *DiskSizeAutoscaling) GetPlannedUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.PlannedUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetEmergencyUsageThreshold() *wrapperspb.Int64Value {
	if x != nil {
		return x.EmergencyUsageThreshold
	}
	return nil
}

func (x *DiskSizeAutoscaling) GetDiskSizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.DiskSizeLimit
	}
	return nil
}

type Mongodb3_6_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for a mongod 3.6 hosts.
	Config *config.MongodConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to MongoDB hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb3_6_Mongod) Reset() {
	*x = Mongodb3_6_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_Mongod) ProtoMessage() {}

func (x *Mongodb3_6_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Mongodb3_6_Mongod) GetConfig() *config.MongodConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb3_6_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Config *config.MongoCfgConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb3_6_MongoCfg) Reset() {
	*x = Mongodb3_6_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_MongoCfg) ProtoMessage() {}

func (x *Mongodb3_6_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Mongodb3_6_MongoCfg) GetConfig() *config.MongoCfgConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb3_6_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Config *config.MongosConfigSet3_6 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb3_6_Mongos) Reset() {
	*x = Mongodb3_6_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_Mongos) ProtoMessage() {}

func (x *Mongodb3_6_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Mongodb3_6_Mongos) GetConfig() *config.MongosConfigSet3_6 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb3_6_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb3_6_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet3_6   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet3_6 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb3_6_MongoInfra) Reset() {
	*x = Mongodb3_6_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb3_6_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb3_6_MongoInfra) ProtoMessage() {}

func (x *Mongodb3_6_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb3_6_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb3_6_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{3, 3}
}

func (x *Mongodb3_6_MongoInfra) GetConfigMongos() *config.MongosConfigSet3_6 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet3_6 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb3_6_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.0 hosts.
	Config *config.MongodConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_0_Mongod) Reset() {
	*x = Mongodb4_0_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_Mongod) ProtoMessage() {}

func (x *Mongodb4_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Mongodb4_0_Mongod) GetConfig() *config.MongodConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.0 hosts.
	Config *config.MongoCfgConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_0_MongoCfg) Reset() {
	*x = Mongodb4_0_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Mongodb4_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.0 hosts.
	Config *config.MongosConfigSet4_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_0_Mongos) Reset() {
	*x = Mongodb4_0_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_Mongos) ProtoMessage() {}

func (x *Mongodb4_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Mongodb4_0_Mongos) GetConfig() *config.MongosConfigSet4_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_0_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_0_MongoInfra) Reset() {
	*x = Mongodb4_0_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{4, 3}
}

func (x *Mongodb4_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_0_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.2 hosts.
	Config *config.MongodConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_2_Mongod) Reset() {
	*x = Mongodb4_2_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_Mongod) ProtoMessage() {}

func (x *Mongodb4_2_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Mongodb4_2_Mongod) GetConfig() *config.MongodConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.2 hosts.
	Config *config.MongoCfgConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_2_MongoCfg) Reset() {
	*x = Mongodb4_2_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_2_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Mongodb4_2_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.2 hosts.
	Config *config.MongosConfigSet4_2 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_2_Mongos) Reset() {
	*x = Mongodb4_2_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_Mongos) ProtoMessage() {}

func (x *Mongodb4_2_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 2}
}

func (x *Mongodb4_2_Mongos) GetConfig() *config.MongosConfigSet4_2 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_2_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_2_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_2   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_2 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_2_MongoInfra) Reset() {
	*x = Mongodb4_2_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_2_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_2_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_2_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_2_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_2_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{5, 3}
}

func (x *Mongodb4_2_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_2 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_2 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_2_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.4 hosts.
	Config *config.MongodConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4_Mongod) Reset() {
	*x = Mongodb4_4_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_Mongod) ProtoMessage() {}

func (x *Mongodb4_4_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Mongodb4_4_Mongod) GetConfig() *config.MongodConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.4 hosts.
	Config *config.MongoCfgConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4_MongoCfg) Reset() {
	*x = Mongodb4_4_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_4_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Mongodb4_4_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.4 hosts.
	Config *config.MongosConfigSet4_4 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4_Mongos) Reset() {
	*x = Mongodb4_4_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_Mongos) ProtoMessage() {}

func (x *Mongodb4_4_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Mongodb4_4_Mongos) GetConfig() *config.MongosConfigSet4_4 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_4   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_4 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4_MongoInfra) Reset() {
	*x = Mongodb4_4_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_4_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_4_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Mongodb4_4_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_4 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_4 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 4.4 hosts.
	Config *config.MongodConfigSet4_4Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4Enterprise_Mongod) Reset() {
	*x = Mongodb4_4Enterprise_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4Enterprise_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_Mongod) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Mongodb4_4Enterprise_Mongod) GetConfig() *config.MongodConfigSet4_4Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 4.4 hosts.
	Config *config.MongoCfgConfigSet4_4Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4Enterprise_MongoCfg) Reset() {
	*x = Mongodb4_4Enterprise_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4Enterprise_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_MongoCfg) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 1}
}

func (x *Mongodb4_4Enterprise_MongoCfg) GetConfig() *config.MongoCfgConfigSet4_4Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 4.4 hosts.
	Config *config.MongosConfigSet4_4Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4Enterprise_Mongos) Reset() {
	*x = Mongodb4_4Enterprise_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4Enterprise_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_Mongos) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 2}
}

func (x *Mongodb4_4Enterprise_Mongos) GetConfig() *config.MongosConfigSet4_4Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb4_4Enterprise_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet4_4Enterprise   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet4_4Enterprise `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb4_4Enterprise_MongoInfra) Reset() {
	*x = Mongodb4_4Enterprise_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb4_4Enterprise_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb4_4Enterprise_MongoInfra) ProtoMessage() {}

func (x *Mongodb4_4Enterprise_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb4_4Enterprise_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb4_4Enterprise_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{7, 3}
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetConfigMongos() *config.MongosConfigSet4_4Enterprise {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet4_4Enterprise {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb4_4Enterprise_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 5.0 hosts.
	Config *config.MongodConfigSet5_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0_Mongod) Reset() {
	*x = Mongodb5_0_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_Mongod) ProtoMessage() {}

func (x *Mongodb5_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 0}
}

func (x *Mongodb5_0_Mongod) GetConfig() *config.MongodConfigSet5_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 5.0 hosts.
	Config *config.MongoCfgConfigSet5_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0_MongoCfg) Reset() {
	*x = Mongodb5_0_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb5_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 1}
}

func (x *Mongodb5_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet5_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 5.0 hosts.
	Config *config.MongosConfigSet5_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0_Mongos) Reset() {
	*x = Mongodb5_0_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_Mongos) ProtoMessage() {}

func (x *Mongodb5_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 2}
}

func (x *Mongodb5_0_Mongos) GetConfig() *config.MongosConfigSet5_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet5_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet5_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0_MongoInfra) Reset() {
	*x = Mongodb5_0_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb5_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb5_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{8, 3}
}

func (x *Mongodb5_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet5_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb5_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet5_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb5_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 5.0 hosts.
	Config *config.MongodConfigSet5_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0Enterprise_Mongod) Reset() {
	*x = Mongodb5_0Enterprise_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0Enterprise_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_Mongod) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Mongodb5_0Enterprise_Mongod) GetConfig() *config.MongodConfigSet5_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 5.0 hosts.
	Config *config.MongoCfgConfigSet5_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0Enterprise_MongoCfg) Reset() {
	*x = Mongodb5_0Enterprise_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0Enterprise_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_MongoCfg) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 1}
}

func (x *Mongodb5_0Enterprise_MongoCfg) GetConfig() *config.MongoCfgConfigSet5_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 5.0 hosts.
	Config *config.MongosConfigSet5_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0Enterprise_Mongos) Reset() {
	*x = Mongodb5_0Enterprise_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0Enterprise_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_Mongos) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 2}
}

func (x *Mongodb5_0Enterprise_Mongos) GetConfig() *config.MongosConfigSet5_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb5_0Enterprise_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet5_0Enterprise   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet5_0Enterprise `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb5_0Enterprise_MongoInfra) Reset() {
	*x = Mongodb5_0Enterprise_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb5_0Enterprise_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb5_0Enterprise_MongoInfra) ProtoMessage() {}

func (x *Mongodb5_0Enterprise_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb5_0Enterprise_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb5_0Enterprise_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{9, 3}
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetConfigMongos() *config.MongosConfigSet5_0Enterprise {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet5_0Enterprise {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb5_0Enterprise_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 6.0 hosts.
	Config *config.MongodConfigSet6_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0_Mongod) Reset() {
	*x = Mongodb6_0_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_Mongod) ProtoMessage() {}

func (x *Mongodb6_0_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Mongodb6_0_Mongod) GetConfig() *config.MongodConfigSet6_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 6.0 hosts.
	Config *config.MongoCfgConfigSet6_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0_MongoCfg) Reset() {
	*x = Mongodb6_0_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_MongoCfg) ProtoMessage() {}

func (x *Mongodb6_0_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 1}
}

func (x *Mongodb6_0_MongoCfg) GetConfig() *config.MongoCfgConfigSet6_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 6.0 hosts.
	Config *config.MongosConfigSet6_0 `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0_Mongos) Reset() {
	*x = Mongodb6_0_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_Mongos) ProtoMessage() {}

func (x *Mongodb6_0_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 2}
}

func (x *Mongodb6_0_Mongos) GetConfig() *config.MongosConfigSet6_0 {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet6_0   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet6_0 `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0_MongoInfra) Reset() {
	*x = Mongodb6_0_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0_MongoInfra) ProtoMessage() {}

func (x *Mongodb6_0_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb6_0_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{10, 3}
}

func (x *Mongodb6_0_MongoInfra) GetConfigMongos() *config.MongosConfigSet6_0 {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb6_0_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet6_0 {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb6_0_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod 6.0 hosts.
	Config *config.MongodConfigSet6_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0Enterprise_Mongod) Reset() {
	*x = Mongodb6_0Enterprise_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0Enterprise_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_Mongod) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 0}
}

func (x *Mongodb6_0Enterprise_Mongod) GetConfig() *config.MongodConfigSet6_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg 6.0 hosts.
	Config *config.MongoCfgConfigSet6_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0Enterprise_MongoCfg) Reset() {
	*x = Mongodb6_0Enterprise_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0Enterprise_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_MongoCfg) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 1}
}

func (x *Mongodb6_0Enterprise_MongoCfg) GetConfig() *config.MongoCfgConfigSet6_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos 6.0 hosts.
	Config *config.MongosConfigSet6_0Enterprise `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0Enterprise_Mongos) Reset() {
	*x = Mongodb6_0Enterprise_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0Enterprise_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_Mongos) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 2}
}

func (x *Mongodb6_0Enterprise_Mongos) GetConfig() *config.MongosConfigSet6_0Enterprise {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb6_0Enterprise_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet6_0Enterprise   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet6_0Enterprise `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb6_0Enterprise_MongoInfra) Reset() {
	*x = Mongodb6_0Enterprise_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb6_0Enterprise_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb6_0Enterprise_MongoInfra) ProtoMessage() {}

func (x *Mongodb6_0Enterprise_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb6_0Enterprise_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb6_0Enterprise_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{11, 3}
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetConfigMongos() *config.MongosConfigSet6_0Enterprise {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet6_0Enterprise {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb6_0Enterprise_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_Mongod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongod hosts.
	Config *config.MongodConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongod hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb_Mongod) Reset() {
	*x = Mongodb_Mongod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb_Mongod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_Mongod) ProtoMessage() {}

func (x *Mongodb_Mongod) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_Mongod.ProtoReflect.Descriptor instead.
func (*Mongodb_Mongod) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Mongodb_Mongod) GetConfig() *config.MongodConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb_Mongod) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_Mongod) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_MongoCfg struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongocfg hosts.
	Config *config.MongoCfgConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongocfg hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb_MongoCfg) Reset() {
	*x = Mongodb_MongoCfg{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb_MongoCfg) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_MongoCfg) ProtoMessage() {}

func (x *Mongodb_MongoCfg) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_MongoCfg.ProtoReflect.Descriptor instead.
func (*Mongodb_MongoCfg) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 1}
}

func (x *Mongodb_MongoCfg) GetConfig() *config.MongoCfgConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb_MongoCfg) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_MongoCfg) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_Mongos struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for mongos hosts.
	Config *config.MongosConfigSet `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Resources allocated to mongos hosts.
	Resources *Resources `protobuf:"bytes,2,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,3,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb_Mongos) Reset() {
	*x = Mongodb_Mongos{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb_Mongos) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_Mongos) ProtoMessage() {}

func (x *Mongodb_Mongos) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_Mongos.ProtoReflect.Descriptor instead.
func (*Mongodb_Mongos) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 2}
}

func (x *Mongodb_Mongos) GetConfig() *config.MongosConfigSet {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Mongodb_Mongos) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_Mongos) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Mongodb_MongoInfra struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ConfigMongos   *config.MongosConfigSet   `protobuf:"bytes,1,opt,name=config_mongos,json=configMongos,proto3" json:"config_mongos,omitempty"`
	ConfigMongocfg *config.MongoCfgConfigSet `protobuf:"bytes,2,opt,name=config_mongocfg,json=configMongocfg,proto3" json:"config_mongocfg,omitempty"`
	// Resources allocated to mongoinfra (mongos+mongocfg) hosts.
	Resources *Resources `protobuf:"bytes,3,opt,name=resources,proto3" json:"resources,omitempty"`
	// Disk size autoscaling settings
	DiskSizeAutoscaling *DiskSizeAutoscaling `protobuf:"bytes,4,opt,name=disk_size_autoscaling,json=diskSizeAutoscaling,proto3" json:"disk_size_autoscaling,omitempty"`
}

func (x *Mongodb_MongoInfra) Reset() {
	*x = Mongodb_MongoInfra{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Mongodb_MongoInfra) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mongodb_MongoInfra) ProtoMessage() {}

func (x *Mongodb_MongoInfra) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mongodb_MongoInfra.ProtoReflect.Descriptor instead.
func (*Mongodb_MongoInfra) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{12, 3}
}

func (x *Mongodb_MongoInfra) GetConfigMongos() *config.MongosConfigSet {
	if x != nil {
		return x.ConfigMongos
	}
	return nil
}

func (x *Mongodb_MongoInfra) GetConfigMongocfg() *config.MongoCfgConfigSet {
	if x != nil {
		return x.ConfigMongocfg
	}
	return nil
}

func (x *Mongodb_MongoInfra) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Mongodb_MongoInfra) GetDiskSizeAutoscaling() *DiskSizeAutoscaling {
	if x != nil {
		return x.DiskSizeAutoscaling
	}
	return nil
}

type Host_HostParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Hidden             bool              `protobuf:"varint,1,opt,name=hidden,proto3" json:"hidden,omitempty"`
	SecondaryDelaySecs int64             `protobuf:"varint,2,opt,name=secondary_delay_secs,json=secondaryDelaySecs,proto3" json:"secondary_delay_secs,omitempty"`
	Priority           float64           `protobuf:"fixed64,3,opt,name=priority,proto3" json:"priority,omitempty"`
	Tags               map[string]string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Host_HostParameters) Reset() {
	*x = Host_HostParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Host_HostParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Host_HostParameters) ProtoMessage() {}

func (x *Host_HostParameters) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Host_HostParameters.ProtoReflect.Descriptor instead.
func (*Host_HostParameters) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP(), []int{14, 0}
}

func (x *Host_HostParameters) GetHidden() bool {
	if x != nil {
		return x.Hidden
	}
	return false
}

func (x *Host_HostParameters) GetSecondaryDelaySecs() int64 {
	if x != nil {
		return x.SecondaryDelaySecs
	}
	return 0
}

func (x *Host_HostParameters) GetPriority() float64 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Host_HostParameters) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

var File_yandex_cloud_mdb_mongodb_v1_cluster_proto protoreflect.FileDescriptor

var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc = []byte{
	0x0a, 0x29, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f,
	0x32, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30,
	0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf5, 0x09, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x39, 0x0a,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0a,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x43, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x12,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x5e, 0x0a, 0x11, 0x70,
	0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x6e, 0x6e,
	0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x49, 0x0a, 0x0b, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02,
	0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45,
	0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41,
	0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10,
	0x03, 0x22, 0x79, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x22, 0x56, 0x0a, 0x0a,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6c, 0x69, 0x6e, 0x6b, 0x22, 0xb4, 0x0a, 0x0a, 0x0d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x42, 0x0a, 0x1d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f,
	0x33, 0x5f, 0x36, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33,
	0x5f, 0x36, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x33, 0x5f,
	0x36, 0x12, 0x4b, 0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x30,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x48,
	0x00, 0x52, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x30, 0x12, 0x4b,
	0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x32, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x48, 0x00, 0x52, 0x0b,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x32, 0x12, 0x4b, 0x0a, 0x0b, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x34, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f, 0x34, 0x12, 0x4b, 0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x5f, 0x35, 0x5f, 0x30, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x5f, 0x35, 0x5f, 0x30, 0x12, 0x4b, 0x0a, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x5f, 0x36, 0x5f, 0x30, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x36, 0x5f, 0x30, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x36,
	0x5f, 0x30, 0x12, 0x6c, 0x0a, 0x16, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x34, 0x5f,
	0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x48, 0x00, 0x52, 0x16, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x5f, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x12, 0x6c, 0x0a, 0x16, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x35, 0x5f, 0x30, 0x5f,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x48, 0x00, 0x52, 0x16, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f,
	0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x12, 0x6c,
	0x0a, 0x16, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x48, 0x00, 0x52, 0x16, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x36, 0x5f,
	0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x13,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61,
	0x79, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x12, 0x56, 0x0a, 0x19, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x61,
	0x69, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x44, 0x61, 0x79, 0x73, 0x12, 0x72, 0x0a, 0x17,
	0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73,
	0x12, 0x3b, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x4b, 0x0a,
	0x0e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x52, 0x0d, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x4a, 0x04, 0x08, 0x10, 0x10, 0x13, 0x22, 0xd2, 0x0b, 0x0a, 0x0a,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67,
	0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x33, 0x5f, 0x36, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61,
	0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x84, 0x02, 0x0a,
	0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x33, 0x5f, 0x36, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a,
	0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13,
	0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x1a, 0x88, 0x02, 0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67,
	0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x33, 0x5f, 0x36, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53,
	0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x84,
	0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x33, 0x5f,
	0x36, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf8, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49,
	0x6e, 0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x33, 0x5f, 0x36, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x73, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x33, 0x5f, 0x36, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x22, 0xd2, 0x0b, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x12,
	0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52,
	0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34,
	0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a,
	0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72,
	0x61, 0x1a, 0x84, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x34, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x88, 0x02, 0x0a, 0x08, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x30, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a,
	0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13,
	0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x1a, 0x84, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x65, 0x74, 0x34, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf8, 0x02, 0x0a, 0x0a, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x30, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x30, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0xd2, 0x0b, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x34, 0x5f, 0x32, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67,
	0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x34, 0x5f, 0x32, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x32, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x84, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x88, 0x02,
	0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65,
	0x74, 0x34, 0x5f, 0x32, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x84, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a,
	0xf8, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x12, 0x5b,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52, 0x0c, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43,
	0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x32, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0xd2, 0x0b, 0x0a, 0x0a, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34,
	0x5f, 0x34, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12,
	0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52,
	0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x34, 0x5f, 0x34, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52,
	0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x84, 0x02, 0x0a, 0x06,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x1a, 0x88, 0x02, 0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12,
	0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x84, 0x02,
	0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64,
	0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52,
	0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf8, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34,
	0x5f, 0x34, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x34, 0x5f, 0x34, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22,
	0xc0, 0x0c, 0x0a, 0x15, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x5f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34,
	0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x57, 0x0a, 0x08,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x51, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x34, 0x5f, 0x34, 0x5f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x5d, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x8f, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x93, 0x02, 0x0a, 0x08, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x5b, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34,
	0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a,
	0x8f, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34,
	0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69,
	0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x1a, 0x8e, 0x03, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61,
	0x12, 0x66, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x5f,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x6c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x34, 0x5f, 0x34, 0x5f, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x22, 0xd2, 0x0b, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f,
	0x30, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x35, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12,
	0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e,
	0x66, 0x72, 0x61, 0x1a, 0x84, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x88, 0x02, 0x0a, 0x08, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x35, 0x5f,
	0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x84, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf8, 0x02, 0x0a,
	0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0xc0, 0x0c, 0x0a, 0x15, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x12, 0x51, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x12, 0x57, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x5f,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x51, 0x0a,
	0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x12, 0x5d, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a,
	0x8f, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x35,
	0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69,
	0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x1a, 0x93, 0x02, 0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x5b,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x69, 0x73, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x8f, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x73, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x8e, 0x03, 0x0a, 0x0a, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x12, 0x66, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x74, 0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x12, 0x6c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x35, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x0e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0xd2, 0x0b, 0x0a, 0x0a, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x12, 0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36,
	0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12,
	0x46, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52,
	0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x36, 0x5f, 0x30, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52,
	0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x84, 0x02, 0x0a, 0x06,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30, 0x52, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x1a, 0x88, 0x02, 0x0a, 0x08, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12,
	0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x84, 0x02,
	0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64,
	0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52,
	0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf8, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x12, 0x5b, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36,
	0x5f, 0x30, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x12, 0x61, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d,
	0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x36, 0x5f, 0x30, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22,
	0xc0, 0x0c, 0x0a, 0x15, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x5f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36,
	0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12, 0x57, 0x0a, 0x08,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x51, 0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x36, 0x5f, 0x30, 0x5f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73,
	0x52, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x5d, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x1a, 0x8f, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x93, 0x02, 0x0a, 0x08, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x5b, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30,
	0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a,
	0x8f, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x59, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36,
	0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67,
	0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69,
	0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e,
	0x67, 0x1a, 0x8e, 0x03, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61,
	0x12, 0x66, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30, 0x5f,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x6c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x43, 0x66, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x36, 0x5f, 0x30, 0x5f, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69,
	0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x22, 0xb4, 0x0b, 0x0a, 0x07, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x12, 0x43,
	0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x52, 0x06, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x12, 0x49, 0x0a, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x43, 0x66, 0x67, 0x52, 0x08, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x43,
	0x0a, 0x06, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x52, 0x06, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x73, 0x12, 0x4f, 0x0a, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x66, 0x72,
	0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x4d, 0x6f,
	0x6e, 0x67, 0x6f, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x69,
	0x6e, 0x66, 0x72, 0x61, 0x1a, 0x81, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x12,
	0x4b, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x74, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x85, 0x02, 0x0a, 0x08, 0x4d, 0x6f, 0x6e,
	0x67, 0x6f, 0x43, 0x66, 0x67, 0x12, 0x4d, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f,
	0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e,
	0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65,
	0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73,
	0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x1a, 0x81, 0x02, 0x0a, 0x06, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x64,
	0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x52,
	0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x1a, 0xf2, 0x02, 0x0a, 0x0a, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x12, 0x58, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f,
	0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52,
	0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x73, 0x12, 0x5e, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x6e, 0x67,
	0x6f, 0x43, 0x66, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x65, 0x74, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x6f, 0x6e, 0x67, 0x6f, 0x63, 0x66, 0x67, 0x12, 0x44, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61,
	0x6c, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x22, 0x3a, 0x0a, 0x05, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x64, 0x22, 0xa2, 0x08, 0x0a, 0x04, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62,
	0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x3a, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64,
	0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73,
	0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x40,
	0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x69,
	0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x59, 0x0a, 0x0f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x48,
	0x6f, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0e, 0x68,
	0x6f, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0xff, 0x01,
	0x0a, 0x0e, 0x48, 0x6f, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x06, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x53, 0x65, 0x63, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4e, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x52, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e,
	0x47, 0x4f, 0x53, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x43, 0x46,
	0x47, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x49, 0x4e, 0x46, 0x52,
	0x41, 0x10, 0x04, 0x22, 0x34, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x52,
	0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x45,
	0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x02, 0x22, 0x3f, 0x0a, 0x06, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x45, 0x47, 0x52, 0x41, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x84, 0x02, 0x0a, 0x07, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x52, 0x06, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x22, 0x42, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e, 0x47,
	0x4f, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x53, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x4f, 0x4e, 0x47, 0x4f, 0x43, 0x46, 0x47, 0x10, 0x03, 0x22, 0x31,
	0x0a, 0x06, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x45, 0x41, 0x4c,
	0x54, 0x48, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x41, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x41, 0x44, 0x10,
	0x02, 0x22, 0x78, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x22, 0x63, 0x0a, 0x06, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x65,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x65,
	0x6e, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x71, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x77, 0x65, 0x62, 0x53, 0x71, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x22, 0x4b, 0x0a, 0x1c, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x44,
	0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0xa6, 0x02,
	0x0a, 0x13, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x62, 0x0a, 0x17, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64,
	0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x0d, 0xe8, 0xc7, 0x31, 0x00, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d, 0x31,
	0x30, 0x30, 0x52, 0x15, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x66, 0x0a, 0x19, 0x65, 0x6d, 0x65,
	0x72, 0x67, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0d, 0xe8, 0xc7, 0x31, 0x00, 0xfa,
	0xc7, 0x31, 0x05, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x52, 0x17, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65,
	0x6e, 0x63, 0x79, 0x55, 0x73, 0x61, 0x67, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x6a, 0x0a, 0x1f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x6d, 0x64, 0x62, 0x2e, 0x6d,
	0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x5a, 0x47, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d, 0x64, 0x62, 0x2f,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6f, 0x6e, 0x67, 0x6f,
	0x64, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData = file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc
)

func file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData)
	})
	return file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 63)
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),                      // 0: yandex.cloud.mdb.mongodb.v1.Cluster.Environment
	(Cluster_Health)(0),                           // 1: yandex.cloud.mdb.mongodb.v1.Cluster.Health
	(Cluster_Status)(0),                           // 2: yandex.cloud.mdb.mongodb.v1.Cluster.Status
	(Host_Type)(0),                                // 3: yandex.cloud.mdb.mongodb.v1.Host.Type
	(Host_Role)(0),                                // 4: yandex.cloud.mdb.mongodb.v1.Host.Role
	(Host_Health)(0),                              // 5: yandex.cloud.mdb.mongodb.v1.Host.Health
	(Service_Type)(0),                             // 6: yandex.cloud.mdb.mongodb.v1.Service.Type
	(Service_Health)(0),                           // 7: yandex.cloud.mdb.mongodb.v1.Service.Health
	(*Cluster)(nil),                               // 8: yandex.cloud.mdb.mongodb.v1.Cluster
	(*Monitoring)(nil),                            // 9: yandex.cloud.mdb.mongodb.v1.Monitoring
	(*ClusterConfig)(nil),                         // 10: yandex.cloud.mdb.mongodb.v1.ClusterConfig
	(*Mongodb3_6)(nil),                            // 11: yandex.cloud.mdb.mongodb.v1.Mongodb3_6
	(*Mongodb4_0)(nil),                            // 12: yandex.cloud.mdb.mongodb.v1.Mongodb4_0
	(*Mongodb4_2)(nil),                            // 13: yandex.cloud.mdb.mongodb.v1.Mongodb4_2
	(*Mongodb4_4)(nil),                            // 14: yandex.cloud.mdb.mongodb.v1.Mongodb4_4
	(*Mongodb4_4Enterprise)(nil),                  // 15: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise
	(*Mongodb5_0)(nil),                            // 16: yandex.cloud.mdb.mongodb.v1.Mongodb5_0
	(*Mongodb5_0Enterprise)(nil),                  // 17: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise
	(*Mongodb6_0)(nil),                            // 18: yandex.cloud.mdb.mongodb.v1.Mongodb6_0
	(*Mongodb6_0Enterprise)(nil),                  // 19: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise
	(*Mongodb)(nil),                               // 20: yandex.cloud.mdb.mongodb.v1.Mongodb
	(*Shard)(nil),                                 // 21: yandex.cloud.mdb.mongodb.v1.Shard
	(*Host)(nil),                                  // 22: yandex.cloud.mdb.mongodb.v1.Host
	(*Service)(nil),                               // 23: yandex.cloud.mdb.mongodb.v1.Service
	(*Resources)(nil),                             // 24: yandex.cloud.mdb.mongodb.v1.Resources
	(*Access)(nil),                                // 25: yandex.cloud.mdb.mongodb.v1.Access
	(*PerformanceDiagnosticsConfig)(nil),          // 26: yandex.cloud.mdb.mongodb.v1.PerformanceDiagnosticsConfig
	(*DiskSizeAutoscaling)(nil),                   // 27: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	nil,                                           // 28: yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry
	(*Mongodb3_6_Mongod)(nil),                     // 29: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod
	(*Mongodb3_6_MongoCfg)(nil),                   // 30: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg
	(*Mongodb3_6_Mongos)(nil),                     // 31: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos
	(*Mongodb3_6_MongoInfra)(nil),                 // 32: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra
	(*Mongodb4_0_Mongod)(nil),                     // 33: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod
	(*Mongodb4_0_MongoCfg)(nil),                   // 34: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg
	(*Mongodb4_0_Mongos)(nil),                     // 35: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos
	(*Mongodb4_0_MongoInfra)(nil),                 // 36: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra
	(*Mongodb4_2_Mongod)(nil),                     // 37: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod
	(*Mongodb4_2_MongoCfg)(nil),                   // 38: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg
	(*Mongodb4_2_Mongos)(nil),                     // 39: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos
	(*Mongodb4_2_MongoInfra)(nil),                 // 40: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra
	(*Mongodb4_4_Mongod)(nil),                     // 41: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod
	(*Mongodb4_4_MongoCfg)(nil),                   // 42: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg
	(*Mongodb4_4_Mongos)(nil),                     // 43: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos
	(*Mongodb4_4_MongoInfra)(nil),                 // 44: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra
	(*Mongodb4_4Enterprise_Mongod)(nil),           // 45: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod
	(*Mongodb4_4Enterprise_MongoCfg)(nil),         // 46: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg
	(*Mongodb4_4Enterprise_Mongos)(nil),           // 47: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos
	(*Mongodb4_4Enterprise_MongoInfra)(nil),       // 48: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra
	(*Mongodb5_0_Mongod)(nil),                     // 49: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod
	(*Mongodb5_0_MongoCfg)(nil),                   // 50: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg
	(*Mongodb5_0_Mongos)(nil),                     // 51: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos
	(*Mongodb5_0_MongoInfra)(nil),                 // 52: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra
	(*Mongodb5_0Enterprise_Mongod)(nil),           // 53: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod
	(*Mongodb5_0Enterprise_MongoCfg)(nil),         // 54: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg
	(*Mongodb5_0Enterprise_Mongos)(nil),           // 55: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos
	(*Mongodb5_0Enterprise_MongoInfra)(nil),       // 56: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra
	(*Mongodb6_0_Mongod)(nil),                     // 57: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod
	(*Mongodb6_0_MongoCfg)(nil),                   // 58: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg
	(*Mongodb6_0_Mongos)(nil),                     // 59: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos
	(*Mongodb6_0_MongoInfra)(nil),                 // 60: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra
	(*Mongodb6_0Enterprise_Mongod)(nil),           // 61: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod
	(*Mongodb6_0Enterprise_MongoCfg)(nil),         // 62: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg
	(*Mongodb6_0Enterprise_Mongos)(nil),           // 63: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos
	(*Mongodb6_0Enterprise_MongoInfra)(nil),       // 64: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra
	(*Mongodb_Mongod)(nil),                        // 65: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod
	(*Mongodb_MongoCfg)(nil),                      // 66: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg
	(*Mongodb_Mongos)(nil),                        // 67: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos
	(*Mongodb_MongoInfra)(nil),                    // 68: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra
	(*Host_HostParameters)(nil),                   // 69: yandex.cloud.mdb.mongodb.v1.Host.HostParameters
	nil,                                           // 70: yandex.cloud.mdb.mongodb.v1.Host.HostParameters.TagsEntry
	(*timestamppb.Timestamp)(nil),                 // 71: google.protobuf.Timestamp
	(*MaintenanceWindow)(nil),                     // 72: yandex.cloud.mdb.mongodb.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),                  // 73: yandex.cloud.mdb.mongodb.v1.MaintenanceOperation
	(*timeofday.TimeOfDay)(nil),                   // 74: google.type.TimeOfDay
	(*wrapperspb.Int64Value)(nil),                 // 75: google.protobuf.Int64Value
	(*config.MongodConfigSet3_6)(nil),             // 76: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6
	(*config.MongoCfgConfigSet3_6)(nil),           // 77: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	(*config.MongosConfigSet3_6)(nil),             // 78: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	(*config.MongodConfigSet4_0)(nil),             // 79: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0
	(*config.MongoCfgConfigSet4_0)(nil),           // 80: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	(*config.MongosConfigSet4_0)(nil),             // 81: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	(*config.MongodConfigSet4_2)(nil),             // 82: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2
	(*config.MongoCfgConfigSet4_2)(nil),           // 83: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	(*config.MongosConfigSet4_2)(nil),             // 84: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	(*config.MongodConfigSet4_4)(nil),             // 85: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4
	(*config.MongoCfgConfigSet4_4)(nil),           // 86: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	(*config.MongosConfigSet4_4)(nil),             // 87: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	(*config.MongodConfigSet4_4Enterprise)(nil),   // 88: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4_enterprise
	(*config.MongoCfgConfigSet4_4Enterprise)(nil), // 89: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterprise
	(*config.MongosConfigSet4_4Enterprise)(nil),   // 90: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterprise
	(*config.MongodConfigSet5_0)(nil),             // 91: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0
	(*config.MongoCfgConfigSet5_0)(nil),           // 92: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0
	(*config.MongosConfigSet5_0)(nil),             // 93: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0
	(*config.MongodConfigSet5_0Enterprise)(nil),   // 94: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0_enterprise
	(*config.MongoCfgConfigSet5_0Enterprise)(nil), // 95: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterprise
	(*config.MongosConfigSet5_0Enterprise)(nil),   // 96: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterprise
	(*config.MongodConfigSet6_0)(nil),             // 97: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0
	(*config.MongoCfgConfigSet6_0)(nil),           // 98: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0
	(*config.MongosConfigSet6_0)(nil),             // 99: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0
	(*config.MongodConfigSet6_0Enterprise)(nil),   // 100: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0_enterprise
	(*config.MongoCfgConfigSet6_0Enterprise)(nil), // 101: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterprise
	(*config.MongosConfigSet6_0Enterprise)(nil),   // 102: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterprise
	(*config.MongodConfigSet)(nil),                // 103: yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet
	(*config.MongoCfgConfigSet)(nil),              // 104: yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet
	(*config.MongosConfigSet)(nil),                // 105: yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet
}
var file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs = []int32{
	71,  // 0: yandex.cloud.mdb.mongodb.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	28,  // 1: yandex.cloud.mdb.mongodb.v1.Cluster.labels:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.LabelsEntry
	0,   // 2: yandex.cloud.mdb.mongodb.v1.Cluster.environment:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Environment
	9,   // 3: yandex.cloud.mdb.mongodb.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.mongodb.v1.Monitoring
	10,  // 4: yandex.cloud.mdb.mongodb.v1.Cluster.config:type_name -> yandex.cloud.mdb.mongodb.v1.ClusterConfig
	1,   // 5: yandex.cloud.mdb.mongodb.v1.Cluster.health:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Health
	2,   // 6: yandex.cloud.mdb.mongodb.v1.Cluster.status:type_name -> yandex.cloud.mdb.mongodb.v1.Cluster.Status
	72,  // 7: yandex.cloud.mdb.mongodb.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.mongodb.v1.MaintenanceWindow
	73,  // 8: yandex.cloud.mdb.mongodb.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.mongodb.v1.MaintenanceOperation
	11,  // 9: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_3_6:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6
	12,  // 10: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0
	13,  // 11: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_2:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2
	14,  // 12: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_4:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4
	16,  // 13: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_5_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0
	18,  // 14: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_6_0:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0
	15,  // 15: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_4_4_enterprise:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise
	17,  // 16: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_5_0_enterprise:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise
	19,  // 17: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_6_0_enterprise:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise
	74,  // 18: yandex.cloud.mdb.mongodb.v1.ClusterConfig.backup_window_start:type_name -> google.type.TimeOfDay
	75,  // 19: yandex.cloud.mdb.mongodb.v1.ClusterConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	26,  // 20: yandex.cloud.mdb.mongodb.v1.ClusterConfig.performance_diagnostics:type_name -> yandex.cloud.mdb.mongodb.v1.PerformanceDiagnosticsConfig
	25,  // 21: yandex.cloud.mdb.mongodb.v1.ClusterConfig.access:type_name -> yandex.cloud.mdb.mongodb.v1.Access
	20,  // 22: yandex.cloud.mdb.mongodb.v1.ClusterConfig.mongodb_config:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb
	29,  // 23: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod
	30,  // 24: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg
	31,  // 25: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos
	32,  // 26: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra
	33,  // 27: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod
	34,  // 28: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg
	35,  // 29: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos
	36,  // 30: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra
	37,  // 31: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod
	38,  // 32: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg
	39,  // 33: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos
	40,  // 34: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra
	41,  // 35: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod
	42,  // 36: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg
	43,  // 37: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos
	44,  // 38: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra
	45,  // 39: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod
	46,  // 40: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg
	47,  // 41: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos
	48,  // 42: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra
	49,  // 43: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod
	50,  // 44: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg
	51,  // 45: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos
	52,  // 46: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra
	53,  // 47: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod
	54,  // 48: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg
	55,  // 49: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos
	56,  // 50: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra
	57,  // 51: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod
	58,  // 52: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg
	59,  // 53: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos
	60,  // 54: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra
	61,  // 55: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod
	62,  // 56: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg
	63,  // 57: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos
	64,  // 58: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra
	65,  // 59: yandex.cloud.mdb.mongodb.v1.Mongodb.mongod:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod
	66,  // 60: yandex.cloud.mdb.mongodb.v1.Mongodb.mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg
	67,  // 61: yandex.cloud.mdb.mongodb.v1.Mongodb.mongos:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos
	68,  // 62: yandex.cloud.mdb.mongodb.v1.Mongodb.mongoinfra:type_name -> yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra
	24,  // 63: yandex.cloud.mdb.mongodb.v1.Host.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	4,   // 64: yandex.cloud.mdb.mongodb.v1.Host.role:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Role
	5,   // 65: yandex.cloud.mdb.mongodb.v1.Host.health:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Health
	23,  // 66: yandex.cloud.mdb.mongodb.v1.Host.services:type_name -> yandex.cloud.mdb.mongodb.v1.Service
	3,   // 67: yandex.cloud.mdb.mongodb.v1.Host.type:type_name -> yandex.cloud.mdb.mongodb.v1.Host.Type
	69,  // 68: yandex.cloud.mdb.mongodb.v1.Host.host_parameters:type_name -> yandex.cloud.mdb.mongodb.v1.Host.HostParameters
	6,   // 69: yandex.cloud.mdb.mongodb.v1.Service.type:type_name -> yandex.cloud.mdb.mongodb.v1.Service.Type
	7,   // 70: yandex.cloud.mdb.mongodb.v1.Service.health:type_name -> yandex.cloud.mdb.mongodb.v1.Service.Health
	75,  // 71: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling.planned_usage_threshold:type_name -> google.protobuf.Int64Value
	75,  // 72: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling.emergency_usage_threshold:type_name -> google.protobuf.Int64Value
	75,  // 73: yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling.disk_size_limit:type_name -> google.protobuf.Int64Value
	76,  // 74: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet3_6
	24,  // 75: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 76: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	77,  // 77: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	24,  // 78: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 79: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	78,  // 80: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	24,  // 81: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 82: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	78,  // 83: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet3_6
	77,  // 84: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet3_6
	24,  // 85: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 86: yandex.cloud.mdb.mongodb.v1.Mongodb3_6.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	79,  // 87: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_0
	24,  // 88: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 89: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	80,  // 90: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	24,  // 91: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 92: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	81,  // 93: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	24,  // 94: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 95: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	81,  // 96: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_0
	80,  // 97: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_0
	24,  // 98: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 99: yandex.cloud.mdb.mongodb.v1.Mongodb4_0.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	82,  // 100: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_2
	24,  // 101: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 102: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	83,  // 103: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	24,  // 104: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 105: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	84,  // 106: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	24,  // 107: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 108: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	84,  // 109: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_2
	83,  // 110: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_2
	24,  // 111: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 112: yandex.cloud.mdb.mongodb.v1.Mongodb4_2.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	85,  // 113: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4
	24,  // 114: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 115: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	86,  // 116: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	24,  // 117: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 118: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	87,  // 119: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	24,  // 120: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 121: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	87,  // 122: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4
	86,  // 123: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4
	24,  // 124: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 125: yandex.cloud.mdb.mongodb.v1.Mongodb4_4.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	88,  // 126: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet4_4_enterprise
	24,  // 127: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 128: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	89,  // 129: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterprise
	24,  // 130: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 131: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	90,  // 132: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterprise
	24,  // 133: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 134: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	90,  // 135: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet4_4_enterprise
	89,  // 136: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet4_4_enterprise
	24,  // 137: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 138: yandex.cloud.mdb.mongodb.v1.Mongodb4_4_enterprise.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	91,  // 139: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0
	24,  // 140: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 141: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	92,  // 142: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0
	24,  // 143: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 144: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	93,  // 145: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0
	24,  // 146: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 147: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	93,  // 148: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0
	92,  // 149: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0
	24,  // 150: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 151: yandex.cloud.mdb.mongodb.v1.Mongodb5_0.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	94,  // 152: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet5_0_enterprise
	24,  // 153: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 154: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	95,  // 155: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterprise
	24,  // 156: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 157: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	96,  // 158: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterprise
	24,  // 159: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 160: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	96,  // 161: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet5_0_enterprise
	95,  // 162: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet5_0_enterprise
	24,  // 163: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 164: yandex.cloud.mdb.mongodb.v1.Mongodb5_0_enterprise.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	97,  // 165: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0
	24,  // 166: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 167: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	98,  // 168: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0
	24,  // 169: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 170: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	99,  // 171: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0
	24,  // 172: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 173: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	99,  // 174: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0
	98,  // 175: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0
	24,  // 176: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 177: yandex.cloud.mdb.mongodb.v1.Mongodb6_0.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	100, // 178: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet6_0_enterprise
	24,  // 179: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 180: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	101, // 181: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterprise
	24,  // 182: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 183: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	102, // 184: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterprise
	24,  // 185: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 186: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	102, // 187: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet6_0_enterprise
	101, // 188: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet6_0_enterprise
	24,  // 189: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 190: yandex.cloud.mdb.mongodb.v1.Mongodb6_0_enterprise.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	103, // 191: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongodConfigSet
	24,  // 192: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 193: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongod.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	104, // 194: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet
	24,  // 195: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 196: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoCfg.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	105, // 197: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos.config:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet
	24,  // 198: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 199: yandex.cloud.mdb.mongodb.v1.Mongodb.Mongos.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	105, // 200: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.config_mongos:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongosConfigSet
	104, // 201: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.config_mongocfg:type_name -> yandex.cloud.mdb.mongodb.v1.config.MongoCfgConfigSet
	24,  // 202: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.resources:type_name -> yandex.cloud.mdb.mongodb.v1.Resources
	27,  // 203: yandex.cloud.mdb.mongodb.v1.Mongodb.MongoInfra.disk_size_autoscaling:type_name -> yandex.cloud.mdb.mongodb.v1.DiskSizeAutoscaling
	70,  // 204: yandex.cloud.mdb.mongodb.v1.Host.HostParameters.tags:type_name -> yandex.cloud.mdb.mongodb.v1.Host.HostParameters.TagsEntry
	205, // [205:205] is the sub-list for method output_type
	205, // [205:205] is the sub-list for method input_type
	205, // [205:205] is the sub-list for extension type_name
	205, // [205:205] is the sub-list for extension extendee
	0,   // [0:205] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_mongodb_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_mongodb_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_mongodb_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_mongodb_v1_maintenance_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Monitoring); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb3_6); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_0); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_2); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4Enterprise); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0Enterprise); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0Enterprise); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*Shard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*Host); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*Service); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*PerformanceDiagnosticsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*DiskSizeAutoscaling); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb3_6_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb3_6_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb3_6_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb3_6_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_0_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_0_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_0_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_0_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_2_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_2_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[31].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_2_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[32].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_2_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[33].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[34].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[35].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[36].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[37].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4Enterprise_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[38].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4Enterprise_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[39].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4Enterprise_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[40].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb4_4Enterprise_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[41].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[42].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[43].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[44].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[45].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0Enterprise_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[46].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0Enterprise_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[47].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0Enterprise_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[48].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb5_0Enterprise_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[49].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[50].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[51].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[52].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[53].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0Enterprise_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[54].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0Enterprise_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[55].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0Enterprise_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[56].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb6_0Enterprise_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[57].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb_Mongod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[58].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb_MongoCfg); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[59].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb_Mongos); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[60].Exporter = func(v any, i int) any {
			switch v := v.(*Mongodb_MongoInfra); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[61].Exporter = func(v any, i int) any {
			switch v := v.(*Host_HostParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes[2].OneofWrappers = []any{
		(*ClusterConfig_Mongodb_3_6)(nil),
		(*ClusterConfig_Mongodb_4_0)(nil),
		(*ClusterConfig_Mongodb_4_2)(nil),
		(*ClusterConfig_Mongodb_4_4)(nil),
		(*ClusterConfig_Mongodb_5_0)(nil),
		(*ClusterConfig_Mongodb_6_0)(nil),
		(*ClusterConfig_Mongodb_4_4Enterprise)(nil),
		(*ClusterConfig_Mongodb_5_0Enterprise)(nil),
		(*ClusterConfig_Mongodb_6_0Enterprise)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   63,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_mongodb_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_mongodb_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_mongodb_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_rawDesc = nil
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_mongodb_v1_cluster_proto_depIdxs = nil
}
