package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomains invokes the alidns.DescribeDomains API synchronously
func (client *Client) DescribeDomains(request *DescribeDomainsRequest) (response *DescribeDomainsResponse, err error) {
	response = CreateDescribeDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainsWithChan invokes the alidns.DescribeDomains API asynchronously
func (client *Client) DescribeDomainsWithChan(request *DescribeDomainsRequest) (<-chan *DescribeDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainsWithCallback invokes the alidns.DescribeDomains API asynchronously
func (client *Client) DescribeDomainsWithCallback(request *DescribeDomainsRequest, callback func(response *DescribeDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainsRequest is the request struct for api DescribeDomains
type DescribeDomainsRequest struct {
	*requests.RpcRequest
	StartDate       string                `position:"Query" name:"StartDate"`
	PageNumber      requests.Integer      `position:"Query" name:"PageNumber"`
	ResourceGroupId string                `position:"Query" name:"ResourceGroupId"`
	PageSize        requests.Integer      `position:"Query" name:"PageSize"`
	Tag             *[]DescribeDomainsTag `position:"Query" name:"Tag"  type:"Repeated"`
	Lang            string                `position:"Query" name:"Lang"`
	KeyWord         string                `position:"Query" name:"KeyWord"`
	Direction       string                `position:"Query" name:"Direction"`
	Starmark        requests.Boolean      `position:"Query" name:"Starmark"`
	GroupId         string                `position:"Query" name:"GroupId"`
	OrderBy         string                `position:"Query" name:"OrderBy"`
	EndDate         string                `position:"Query" name:"EndDate"`
	UserClientIp    string                `position:"Query" name:"UserClientIp"`
	SearchMode      string                `position:"Query" name:"SearchMode"`
}

// DescribeDomainsTag is a repeated param struct in DescribeDomainsRequest
type DescribeDomainsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDomainsResponse is the response struct for api DescribeDomains
type DescribeDomainsResponse struct {
	*responses.BaseResponse
	TotalCount int64                    `json:"TotalCount" xml:"TotalCount"`
	PageSize   int64                    `json:"PageSize" xml:"PageSize"`
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	PageNumber int64                    `json:"PageNumber" xml:"PageNumber"`
	Domains    DomainsInDescribeDomains `json:"Domains" xml:"Domains"`
}

// CreateDescribeDomainsRequest creates a request to invoke DescribeDomains API
func CreateDescribeDomainsRequest() (request *DescribeDomainsRequest) {
	request = &DescribeDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDomains", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainsResponse creates a response to parse from DescribeDomains response
func CreateDescribeDomainsResponse() (response *DescribeDomainsResponse) {
	response = &DescribeDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
