/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final long serialVersionUID = -6460763940409461664L;
    static final String javaClassPropertyName = "__javaObject__";
    private Map<String, FieldAndMethods> staticFieldAndMethods;

    public NativeJavaClass() {
    }

    public NativeJavaClass(Scriptable scriptable, Class<?> clazz) {
        this(scriptable, clazz, false);
    }

    public NativeJavaClass(Scriptable scriptable, Class<?> clazz, boolean bl) {
        super(scriptable, clazz, null, bl);
    }

    @Override
    protected void initMembers() {
        Class clazz = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(this.parent, clazz, clazz, this.isAdapter);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, clazz, true);
    }

    @Override
    public String getClassName() {
        return "JavaClass";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, true) || javaClassPropertyName.equals(string);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Object object;
        if (string.equals("prototype")) {
            return null;
        }
        if (this.staticFieldAndMethods != null && (object = this.staticFieldAndMethods.get(string)) != null) {
            return object;
        }
        if (this.members.has(string, true)) {
            return this.members.get(this, string, this.javaObject, true);
        }
        object = Context.getContext();
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        WrapFactory wrapFactory = ((Context)object).getWrapFactory();
        if (javaClassPropertyName.equals(string)) {
            return wrapFactory.wrap((Context)object, scriptable2, this.javaObject, ScriptRuntime.ClassClass);
        }
        Class<?> clazz = NativeJavaClass.findNestedClass(this.getClassObject(), string);
        if (clazz != null) {
            Scriptable scriptable3 = wrapFactory.wrapJavaClass((Context)object, scriptable2, clazz);
            scriptable3.setParentScope(this);
            return scriptable3;
        }
        throw this.members.reportMemberNotFound(string);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        this.members.put(this, string, this.javaObject, object, true);
    }

    @Override
    public Object[] getIds() {
        return this.members.getIds(true);
    }

    public Class<?> getClassObject() {
        return (Class)super.unwrap();
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof Scriptable) {
            Class<?> clazz = this.getClassObject();
            Scriptable scriptable3 = (Scriptable)objectArray[0];
            do {
                Object object;
                if (!(scriptable3 instanceof Wrapper) || !clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) continue;
                return scriptable3;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
        }
        return this.construct(context, scriptable, objectArray);
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        String string;
        Class<?> clazz;
        block7: {
            clazz = this.getClassObject();
            int n = clazz.getModifiers();
            if (!Modifier.isInterface(n) && !Modifier.isAbstract(n)) {
                NativeJavaMethod nativeJavaMethod = this.members.ctors;
                int n2 = nativeJavaMethod.findCachedFunction(context, objectArray);
                if (n2 < 0) {
                    String string2 = NativeJavaMethod.scriptSignature(objectArray);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", clazz.getName(), string2);
                }
                return NativeJavaClass.constructSpecific(context, scriptable, objectArray, nativeJavaMethod.methods[n2]);
            }
            if (objectArray.length == 0) {
                throw Context.reportRuntimeError0("msg.adapter.zero.args");
            }
            Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
            string = "";
            try {
                if ("Dalvik".equals(System.getProperty("java.vm.name")) && clazz.isInterface()) {
                    Object object = NativeJavaClass.createInterfaceAdapter(clazz, ScriptableObject.ensureScriptableObject(objectArray[0]));
                    return context.getWrapFactory().wrapAsJavaObject(context, scriptable, object, null);
                }
                Object object = scriptable2.get("JavaAdapter", scriptable2);
                if (object != NOT_FOUND) {
                    Function function = (Function)object;
                    Object[] objectArray2 = new Object[]{this, objectArray[0]};
                    return function.construct(context, scriptable2, objectArray2);
                }
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null) break block7;
                string = string3;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", string, clazz.getName());
    }

    static Scriptable constructSpecific(Context context, Scriptable scriptable, Object[] objectArray, MemberBox memberBox) {
        Object object = NativeJavaClass.constructInternal(objectArray, memberBox);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        return context.getWrapFactory().wrapNewObject(context, scriptable2, object);
    }

    static Object constructInternal(Object[] objectArray, MemberBox memberBox) {
        Class<?>[] classArray = memberBox.argTypes;
        if (memberBox.vararg) {
            Object object;
            Object[] objectArray2 = new Object[classArray.length];
            for (int i = 0; i < classArray.length - 1; ++i) {
                objectArray2[i] = Context.jsToJava(objectArray[i], classArray[i]);
            }
            if (objectArray.length == classArray.length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1] instanceof NativeArray || objectArray[objectArray.length - 1] instanceof NativeJavaArray)) {
                object = Context.jsToJava(objectArray[objectArray.length - 1], classArray[classArray.length - 1]);
            } else {
                Class<?> clazz = classArray[classArray.length - 1].getComponentType();
                object = Array.newInstance(clazz, objectArray.length - classArray.length + 1);
                for (int i = 0; i < Array.getLength(object); ++i) {
                    Object object2 = Context.jsToJava(objectArray[classArray.length - 1 + i], clazz);
                    Array.set(object, i, object2);
                }
            }
            objectArray2[classArray.length - 1] = object;
            objectArray = objectArray2;
        } else {
            Object[] objectArray3 = objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                Object object3 = Context.jsToJava(object, classArray[i]);
                if (object3 == object) continue;
                if (objectArray == objectArray3) {
                    objectArray = (Object[])objectArray3.clone();
                }
                objectArray[i] = object3;
            }
        }
        return memberBox.newInstance(objectArray);
    }

    @Override
    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        if (scriptable instanceof Wrapper && !(scriptable instanceof NativeJavaClass)) {
            Object object = ((Wrapper)((Object)scriptable)).unwrap();
            return this.getClassObject().isInstance(object);
        }
        return false;
    }

    private static Class<?> findNestedClass(Class<?> clazz, String string) {
        String string2 = clazz.getName() + '$' + string;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return Kit.classOrNull(string2);
        }
        return Kit.classOrNull(classLoader, string2);
    }
}

