// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package bedrockruntimeiface provides an interface to enable mocking the Amazon Bedrock Runtime service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package bedrockruntimeiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/bedrockruntime"
)

// BedrockRuntimeAPI provides an interface to enable mocking the
// bedrockruntime.BedrockRuntime service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Bedrock Runtime.
//	func myFunc(svc bedrockruntimeiface.BedrockRuntimeAPI) bool {
//	    // Make svc.ApplyGuardrail request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := bedrockruntime.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockBedrockRuntimeClient struct {
//	    bedrockruntimeiface.BedrockRuntimeAPI
//	}
//	func (m *mockBedrockRuntimeClient) ApplyGuardrail(input *bedrockruntime.ApplyGuardrailInput) (*bedrockruntime.ApplyGuardrailOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockBedrockRuntimeClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type BedrockRuntimeAPI interface {
	ApplyGuardrail(*bedrockruntime.ApplyGuardrailInput) (*bedrockruntime.ApplyGuardrailOutput, error)
	ApplyGuardrailWithContext(aws.Context, *bedrockruntime.ApplyGuardrailInput, ...request.Option) (*bedrockruntime.ApplyGuardrailOutput, error)
	ApplyGuardrailRequest(*bedrockruntime.ApplyGuardrailInput) (*request.Request, *bedrockruntime.ApplyGuardrailOutput)

	Converse(*bedrockruntime.ConverseInput) (*bedrockruntime.ConverseOutput, error)
	ConverseWithContext(aws.Context, *bedrockruntime.ConverseInput, ...request.Option) (*bedrockruntime.ConverseOutput, error)
	ConverseRequest(*bedrockruntime.ConverseInput) (*request.Request, *bedrockruntime.ConverseOutput)

	ConverseStream(*bedrockruntime.ConverseStreamInput) (*bedrockruntime.ConverseStreamOutput, error)
	ConverseStreamWithContext(aws.Context, *bedrockruntime.ConverseStreamInput, ...request.Option) (*bedrockruntime.ConverseStreamOutput, error)
	ConverseStreamRequest(*bedrockruntime.ConverseStreamInput) (*request.Request, *bedrockruntime.ConverseStreamOutput)

	InvokeModel(*bedrockruntime.InvokeModelInput) (*bedrockruntime.InvokeModelOutput, error)
	InvokeModelWithContext(aws.Context, *bedrockruntime.InvokeModelInput, ...request.Option) (*bedrockruntime.InvokeModelOutput, error)
	InvokeModelRequest(*bedrockruntime.InvokeModelInput) (*request.Request, *bedrockruntime.InvokeModelOutput)

	InvokeModelWithResponseStream(*bedrockruntime.InvokeModelWithResponseStreamInput) (*bedrockruntime.InvokeModelWithResponseStreamOutput, error)
	InvokeModelWithResponseStreamWithContext(aws.Context, *bedrockruntime.InvokeModelWithResponseStreamInput, ...request.Option) (*bedrockruntime.InvokeModelWithResponseStreamOutput, error)
	InvokeModelWithResponseStreamRequest(*bedrockruntime.InvokeModelWithResponseStreamInput) (*request.Request, *bedrockruntime.InvokeModelWithResponseStreamOutput)
}

var _ BedrockRuntimeAPI = (*bedrockruntime.BedrockRuntime)(nil)
