// Code generated by protoc-gen-go. DO NOT EDIT.
// source: debug/debug.proto

package debug

import (
	context "context"
	fmt "fmt"
	commands "github.com/arduino/arduino-cli/rpc/commands"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The top-level message sent by the client for the `Debug` method.
// Multiple `DebugReq` messages can be sent but the first message
// must contain a `DebugReq` message to initialize the debug session.
// All subsequent messages must contain bytes to be sent to the debug session
// and must not contain a `DebugReq` message.
type DebugReq struct {
	// Provides information to the debug that specifies which is the target.
	// The first `StreamingOpenReq` message must contain a `DebugReq`
	// message.
	DebugReq *DebugConfigReq `protobuf:"bytes,1,opt,name=debugReq,proto3" json:"debugReq,omitempty"`
	// The data to be sent to the target being monitored.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Set this to true to send and Interrupt signal to the debugger process
	SendInterrupt        bool     `protobuf:"varint,3,opt,name=send_interrupt,json=sendInterrupt,proto3" json:"send_interrupt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugReq) Reset()         { *m = DebugReq{} }
func (m *DebugReq) String() string { return proto.CompactTextString(m) }
func (*DebugReq) ProtoMessage()    {}
func (*DebugReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_5ae24eab94cb53d5, []int{0}
}

func (m *DebugReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebugReq.Unmarshal(m, b)
}
func (m *DebugReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebugReq.Marshal(b, m, deterministic)
}
func (m *DebugReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugReq.Merge(m, src)
}
func (m *DebugReq) XXX_Size() int {
	return xxx_messageInfo_DebugReq.Size(m)
}
func (m *DebugReq) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugReq.DiscardUnknown(m)
}

var xxx_messageInfo_DebugReq proto.InternalMessageInfo

func (m *DebugReq) GetDebugReq() *DebugConfigReq {
	if m != nil {
		return m.DebugReq
	}
	return nil
}

func (m *DebugReq) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *DebugReq) GetSendInterrupt() bool {
	if m != nil {
		return m.SendInterrupt
	}
	return false
}

type DebugConfigReq struct {
	// Arduino Core Service instance from the `Init` response.
	Instance *commands.Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the board in use
	// (e.g., `arduino:samd:mkr1000`). If this is omitted, the FQBN attached to
	// the sketch will be used.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Path to the sketch that is running on the board. The compiled executable
	// is expected to be located under this path.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// Port of the debugger. Set to `none` if the debugger doesn't use a port.
	Port string `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// Which GDB command interpreter to use.
	Interpreter string `protobuf:"bytes,5,opt,name=interpreter,proto3" json:"interpreter,omitempty"`
	// DEPRECATED: use import_dir instead
	ImportFile string `protobuf:"bytes,7,opt,name=import_file,json=importFile,proto3" json:"import_file,omitempty"` // Deprecated: Do not use.
	// Directory containing the compiled executable. If `import_dir` is not
	// specified, the executable is assumed to be in
	// `{sketch_path}/build/{fqbn}/`.
	ImportDir            string   `protobuf:"bytes,8,opt,name=import_dir,json=importDir,proto3" json:"import_dir,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugConfigReq) Reset()         { *m = DebugConfigReq{} }
func (m *DebugConfigReq) String() string { return proto.CompactTextString(m) }
func (*DebugConfigReq) ProtoMessage()    {}
func (*DebugConfigReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_5ae24eab94cb53d5, []int{1}
}

func (m *DebugConfigReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebugConfigReq.Unmarshal(m, b)
}
func (m *DebugConfigReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebugConfigReq.Marshal(b, m, deterministic)
}
func (m *DebugConfigReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugConfigReq.Merge(m, src)
}
func (m *DebugConfigReq) XXX_Size() int {
	return xxx_messageInfo_DebugConfigReq.Size(m)
}
func (m *DebugConfigReq) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugConfigReq.DiscardUnknown(m)
}

var xxx_messageInfo_DebugConfigReq proto.InternalMessageInfo

func (m *DebugConfigReq) GetInstance() *commands.Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *DebugConfigReq) GetFqbn() string {
	if m != nil {
		return m.Fqbn
	}
	return ""
}

func (m *DebugConfigReq) GetSketchPath() string {
	if m != nil {
		return m.SketchPath
	}
	return ""
}

func (m *DebugConfigReq) GetPort() string {
	if m != nil {
		return m.Port
	}
	return ""
}

func (m *DebugConfigReq) GetInterpreter() string {
	if m != nil {
		return m.Interpreter
	}
	return ""
}

// Deprecated: Do not use.
func (m *DebugConfigReq) GetImportFile() string {
	if m != nil {
		return m.ImportFile
	}
	return ""
}

func (m *DebugConfigReq) GetImportDir() string {
	if m != nil {
		return m.ImportDir
	}
	return ""
}

//
type DebugResp struct {
	// Incoming data from the debugger tool.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Incoming error output from the debugger tool.
	Error                string   `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugResp) Reset()         { *m = DebugResp{} }
func (m *DebugResp) String() string { return proto.CompactTextString(m) }
func (*DebugResp) ProtoMessage()    {}
func (*DebugResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_5ae24eab94cb53d5, []int{2}
}

func (m *DebugResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebugResp.Unmarshal(m, b)
}
func (m *DebugResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebugResp.Marshal(b, m, deterministic)
}
func (m *DebugResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugResp.Merge(m, src)
}
func (m *DebugResp) XXX_Size() int {
	return xxx_messageInfo_DebugResp.Size(m)
}
func (m *DebugResp) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugResp.DiscardUnknown(m)
}

var xxx_messageInfo_DebugResp proto.InternalMessageInfo

func (m *DebugResp) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *DebugResp) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func init() {
	proto.RegisterType((*DebugReq)(nil), "cc.arduino.cli.debug.DebugReq")
	proto.RegisterType((*DebugConfigReq)(nil), "cc.arduino.cli.debug.DebugConfigReq")
	proto.RegisterType((*DebugResp)(nil), "cc.arduino.cli.debug.DebugResp")
}

func init() { proto.RegisterFile("debug/debug.proto", fileDescriptor_5ae24eab94cb53d5) }

var fileDescriptor_5ae24eab94cb53d5 = []byte{
	// 375 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x52, 0x51, 0xcb, 0xd3, 0x30,
	0x14, 0x35, 0x9f, 0x9b, 0xb6, 0xb7, 0x3a, 0x30, 0x4c, 0x08, 0x03, 0x5d, 0xad, 0x0a, 0x45, 0xb0,
	0x95, 0x89, 0x8f, 0x82, 0xcc, 0x21, 0xec, 0x45, 0x24, 0x2f, 0x82, 0x2f, 0xa5, 0x4d, 0xb3, 0x35,
	0xd8, 0x25, 0x59, 0x9a, 0xfe, 0x06, 0xff, 0xb5, 0x48, 0xd2, 0x76, 0x4c, 0x91, 0xbd, 0xb4, 0x27,
	0xe7, 0x9e, 0x73, 0x39, 0xb9, 0xb9, 0xf0, 0xa4, 0xe6, 0x55, 0x7f, 0xcc, 0xfd, 0x37, 0xd3, 0x46,
	0x59, 0x85, 0x97, 0x8c, 0x65, 0xa5, 0xa9, 0x7b, 0x21, 0x55, 0xc6, 0x5a, 0x91, 0xf9, 0xda, 0xea,
	0x29, 0x53, 0xa7, 0x53, 0x29, 0xeb, 0x2e, 0x77, 0x40, 0xc9, 0x41, 0x9c, 0xfc, 0x42, 0x10, 0xec,
	0x9c, 0x80, 0xf2, 0x33, 0xfe, 0x04, 0x41, 0x3d, 0x62, 0x82, 0x62, 0x94, 0x46, 0x9b, 0x57, 0xd9,
	0xff, 0x9a, 0x65, 0xde, 0xf1, 0x59, 0xc9, 0x83, 0x70, 0x5a, 0x7a, 0x71, 0x61, 0x0c, 0xb3, 0xba,
	0xb4, 0x25, 0xb9, 0x8b, 0x51, 0xfa, 0x88, 0x7a, 0x8c, 0x5f, 0xc3, 0xa2, 0xe3, 0xb2, 0x2e, 0x84,
	0xb4, 0xdc, 0x98, 0x5e, 0x5b, 0x72, 0x3f, 0x46, 0x69, 0x40, 0x1f, 0x3b, 0x76, 0x3f, 0x91, 0xc9,
	0x6f, 0x04, 0x8b, 0xbf, 0xfb, 0xe2, 0x8f, 0x10, 0x08, 0xd9, 0xd9, 0x52, 0x32, 0x3e, 0xe6, 0x79,
	0xf1, 0x6f, 0x9e, 0xe9, 0x56, 0xd9, 0x7e, 0x14, 0xd2, 0x8b, 0xc5, 0x85, 0x39, 0x9c, 0x2b, 0xe9,
	0xc3, 0x84, 0xd4, 0x63, 0xbc, 0x86, 0xa8, 0xfb, 0xc9, 0x2d, 0x6b, 0x0a, 0x5d, 0xda, 0xc6, 0x27,
	0x09, 0x29, 0x0c, 0xd4, 0xb7, 0xd2, 0x36, 0xce, 0xa4, 0x95, 0xb1, 0x64, 0x36, 0x98, 0x1c, 0xc6,
	0x31, 0x44, 0x3e, 0xbc, 0x36, 0xdc, 0x72, 0x43, 0xe6, 0xbe, 0x74, 0x4d, 0xe1, 0x97, 0x10, 0x89,
	0x93, 0xd3, 0x16, 0x07, 0xd1, 0x72, 0xf2, 0xd0, 0x29, 0xb6, 0x77, 0x04, 0x51, 0x18, 0xe8, 0x2f,
	0xa2, 0xe5, 0xf8, 0x19, 0x8c, 0xa7, 0xa2, 0x16, 0x86, 0x04, 0xbe, 0x4b, 0x38, 0x30, 0x3b, 0x61,
	0x92, 0x0f, 0x10, 0x8e, 0x2f, 0xd1, 0xe9, 0xcb, 0x20, 0xd1, 0xd5, 0x20, 0x97, 0x30, 0xe7, 0xc6,
	0x28, 0x33, 0x5e, 0x68, 0x38, 0x6c, 0xbe, 0xc3, 0xdc, 0xdb, 0xf0, 0xd7, 0x09, 0x3c, 0xbf, 0xf1,
	0x68, 0x94, 0x9f, 0x57, 0xeb, 0x9b, 0xf5, 0x4e, 0x27, 0xf7, 0x52, 0xf4, 0x0e, 0x6d, 0xdf, 0xfc,
	0x48, 0x8f, 0xc2, 0x36, 0x7d, 0xe5, 0x86, 0x9c, 0x8f, 0xfa, 0xe9, 0xff, 0x96, 0xb5, 0x22, 0x37,
	0x9a, 0x0d, 0x9b, 0x57, 0x3d, 0xf0, 0xdb, 0xf4, 0xfe, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb4,
	0xb6, 0x03, 0x86, 0x8f, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DebugClient is the client API for Debug service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DebugClient interface {
	// Start a debug session and communicate with the debugger tool.
	Debug(ctx context.Context, opts ...grpc.CallOption) (Debug_DebugClient, error)
}

type debugClient struct {
	cc grpc.ClientConnInterface
}

func NewDebugClient(cc grpc.ClientConnInterface) DebugClient {
	return &debugClient{cc}
}

func (c *debugClient) Debug(ctx context.Context, opts ...grpc.CallOption) (Debug_DebugClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Debug_serviceDesc.Streams[0], "/cc.arduino.cli.debug.Debug/Debug", opts...)
	if err != nil {
		return nil, err
	}
	x := &debugDebugClient{stream}
	return x, nil
}

type Debug_DebugClient interface {
	Send(*DebugReq) error
	Recv() (*DebugResp, error)
	grpc.ClientStream
}

type debugDebugClient struct {
	grpc.ClientStream
}

func (x *debugDebugClient) Send(m *DebugReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *debugDebugClient) Recv() (*DebugResp, error) {
	m := new(DebugResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DebugServer is the server API for Debug service.
type DebugServer interface {
	// Start a debug session and communicate with the debugger tool.
	Debug(Debug_DebugServer) error
}

// UnimplementedDebugServer can be embedded to have forward compatible implementations.
type UnimplementedDebugServer struct {
}

func (*UnimplementedDebugServer) Debug(srv Debug_DebugServer) error {
	return status.Errorf(codes.Unimplemented, "method Debug not implemented")
}

func RegisterDebugServer(s *grpc.Server, srv DebugServer) {
	s.RegisterService(&_Debug_serviceDesc, srv)
}

func _Debug_Debug_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(DebugServer).Debug(&debugDebugServer{stream})
}

type Debug_DebugServer interface {
	Send(*DebugResp) error
	Recv() (*DebugReq, error)
	grpc.ServerStream
}

type debugDebugServer struct {
	grpc.ServerStream
}

func (x *debugDebugServer) Send(m *DebugResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *debugDebugServer) Recv() (*DebugReq, error) {
	m := new(DebugReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Debug_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.cli.debug.Debug",
	HandlerType: (*DebugServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Debug",
			Handler:       _Debug_Debug_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "debug/debug.proto",
}
