// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/storage/v1/storage_resources.proto

package storage

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A set of properties to return in a response.
type CommonEnums_Projection int32

const (
	// No specified projection.
	CommonEnums_PROJECTION_UNSPECIFIED CommonEnums_Projection = 0
	// Omit `owner`, `acl`, and `defaultObjectAcl` properties.
	CommonEnums_NO_ACL CommonEnums_Projection = 1
	// Include all properties.
	CommonEnums_FULL CommonEnums_Projection = 2
)

// Enum value maps for CommonEnums_Projection.
var (
	CommonEnums_Projection_name = map[int32]string{
		0: "PROJECTION_UNSPECIFIED",
		1: "NO_ACL",
		2: "FULL",
	}
	CommonEnums_Projection_value = map[string]int32{
		"PROJECTION_UNSPECIFIED": 0,
		"NO_ACL":                 1,
		"FULL":                   2,
	}
)

func (x CommonEnums_Projection) Enum() *CommonEnums_Projection {
	p := new(CommonEnums_Projection)
	*p = x
	return p
}

func (x CommonEnums_Projection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommonEnums_Projection) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v1_storage_resources_proto_enumTypes[0].Descriptor()
}

func (CommonEnums_Projection) Type() protoreflect.EnumType {
	return &file_google_storage_v1_storage_resources_proto_enumTypes[0]
}

func (x CommonEnums_Projection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommonEnums_Projection.Descriptor instead.
func (CommonEnums_Projection) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{8, 0}
}

// Predefined or "canned" aliases for sets of specific bucket ACL entries.
type CommonEnums_PredefinedBucketAcl int32

const (
	// No predefined ACL.
	CommonEnums_PREDEFINED_BUCKET_ACL_UNSPECIFIED CommonEnums_PredefinedBucketAcl = 0
	// Project team owners get `OWNER` access, and
	// `allAuthenticatedUsers` get `READER` access.
	CommonEnums_BUCKET_ACL_AUTHENTICATED_READ CommonEnums_PredefinedBucketAcl = 1
	// Project team owners get `OWNER` access.
	CommonEnums_BUCKET_ACL_PRIVATE CommonEnums_PredefinedBucketAcl = 2
	// Project team members get access according to their roles.
	CommonEnums_BUCKET_ACL_PROJECT_PRIVATE CommonEnums_PredefinedBucketAcl = 3
	// Project team owners get `OWNER` access, and
	// `allUsers` get `READER` access.
	CommonEnums_BUCKET_ACL_PUBLIC_READ CommonEnums_PredefinedBucketAcl = 4
	// Project team owners get `OWNER` access, and
	// `allUsers` get `WRITER` access.
	CommonEnums_BUCKET_ACL_PUBLIC_READ_WRITE CommonEnums_PredefinedBucketAcl = 5
)

// Enum value maps for CommonEnums_PredefinedBucketAcl.
var (
	CommonEnums_PredefinedBucketAcl_name = map[int32]string{
		0: "PREDEFINED_BUCKET_ACL_UNSPECIFIED",
		1: "BUCKET_ACL_AUTHENTICATED_READ",
		2: "BUCKET_ACL_PRIVATE",
		3: "BUCKET_ACL_PROJECT_PRIVATE",
		4: "BUCKET_ACL_PUBLIC_READ",
		5: "BUCKET_ACL_PUBLIC_READ_WRITE",
	}
	CommonEnums_PredefinedBucketAcl_value = map[string]int32{
		"PREDEFINED_BUCKET_ACL_UNSPECIFIED": 0,
		"BUCKET_ACL_AUTHENTICATED_READ":     1,
		"BUCKET_ACL_PRIVATE":                2,
		"BUCKET_ACL_PROJECT_PRIVATE":        3,
		"BUCKET_ACL_PUBLIC_READ":            4,
		"BUCKET_ACL_PUBLIC_READ_WRITE":      5,
	}
)

func (x CommonEnums_PredefinedBucketAcl) Enum() *CommonEnums_PredefinedBucketAcl {
	p := new(CommonEnums_PredefinedBucketAcl)
	*p = x
	return p
}

func (x CommonEnums_PredefinedBucketAcl) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommonEnums_PredefinedBucketAcl) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v1_storage_resources_proto_enumTypes[1].Descriptor()
}

func (CommonEnums_PredefinedBucketAcl) Type() protoreflect.EnumType {
	return &file_google_storage_v1_storage_resources_proto_enumTypes[1]
}

func (x CommonEnums_PredefinedBucketAcl) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommonEnums_PredefinedBucketAcl.Descriptor instead.
func (CommonEnums_PredefinedBucketAcl) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{8, 1}
}

// Predefined or "canned" aliases for sets of specific object ACL entries.
type CommonEnums_PredefinedObjectAcl int32

const (
	// No predefined ACL.
	CommonEnums_PREDEFINED_OBJECT_ACL_UNSPECIFIED CommonEnums_PredefinedObjectAcl = 0
	// Object owner gets `OWNER` access, and
	// `allAuthenticatedUsers` get `READER` access.
	CommonEnums_OBJECT_ACL_AUTHENTICATED_READ CommonEnums_PredefinedObjectAcl = 1
	// Object owner gets `OWNER` access, and project team owners get
	// `OWNER` access.
	CommonEnums_OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL CommonEnums_PredefinedObjectAcl = 2
	// Object owner gets `OWNER` access, and project team owners get
	// `READER` access.
	CommonEnums_OBJECT_ACL_BUCKET_OWNER_READ CommonEnums_PredefinedObjectAcl = 3
	// Object owner gets `OWNER` access.
	CommonEnums_OBJECT_ACL_PRIVATE CommonEnums_PredefinedObjectAcl = 4
	// Object owner gets `OWNER` access, and project team members get
	// access according to their roles.
	CommonEnums_OBJECT_ACL_PROJECT_PRIVATE CommonEnums_PredefinedObjectAcl = 5
	// Object owner gets `OWNER` access, and `allUsers`
	// get `READER` access.
	CommonEnums_OBJECT_ACL_PUBLIC_READ CommonEnums_PredefinedObjectAcl = 6
)

// Enum value maps for CommonEnums_PredefinedObjectAcl.
var (
	CommonEnums_PredefinedObjectAcl_name = map[int32]string{
		0: "PREDEFINED_OBJECT_ACL_UNSPECIFIED",
		1: "OBJECT_ACL_AUTHENTICATED_READ",
		2: "OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL",
		3: "OBJECT_ACL_BUCKET_OWNER_READ",
		4: "OBJECT_ACL_PRIVATE",
		5: "OBJECT_ACL_PROJECT_PRIVATE",
		6: "OBJECT_ACL_PUBLIC_READ",
	}
	CommonEnums_PredefinedObjectAcl_value = map[string]int32{
		"PREDEFINED_OBJECT_ACL_UNSPECIFIED":    0,
		"OBJECT_ACL_AUTHENTICATED_READ":        1,
		"OBJECT_ACL_BUCKET_OWNER_FULL_CONTROL": 2,
		"OBJECT_ACL_BUCKET_OWNER_READ":         3,
		"OBJECT_ACL_PRIVATE":                   4,
		"OBJECT_ACL_PROJECT_PRIVATE":           5,
		"OBJECT_ACL_PUBLIC_READ":               6,
	}
)

func (x CommonEnums_PredefinedObjectAcl) Enum() *CommonEnums_PredefinedObjectAcl {
	p := new(CommonEnums_PredefinedObjectAcl)
	*p = x
	return p
}

func (x CommonEnums_PredefinedObjectAcl) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommonEnums_PredefinedObjectAcl) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storage_v1_storage_resources_proto_enumTypes[2].Descriptor()
}

func (CommonEnums_PredefinedObjectAcl) Type() protoreflect.EnumType {
	return &file_google_storage_v1_storage_resources_proto_enumTypes[2]
}

func (x CommonEnums_PredefinedObjectAcl) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommonEnums_PredefinedObjectAcl.Descriptor instead.
func (CommonEnums_PredefinedObjectAcl) EnumDescriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{8, 2}
}

// A bucket.
type Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Access controls on the bucket.
	Acl []*BucketAccessControl `protobuf:"bytes,1,rep,name=acl,proto3" json:"acl,omitempty"`
	// Default access controls to apply to new objects when no ACL is provided.
	DefaultObjectAcl []*ObjectAccessControl `protobuf:"bytes,2,rep,name=default_object_acl,json=defaultObjectAcl,proto3" json:"default_object_acl,omitempty"`
	// The bucket's lifecycle configuration. See
	// [https://developers.google.com/storage/docs/lifecycle]Lifecycle Management]
	// for more information.
	Lifecycle *Bucket_Lifecycle `protobuf:"bytes,3,opt,name=lifecycle,proto3" json:"lifecycle,omitempty"`
	// The creation time of the bucket in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	// Attempting to set this field will result in an error.
	TimeCreated *timestamp.Timestamp `protobuf:"bytes,4,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	// The ID of the bucket. For buckets, the `id` and `name` properties are the
	// same.
	// Attempting to update this field after the bucket is created will result in
	// an error.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket.
	// Attempting to update this field after the bucket is created will result in
	// an error.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The project number of the project the bucket belongs to.
	// Attempting to set this field will result in an error.
	ProjectNumber int64 `protobuf:"varint,7,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The metadata generation of this bucket.
	// Attempting to set this field will result in an error.
	Metageneration int64 `protobuf:"varint,8,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// The bucket's [https://www.w3.org/TR/cors/][Cross-Origin Resource Sharing]
	// (CORS) configuration.
	Cors []*Bucket_Cors `protobuf:"bytes,9,rep,name=cors,proto3" json:"cors,omitempty"`
	// The location of the bucket. Object data for objects in the bucket resides
	// in physical storage within this region.  Defaults to `US`. See the
	// [https://developers.google.com/storage/docs/concepts-techniques#specifyinglocations"][developer's
	// guide] for the authoritative list. Attempting to update this field after
	// the bucket is created will result in an error.
	Location string `protobuf:"bytes,10,opt,name=location,proto3" json:"location,omitempty"`
	// The bucket's default storage class, used whenever no storageClass is
	// specified for a newly-created object. This defines how objects in the
	// bucket are stored and determines the SLA and the cost of storage.
	// If this value is not specified when the bucket is created, it will default
	// to `STANDARD`. For more information, see
	// https://developers.google.com/storage/docs/storage-classes.
	StorageClass string `protobuf:"bytes,11,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// HTTP 1.1 [https://tools.ietf.org/html/rfc7232#section-2.3"]Entity tag]
	// for the bucket.
	// Attempting to set this field will result in an error.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// The modification time of the bucket.
	// Attempting to set this field will result in an error.
	Updated *timestamp.Timestamp `protobuf:"bytes,13,opt,name=updated,proto3" json:"updated,omitempty"`
	// The default value for event-based hold on newly created objects in this
	// bucket.  Event-based hold is a way to retain objects indefinitely until an
	// event occurs, signified by the
	// hold's release. After being released, such objects will be subject to
	// bucket-level retention (if any).  One sample use case of this flag is for
	// banks to hold loan documents for at least 3 years after loan is paid in
	// full. Here, bucket-level retention is 3 years and the event is loan being
	// paid in full. In this example, these objects will be held intact for any
	// number of years until the event has occurred (event-based hold on the
	// object is released) and then 3 more years after that. That means retention
	// duration of the objects begins from the moment event-based hold
	// transitioned from true to false.  Objects under event-based hold cannot be
	// deleted, overwritten or archived until the hold is removed.
	DefaultEventBasedHold bool `protobuf:"varint,14,opt,name=default_event_based_hold,json=defaultEventBasedHold,proto3" json:"default_event_based_hold,omitempty"`
	// User-provided labels, in key/value pairs.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The bucket's website configuration, controlling how the service behaves
	// when accessing bucket contents as a web site. See the
	// [https://cloud.google.com/storage/docs/static-website][Static Website
	// Examples] for more information.
	Website *Bucket_Website `protobuf:"bytes,16,opt,name=website,proto3" json:"website,omitempty"`
	// The bucket's versioning configuration.
	Versioning *Bucket_Versioning `protobuf:"bytes,17,opt,name=versioning,proto3" json:"versioning,omitempty"`
	// The bucket's logging configuration, which defines the destination bucket
	// and optional name prefix for the current bucket's logs.
	Logging *Bucket_Logging `protobuf:"bytes,18,opt,name=logging,proto3" json:"logging,omitempty"`
	// The owner of the bucket. This is always the project team's owner group.
	Owner *Owner `protobuf:"bytes,19,opt,name=owner,proto3" json:"owner,omitempty"`
	// Encryption configuration for a bucket.
	Encryption *Bucket_Encryption `protobuf:"bytes,20,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// The bucket's billing configuration.
	Billing *Bucket_Billing `protobuf:"bytes,21,opt,name=billing,proto3" json:"billing,omitempty"`
	// The bucket's retention policy. The retention policy enforces a minimum
	// retention time for all objects contained in the bucket, based on their
	// creation time. Any attempt to overwrite or delete objects younger than the
	// retention period will result in a PERMISSION_DENIED error.  An unlocked
	// retention policy can be modified or removed from the bucket via a
	// storage.buckets.update operation. A locked retention policy cannot be
	// removed or shortened in duration for the lifetime of the bucket.
	// Attempting to remove or decrease period of a locked retention policy will
	// result in a PERMISSION_DENIED error.
	RetentionPolicy *Bucket_RetentionPolicy `protobuf:"bytes,22,opt,name=retention_policy,json=retentionPolicy,proto3" json:"retention_policy,omitempty"`
	// The location type of the bucket (region, dual-region, multi-region, etc).
	LocationType string `protobuf:"bytes,23,opt,name=location_type,json=locationType,proto3" json:"location_type,omitempty"`
	// The bucket's IAM configuration.
	IamConfiguration *Bucket_IamConfiguration `protobuf:"bytes,24,opt,name=iam_configuration,json=iamConfiguration,proto3" json:"iam_configuration,omitempty"`
	// The zone or zones from which the bucket is intended to use zonal quota.
	// Requests for data from outside the specified affinities are still allowed
	// but won’t be able to use zonal quota. The values are case-insensitive.
	// Attempting to update this field after bucket is created will result in an
	// error.
	ZoneAffinity []string `protobuf:"bytes,25,rep,name=zone_affinity,json=zoneAffinity,proto3" json:"zone_affinity,omitempty"`
}

func (x *Bucket) Reset() {
	*x = Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket) ProtoMessage() {}

func (x *Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket.ProtoReflect.Descriptor instead.
func (*Bucket) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Bucket) GetAcl() []*BucketAccessControl {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Bucket) GetDefaultObjectAcl() []*ObjectAccessControl {
	if x != nil {
		return x.DefaultObjectAcl
	}
	return nil
}

func (x *Bucket) GetLifecycle() *Bucket_Lifecycle {
	if x != nil {
		return x.Lifecycle
	}
	return nil
}

func (x *Bucket) GetTimeCreated() *timestamp.Timestamp {
	if x != nil {
		return x.TimeCreated
	}
	return nil
}

func (x *Bucket) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Bucket) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Bucket) GetProjectNumber() int64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *Bucket) GetMetageneration() int64 {
	if x != nil {
		return x.Metageneration
	}
	return 0
}

func (x *Bucket) GetCors() []*Bucket_Cors {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *Bucket) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Bucket) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *Bucket) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Bucket) GetUpdated() *timestamp.Timestamp {
	if x != nil {
		return x.Updated
	}
	return nil
}

func (x *Bucket) GetDefaultEventBasedHold() bool {
	if x != nil {
		return x.DefaultEventBasedHold
	}
	return false
}

func (x *Bucket) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Bucket) GetWebsite() *Bucket_Website {
	if x != nil {
		return x.Website
	}
	return nil
}

func (x *Bucket) GetVersioning() *Bucket_Versioning {
	if x != nil {
		return x.Versioning
	}
	return nil
}

func (x *Bucket) GetLogging() *Bucket_Logging {
	if x != nil {
		return x.Logging
	}
	return nil
}

func (x *Bucket) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *Bucket) GetEncryption() *Bucket_Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *Bucket) GetBilling() *Bucket_Billing {
	if x != nil {
		return x.Billing
	}
	return nil
}

func (x *Bucket) GetRetentionPolicy() *Bucket_RetentionPolicy {
	if x != nil {
		return x.RetentionPolicy
	}
	return nil
}

func (x *Bucket) GetLocationType() string {
	if x != nil {
		return x.LocationType
	}
	return ""
}

func (x *Bucket) GetIamConfiguration() *Bucket_IamConfiguration {
	if x != nil {
		return x.IamConfiguration
	}
	return nil
}

func (x *Bucket) GetZoneAffinity() []string {
	if x != nil {
		return x.ZoneAffinity
	}
	return nil
}

// An access-control entry.
type BucketAccessControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The access permission for the entity.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// HTTP 1.1 ["https://tools.ietf.org/html/rfc7232#section-2.3][Entity tag]
	// for the access-control entry.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The ID of the access-control entry.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket.
	Bucket string `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The entity holding the permission, in one of the following forms:
	// * `user-{userid}`
	// * `user-{email}`
	// * `group-{groupid}`
	// * `group-{email}`
	// * `domain-{domain}`
	// * `project-{team-projectid}`
	// * `allUsers`
	// * `allAuthenticatedUsers`
	// Examples:
	// * The user `liz@example.com` would be `user-liz@example.com`.
	// * The group `example@googlegroups.com` would be
	// `group-example@googlegroups.com`
	// * All members of the Google Apps for Business domain `example.com` would be
	// `domain-example.com`
	Entity string `protobuf:"bytes,6,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity, if any.
	EntityId string `protobuf:"bytes,7,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The email address associated with the entity, if any.
	Email string `protobuf:"bytes,8,opt,name=email,proto3" json:"email,omitempty"`
	// The domain associated with the entity, if any.
	Domain string `protobuf:"bytes,9,opt,name=domain,proto3" json:"domain,omitempty"`
	// The project team associated with the entity, if any.
	ProjectTeam *ProjectTeam `protobuf:"bytes,10,opt,name=project_team,json=projectTeam,proto3" json:"project_team,omitempty"`
}

func (x *BucketAccessControl) Reset() {
	*x = BucketAccessControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BucketAccessControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketAccessControl) ProtoMessage() {}

func (x *BucketAccessControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketAccessControl.ProtoReflect.Descriptor instead.
func (*BucketAccessControl) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{1}
}

func (x *BucketAccessControl) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *BucketAccessControl) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *BucketAccessControl) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BucketAccessControl) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *BucketAccessControl) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *BucketAccessControl) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *BucketAccessControl) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *BucketAccessControl) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *BucketAccessControl) GetProjectTeam() *ProjectTeam {
	if x != nil {
		return x.ProjectTeam
	}
	return nil
}

// The response to a call to BucketAccessControls.ListBucketAccessControls.
type ListBucketAccessControlsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of items.
	Items []*BucketAccessControl `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListBucketAccessControlsResponse) Reset() {
	*x = ListBucketAccessControlsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBucketAccessControlsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketAccessControlsResponse) ProtoMessage() {}

func (x *ListBucketAccessControlsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketAccessControlsResponse.ProtoReflect.Descriptor instead.
func (*ListBucketAccessControlsResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{2}
}

func (x *ListBucketAccessControlsResponse) GetItems() []*BucketAccessControl {
	if x != nil {
		return x.Items
	}
	return nil
}

// The result of a call to Buckets.ListBuckets
type ListBucketsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of items.
	Items []*Bucket `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBucketsResponse) Reset() {
	*x = ListBucketsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBucketsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketsResponse) ProtoMessage() {}

func (x *ListBucketsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketsResponse.ProtoReflect.Descriptor instead.
func (*ListBucketsResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ListBucketsResponse) GetItems() []*Bucket {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ListBucketsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// An notification channel used to watch for resource changes.
type Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A UUID or similar unique string that identifies this channel.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// An opaque ID that identifies the resource being watched on this channel.
	// Stable across different API versions.
	ResourceId string `protobuf:"bytes,2,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// A version-specific identifier for the watched resource.
	ResourceUri string `protobuf:"bytes,3,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// An arbitrary string delivered to the target address with each notification
	// delivered over this channel. Optional.
	Token string `protobuf:"bytes,4,opt,name=token,proto3" json:"token,omitempty"`
	// Date and time of notification channel expiration. Optional.
	Expiration *timestamp.Timestamp `protobuf:"bytes,5,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// The type of delivery mechanism used for this channel.
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// The address where notifications are delivered for this channel.
	Address string `protobuf:"bytes,7,opt,name=address,proto3" json:"address,omitempty"`
	// Additional parameters controlling delivery channel behavior. Optional.
	Params map[string]string `protobuf:"bytes,8,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A Boolean value to indicate whether payload is wanted. Optional.
	Payload bool `protobuf:"varint,9,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *Channel) Reset() {
	*x = Channel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel) ProtoMessage() {}

func (x *Channel) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel.ProtoReflect.Descriptor instead.
func (*Channel) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Channel) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Channel) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *Channel) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *Channel) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *Channel) GetExpiration() *timestamp.Timestamp {
	if x != nil {
		return x.Expiration
	}
	return nil
}

func (x *Channel) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Channel) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Channel) GetParams() map[string]string {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *Channel) GetPayload() bool {
	if x != nil {
		return x.Payload
	}
	return false
}

// The result of a call to Channels.ListChannels
type ListChannelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of notification channels for a bucket.
	Items []*ListChannelsResponse_Items `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListChannelsResponse) Reset() {
	*x = ListChannelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelsResponse) ProtoMessage() {}

func (x *ListChannelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelsResponse.ProtoReflect.Descriptor instead.
func (*ListChannelsResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{5}
}

func (x *ListChannelsResponse) GetItems() []*ListChannelsResponse_Items {
	if x != nil {
		return x.Items
	}
	return nil
}

// Message used to convey content being read or written, along with its
// checksum.
type ChecksummedData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// CRC32C digest of the contents.
	Crc32C *wrappers.UInt32Value `protobuf:"bytes,2,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
}

func (x *ChecksummedData) Reset() {
	*x = ChecksummedData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChecksummedData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChecksummedData) ProtoMessage() {}

func (x *ChecksummedData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChecksummedData.ProtoReflect.Descriptor instead.
func (*ChecksummedData) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ChecksummedData) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *ChecksummedData) GetCrc32C() *wrappers.UInt32Value {
	if x != nil {
		return x.Crc32C
	}
	return nil
}

// Message used for storing full (not subrange) object checksums.
type ObjectChecksums struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CRC32C digest of the object data. Computed by the GCS service for
	// all written objects, and validated by the GCS service against
	// client-supplied values if present in an InsertObjectRequest.
	Crc32C *wrappers.UInt32Value `protobuf:"bytes,1,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Hex-encoded MD5 hash of the object data (hexdigest). Whether/how this
	// checksum is provided and validated is service-dependent.
	Md5Hash string `protobuf:"bytes,2,opt,name=md5_hash,json=md5Hash,proto3" json:"md5_hash,omitempty"`
}

func (x *ObjectChecksums) Reset() {
	*x = ObjectChecksums{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectChecksums) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectChecksums) ProtoMessage() {}

func (x *ObjectChecksums) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectChecksums.ProtoReflect.Descriptor instead.
func (*ObjectChecksums) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ObjectChecksums) GetCrc32C() *wrappers.UInt32Value {
	if x != nil {
		return x.Crc32C
	}
	return nil
}

func (x *ObjectChecksums) GetMd5Hash() string {
	if x != nil {
		return x.Md5Hash
	}
	return ""
}

// A collection of enums used in multiple places throughout the API.
type CommonEnums struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommonEnums) Reset() {
	*x = CommonEnums{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommonEnums) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommonEnums) ProtoMessage() {}

func (x *CommonEnums) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommonEnums.ProtoReflect.Descriptor instead.
func (*CommonEnums) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{8}
}

// Specifies a requested range of bytes to download.
type ContentRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The starting offset of the object data.
	Start int64 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// The ending offset of the object data.
	End int64 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	// The complete length of the object data.
	CompleteLength int64 `protobuf:"varint,3,opt,name=complete_length,json=completeLength,proto3" json:"complete_length,omitempty"`
}

func (x *ContentRange) Reset() {
	*x = ContentRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContentRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContentRange) ProtoMessage() {}

func (x *ContentRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContentRange.ProtoReflect.Descriptor instead.
func (*ContentRange) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{9}
}

func (x *ContentRange) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *ContentRange) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *ContentRange) GetCompleteLength() int64 {
	if x != nil {
		return x.CompleteLength
	}
	return 0
}

// Hmac Key Metadata, which includes all information other than the secret.
type HmacKeyMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name ID of the key in the format <projectId>/<accessId>.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Globally unique id for keys.
	AccessId string `protobuf:"bytes,2,opt,name=access_id,json=accessId,proto3" json:"access_id,omitempty"`
	// The project ID that the hmac key is contained in.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Email of the service account the key authenticates as.
	ServiceAccountEmail string `protobuf:"bytes,4,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// State of the key. One of ACTIVE, INACTIVE, or DELETED.
	State string `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	// The creation time of the HMAC key in RFC 3339 format.
	TimeCreated *timestamp.Timestamp `protobuf:"bytes,6,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	// The last modification time of the HMAC key metadata in RFC 3339 format.
	Updated *timestamp.Timestamp `protobuf:"bytes,7,opt,name=updated,proto3" json:"updated,omitempty"`
	// Tag updated with each key update.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *HmacKeyMetadata) Reset() {
	*x = HmacKeyMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HmacKeyMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HmacKeyMetadata) ProtoMessage() {}

func (x *HmacKeyMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HmacKeyMetadata.ProtoReflect.Descriptor instead.
func (*HmacKeyMetadata) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{10}
}

func (x *HmacKeyMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *HmacKeyMetadata) GetAccessId() string {
	if x != nil {
		return x.AccessId
	}
	return ""
}

func (x *HmacKeyMetadata) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *HmacKeyMetadata) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *HmacKeyMetadata) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *HmacKeyMetadata) GetTimeCreated() *timestamp.Timestamp {
	if x != nil {
		return x.TimeCreated
	}
	return nil
}

func (x *HmacKeyMetadata) GetUpdated() *timestamp.Timestamp {
	if x != nil {
		return x.Updated
	}
	return nil
}

func (x *HmacKeyMetadata) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A subscription to receive Google PubSub notifications.
type Notification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud PubSub topic to which this subscription publishes. Formatted as:
	// '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// If present, only send notifications about listed event types. If empty,
	// sent notifications for all event types.
	EventTypes []string `protobuf:"bytes,2,rep,name=event_types,json=eventTypes,proto3" json:"event_types,omitempty"`
	// An optional list of additional attributes to attach to each Cloud PubSub
	// message published for this notification subscription.
	CustomAttributes map[string]string `protobuf:"bytes,3,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP 1.1 [https://tools.ietf.org/html/rfc7232#section-2.3][Entity tag]
	// for this subscription notification.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// If present, only apply this notification configuration to object names that
	// begin with this prefix.
	ObjectNamePrefix string `protobuf:"bytes,5,opt,name=object_name_prefix,json=objectNamePrefix,proto3" json:"object_name_prefix,omitempty"`
	// The desired content of the Payload.
	PayloadFormat string `protobuf:"bytes,6,opt,name=payload_format,json=payloadFormat,proto3" json:"payload_format,omitempty"`
	// The ID of the notification.
	Id string `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Notification) Reset() {
	*x = Notification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Notification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Notification) ProtoMessage() {}

func (x *Notification) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Notification.ProtoReflect.Descriptor instead.
func (*Notification) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{11}
}

func (x *Notification) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *Notification) GetEventTypes() []string {
	if x != nil {
		return x.EventTypes
	}
	return nil
}

func (x *Notification) GetCustomAttributes() map[string]string {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *Notification) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Notification) GetObjectNamePrefix() string {
	if x != nil {
		return x.ObjectNamePrefix
	}
	return ""
}

func (x *Notification) GetPayloadFormat() string {
	if x != nil {
		return x.PayloadFormat
	}
	return ""
}

func (x *Notification) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// The result of a call to Notifications.ListNotifications
type ListNotificationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of items.
	Items []*Notification `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListNotificationsResponse) Reset() {
	*x = ListNotificationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNotificationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNotificationsResponse) ProtoMessage() {}

func (x *ListNotificationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNotificationsResponse.ProtoReflect.Descriptor instead.
func (*ListNotificationsResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{12}
}

func (x *ListNotificationsResponse) GetItems() []*Notification {
	if x != nil {
		return x.Items
	}
	return nil
}

// An object.
type Object struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content-Encoding of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
	ContentEncoding string `protobuf:"bytes,1,opt,name=content_encoding,json=contentEncoding,proto3" json:"content_encoding,omitempty"`
	// Content-Disposition of the object data, matching
	// [https://tools.ietf.org/html/rfc6266][RFC 6266].
	ContentDisposition string `protobuf:"bytes,2,opt,name=content_disposition,json=contentDisposition,proto3" json:"content_disposition,omitempty"`
	// Cache-Control directive for the object data, matching
	// [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
	// If omitted, and the object is accessible to all anonymous users, the
	// default will be `public, max-age=3600`.
	CacheControl string `protobuf:"bytes,3,opt,name=cache_control,json=cacheControl,proto3" json:"cache_control,omitempty"`
	// Access controls on the object.
	Acl []*ObjectAccessControl `protobuf:"bytes,4,rep,name=acl,proto3" json:"acl,omitempty"`
	// Content-Language of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
	ContentLanguage string `protobuf:"bytes,5,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
	// The version of the metadata for this object at this generation. Used for
	// preconditions and for detecting changes in metadata. A metageneration
	// number is only meaningful in the context of a particular generation of a
	// particular object.
	// Attempting to set this field will result in an error.
	Metageneration int64 `protobuf:"varint,6,opt,name=metageneration,proto3" json:"metageneration,omitempty"`
	// The deletion time of the object. Will be returned if and only if this
	// version of the object has been deleted.
	// Attempting to set this field will result in an error.
	TimeDeleted *timestamp.Timestamp `protobuf:"bytes,7,opt,name=time_deleted,json=timeDeleted,proto3" json:"time_deleted,omitempty"`
	// Content-Type of the object data, matching
	// [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
	// If an object is stored without a Content-Type, it is served as
	// `application/octet-stream`.
	ContentType string `protobuf:"bytes,8,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Content-Length of the object data in bytes, matching
	// [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
	// Attempting to set this field will result in an error.
	Size int64 `protobuf:"varint,9,opt,name=size,proto3" json:"size,omitempty"`
	// The creation time of the object.
	// Attempting to set this field will result in an error.
	TimeCreated *timestamp.Timestamp `protobuf:"bytes,10,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	// CRC32c checksum. For more information about using the CRC32c
	// checksum, see
	// [https://cloud.google.com/storage/docs/hashes-etags#_JSONAPI][Hashes and
	// ETags: Best Practices]. This is a server determined value and should not be
	// supplied by the user when sending an Object. The server will ignore any
	// value provided. Users should instead use the object_checksums field on the
	// InsertObjectRequest when uploading an object.
	Crc32C *wrappers.UInt32Value `protobuf:"bytes,11,opt,name=crc32c,proto3" json:"crc32c,omitempty"`
	// Number of underlying components that make up this object. Components are
	// accumulated by compose operations.
	// Attempting to set this field will result in an error.
	ComponentCount int32 `protobuf:"varint,12,opt,name=component_count,json=componentCount,proto3" json:"component_count,omitempty"`
	// MD5 hash of the data; encoded using base64 as per
	// [https://tools.ietf.org/html/rfc4648#section-4][RFC 4648 §4]. For more
	// information about using the MD5 hash, see
	// [https://cloud.google.com/storage/docs/hashes-etags#_JSONAPI][Hashes and
	// ETags: Best Practices]. This is a server determined value and should not be
	// supplied by the user when sending an Object. The server will ignore any
	// value provided. Users should instead use the object_checksums field on the
	// InsertObjectRequest when uploading an object.
	Md5Hash string `protobuf:"bytes,13,opt,name=md5_hash,json=md5Hash,proto3" json:"md5_hash,omitempty"`
	// HTTP 1.1 Entity tag for the object. See
	// [https://tools.ietf.org/html/rfc7232#section-2.3][RFC 7232 §2.3].
	// Attempting to set this field will result in an error.
	Etag string `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
	// The modification time of the object metadata.
	// Attempting to set this field will result in an error.
	Updated *timestamp.Timestamp `protobuf:"bytes,15,opt,name=updated,proto3" json:"updated,omitempty"`
	// Storage class of the object.
	StorageClass string `protobuf:"bytes,16,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Cloud KMS Key used to encrypt this object, if the object is encrypted by
	// such a key.
	KmsKeyName string `protobuf:"bytes,17,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// The time at which the object's storage class was last changed. When the
	// object is initially created, it will be set to time_created.
	// Attempting to set this field will result in an error.
	TimeStorageClassUpdated *timestamp.Timestamp `protobuf:"bytes,18,opt,name=time_storage_class_updated,json=timeStorageClassUpdated,proto3" json:"time_storage_class_updated,omitempty"`
	// Whether an object is under temporary hold. While this flag is set to true,
	// the object is protected against deletion and overwrites.  A common use case
	// of this flag is regulatory investigations where objects need to be retained
	// while the investigation is ongoing. Note that unlike event-based hold,
	// temporary hold does not impact retention expiration time of an object.
	TemporaryHold bool `protobuf:"varint,19,opt,name=temporary_hold,json=temporaryHold,proto3" json:"temporary_hold,omitempty"`
	// A server-determined value that specifies the earliest time that the
	// object's retention period expires. This value is in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	// Note 1: This field is not provided for objects with an active event-based
	// hold, since retention expiration is unknown until the hold is removed.
	// Note 2: This value can be provided even when temporary hold is set (so that
	// the user can reason about policy without having to first unset the
	// temporary hold).
	RetentionExpirationTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=retention_expiration_time,json=retentionExpirationTime,proto3" json:"retention_expiration_time,omitempty"`
	// User-provided metadata, in key/value pairs.
	Metadata map[string]string `protobuf:"bytes,21,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether an object is under event-based hold. Event-based hold is a way to
	// retain objects until an event occurs, which is signified by the
	// hold's release (i.e. this value is set to false). After being released (set
	// to false), such objects will be subject to bucket-level retention (if any).
	// One sample use case of this flag is for banks to hold loan documents for at
	// least 3 years after loan is paid in full. Here, bucket-level retention is 3
	// years and the event is the loan being paid in full. In this example, these
	// objects will be held intact for any number of years until the event has
	// occurred (event-based hold on the object is released) and then 3 more years
	// after that. That means retention duration of the objects begins from the
	// moment event-based hold transitioned from true to false.
	EventBasedHold *wrappers.BoolValue `protobuf:"bytes,29,opt,name=event_based_hold,json=eventBasedHold,proto3" json:"event_based_hold,omitempty"`
	// The name of the object.
	// Attempting to update this field after the object is created will result in
	// an error.
	Name string `protobuf:"bytes,23,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the object, including the bucket name, object name, and
	// generation number.
	// Attempting to update this field after the object is created will result in
	// an error.
	Id string `protobuf:"bytes,24,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket containing this object.
	// Attempting to update this field after the object is created will result in
	// an error.
	Bucket string `protobuf:"bytes,25,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The content generation of this object. Used for object versioning.
	// Attempting to set this field will result in an error.
	Generation int64 `protobuf:"varint,26,opt,name=generation,proto3" json:"generation,omitempty"`
	// The owner of the object. This will always be the uploader of the object.
	// Attempting to set this field will result in an error.
	Owner *Owner `protobuf:"bytes,27,opt,name=owner,proto3" json:"owner,omitempty"`
	// Metadata of customer-supplied encryption key, if the object is encrypted by
	// such a key.
	CustomerEncryption *Object_CustomerEncryption `protobuf:"bytes,28,opt,name=customer_encryption,json=customerEncryption,proto3" json:"customer_encryption,omitempty"`
}

func (x *Object) Reset() {
	*x = Object{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Object) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Object) ProtoMessage() {}

func (x *Object) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Object.ProtoReflect.Descriptor instead.
func (*Object) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{13}
}

func (x *Object) GetContentEncoding() string {
	if x != nil {
		return x.ContentEncoding
	}
	return ""
}

func (x *Object) GetContentDisposition() string {
	if x != nil {
		return x.ContentDisposition
	}
	return ""
}

func (x *Object) GetCacheControl() string {
	if x != nil {
		return x.CacheControl
	}
	return ""
}

func (x *Object) GetAcl() []*ObjectAccessControl {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Object) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

func (x *Object) GetMetageneration() int64 {
	if x != nil {
		return x.Metageneration
	}
	return 0
}

func (x *Object) GetTimeDeleted() *timestamp.Timestamp {
	if x != nil {
		return x.TimeDeleted
	}
	return nil
}

func (x *Object) GetContentType() string {
	if x != nil {
		return x.ContentType
	}
	return ""
}

func (x *Object) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Object) GetTimeCreated() *timestamp.Timestamp {
	if x != nil {
		return x.TimeCreated
	}
	return nil
}

func (x *Object) GetCrc32C() *wrappers.UInt32Value {
	if x != nil {
		return x.Crc32C
	}
	return nil
}

func (x *Object) GetComponentCount() int32 {
	if x != nil {
		return x.ComponentCount
	}
	return 0
}

func (x *Object) GetMd5Hash() string {
	if x != nil {
		return x.Md5Hash
	}
	return ""
}

func (x *Object) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Object) GetUpdated() *timestamp.Timestamp {
	if x != nil {
		return x.Updated
	}
	return nil
}

func (x *Object) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *Object) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Object) GetTimeStorageClassUpdated() *timestamp.Timestamp {
	if x != nil {
		return x.TimeStorageClassUpdated
	}
	return nil
}

func (x *Object) GetTemporaryHold() bool {
	if x != nil {
		return x.TemporaryHold
	}
	return false
}

func (x *Object) GetRetentionExpirationTime() *timestamp.Timestamp {
	if x != nil {
		return x.RetentionExpirationTime
	}
	return nil
}

func (x *Object) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Object) GetEventBasedHold() *wrappers.BoolValue {
	if x != nil {
		return x.EventBasedHold
	}
	return nil
}

func (x *Object) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Object) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Object) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *Object) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *Object) GetOwner() *Owner {
	if x != nil {
		return x.Owner
	}
	return nil
}

func (x *Object) GetCustomerEncryption() *Object_CustomerEncryption {
	if x != nil {
		return x.CustomerEncryption
	}
	return nil
}

// An access-control entry.
type ObjectAccessControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The access permission for the entity.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// HTTP 1.1 Entity tag for the access-control entry.
	// See [https://tools.ietf.org/html/rfc7232#section-2.3][RFC 7232 §2.3].
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The ID of the access-control entry.
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the bucket.
	Bucket string `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// The name of the object, if applied to an object.
	Object string `protobuf:"bytes,5,opt,name=object,proto3" json:"object,omitempty"`
	// The content generation of the object, if applied to an object.
	Generation int64 `protobuf:"varint,6,opt,name=generation,proto3" json:"generation,omitempty"`
	// The entity holding the permission, in one of the following forms:
	// * `user-{userid}`
	// * `user-{email}`
	// * `group-{groupid}`
	// * `group-{email}`
	// * `domain-{domain}`
	// * `project-{team-projectid}`
	// * `allUsers`
	// * `allAuthenticatedUsers`
	// Examples:
	// * The user `liz@example.com` would be `user-liz@example.com`.
	// * The group `example@googlegroups.com` would be
	// `group-example@googlegroups.com`.
	// * All members of the Google Apps for Business domain `example.com` would be
	// `domain-example.com`.
	Entity string `protobuf:"bytes,7,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity, if any.
	EntityId string `protobuf:"bytes,8,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// The email address associated with the entity, if any.
	Email string `protobuf:"bytes,9,opt,name=email,proto3" json:"email,omitempty"`
	// The domain associated with the entity, if any.
	Domain string `protobuf:"bytes,10,opt,name=domain,proto3" json:"domain,omitempty"`
	// The project team associated with the entity, if any.
	ProjectTeam *ProjectTeam `protobuf:"bytes,11,opt,name=project_team,json=projectTeam,proto3" json:"project_team,omitempty"`
}

func (x *ObjectAccessControl) Reset() {
	*x = ObjectAccessControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectAccessControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectAccessControl) ProtoMessage() {}

func (x *ObjectAccessControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectAccessControl.ProtoReflect.Descriptor instead.
func (*ObjectAccessControl) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{14}
}

func (x *ObjectAccessControl) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *ObjectAccessControl) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *ObjectAccessControl) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ObjectAccessControl) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *ObjectAccessControl) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *ObjectAccessControl) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

func (x *ObjectAccessControl) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *ObjectAccessControl) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *ObjectAccessControl) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ObjectAccessControl) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *ObjectAccessControl) GetProjectTeam() *ProjectTeam {
	if x != nil {
		return x.ProjectTeam
	}
	return nil
}

// The result of a call to ObjectAccessControls.ListObjectAccessControls.
type ListObjectAccessControlsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of items.
	Items []*ObjectAccessControl `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ListObjectAccessControlsResponse) Reset() {
	*x = ListObjectAccessControlsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListObjectAccessControlsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListObjectAccessControlsResponse) ProtoMessage() {}

func (x *ListObjectAccessControlsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListObjectAccessControlsResponse.ProtoReflect.Descriptor instead.
func (*ListObjectAccessControlsResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{15}
}

func (x *ListObjectAccessControlsResponse) GetItems() []*ObjectAccessControl {
	if x != nil {
		return x.Items
	}
	return nil
}

// The result of a call to Objects.ListObjects
type ListObjectsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of prefixes of objects matching-but-not-listed up to and including
	// the requested delimiter.
	Prefixes []string `protobuf:"bytes,1,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	// The list of items.
	Items []*Object `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListObjectsResponse) Reset() {
	*x = ListObjectsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListObjectsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListObjectsResponse) ProtoMessage() {}

func (x *ListObjectsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListObjectsResponse.ProtoReflect.Descriptor instead.
func (*ListObjectsResponse) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{16}
}

func (x *ListObjectsResponse) GetPrefixes() []string {
	if x != nil {
		return x.Prefixes
	}
	return nil
}

func (x *ListObjectsResponse) GetItems() []*Object {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ListObjectsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents the Viewers, Editors, or Owners of a given project.
type ProjectTeam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project number.
	ProjectNumber string `protobuf:"bytes,1,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The team.
	Team string `protobuf:"bytes,2,opt,name=team,proto3" json:"team,omitempty"`
}

func (x *ProjectTeam) Reset() {
	*x = ProjectTeam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProjectTeam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProjectTeam) ProtoMessage() {}

func (x *ProjectTeam) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProjectTeam.ProtoReflect.Descriptor instead.
func (*ProjectTeam) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{17}
}

func (x *ProjectTeam) GetProjectNumber() string {
	if x != nil {
		return x.ProjectNumber
	}
	return ""
}

func (x *ProjectTeam) GetTeam() string {
	if x != nil {
		return x.Team
	}
	return ""
}

// A subscription to receive Google PubSub notifications.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the notification.
	EmailAddress string `protobuf:"bytes,1,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{18}
}

func (x *ServiceAccount) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

// The owner of a specific resource.
type Owner struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The entity, in the form `user-`*userId*.
	Entity string `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// The ID for the entity.
	EntityId string `protobuf:"bytes,2,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
}

func (x *Owner) Reset() {
	*x = Owner{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Owner) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Owner) ProtoMessage() {}

func (x *Owner) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Owner.ProtoReflect.Descriptor instead.
func (*Owner) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{19}
}

func (x *Owner) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *Owner) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

// Billing properties of a bucket.
type Bucket_Billing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When set to true, Requester Pays is enabled for this bucket.
	RequesterPays bool `protobuf:"varint,1,opt,name=requester_pays,json=requesterPays,proto3" json:"requester_pays,omitempty"`
}

func (x *Bucket_Billing) Reset() {
	*x = Bucket_Billing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Billing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Billing) ProtoMessage() {}

func (x *Bucket_Billing) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Billing.ProtoReflect.Descriptor instead.
func (*Bucket_Billing) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Bucket_Billing) GetRequesterPays() bool {
	if x != nil {
		return x.RequesterPays
	}
	return false
}

// Cross-Origin Response sharing (CORS) properties for a bucket.
// For more on GCS and CORS, see
// https://cloud.google.com/storage/docs/cross-origin.
// For more on CORS in general, see https://tools.ietf.org/html/rfc6454.
type Bucket_Cors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Origins eligible to receive CORS response headers. See
	// [https://tools.ietf.org/html/rfc6454][RFC 6454] for more on origins.
	// Note: "*" is permitted in the list of origins, and means "any Origin".
	Origin []string `protobuf:"bytes,1,rep,name=origin,proto3" json:"origin,omitempty"`
	// The list of HTTP methods on which to include CORS response headers,
	// (`GET`, `OPTIONS`, `POST`, etc) Note: "*" is permitted in the list of
	// methods, and means "any method".
	Method []string `protobuf:"bytes,2,rep,name=method,proto3" json:"method,omitempty"`
	// The list of HTTP headers other than the
	// [https://www.w3.org/TR/cors/#simple-response-header][simple response
	// headers] to give permission for the user-agent to share across domains.
	ResponseHeader []string `protobuf:"bytes,3,rep,name=response_header,json=responseHeader,proto3" json:"response_header,omitempty"`
	// The value, in seconds, to return in the
	// [https://www.w3.org/TR/cors/#access-control-max-age-response-header][Access-Control-Max-Age
	// header] used in preflight responses.
	MaxAgeSeconds int32 `protobuf:"varint,4,opt,name=max_age_seconds,json=maxAgeSeconds,proto3" json:"max_age_seconds,omitempty"`
}

func (x *Bucket_Cors) Reset() {
	*x = Bucket_Cors{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Cors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Cors) ProtoMessage() {}

func (x *Bucket_Cors) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Cors.ProtoReflect.Descriptor instead.
func (*Bucket_Cors) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Bucket_Cors) GetOrigin() []string {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *Bucket_Cors) GetMethod() []string {
	if x != nil {
		return x.Method
	}
	return nil
}

func (x *Bucket_Cors) GetResponseHeader() []string {
	if x != nil {
		return x.ResponseHeader
	}
	return nil
}

func (x *Bucket_Cors) GetMaxAgeSeconds() int32 {
	if x != nil {
		return x.MaxAgeSeconds
	}
	return 0
}

// Encryption properties of a bucket.
type Bucket_Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Cloud KMS key that will be used to encrypt objects inserted into this
	// bucket, if no encryption method is specified.
	DefaultKmsKeyName string `protobuf:"bytes,1,opt,name=default_kms_key_name,json=defaultKmsKeyName,proto3" json:"default_kms_key_name,omitempty"`
}

func (x *Bucket_Encryption) Reset() {
	*x = Bucket_Encryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Encryption) ProtoMessage() {}

func (x *Bucket_Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Encryption.ProtoReflect.Descriptor instead.
func (*Bucket_Encryption) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Bucket_Encryption) GetDefaultKmsKeyName() string {
	if x != nil {
		return x.DefaultKmsKeyName
	}
	return ""
}

// Bucket restriction options currently enforced on the bucket.
type Bucket_IamConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UniformBucketLevelAccess *Bucket_IamConfiguration_UniformBucketLevelAccess `protobuf:"bytes,1,opt,name=uniform_bucket_level_access,json=uniformBucketLevelAccess,proto3" json:"uniform_bucket_level_access,omitempty"`
}

func (x *Bucket_IamConfiguration) Reset() {
	*x = Bucket_IamConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_IamConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_IamConfiguration) ProtoMessage() {}

func (x *Bucket_IamConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_IamConfiguration.ProtoReflect.Descriptor instead.
func (*Bucket_IamConfiguration) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Bucket_IamConfiguration) GetUniformBucketLevelAccess() *Bucket_IamConfiguration_UniformBucketLevelAccess {
	if x != nil {
		return x.UniformBucketLevelAccess
	}
	return nil
}

// Lifecycle properties of a bucket.
// For more information, see https://cloud.google.com/storage/docs/lifecycle.
type Bucket_Lifecycle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A lifecycle management rule, which is made of an action to take and the
	// condition(s) under which the action will be taken.
	Rule []*Bucket_Lifecycle_Rule `protobuf:"bytes,1,rep,name=rule,proto3" json:"rule,omitempty"`
}

func (x *Bucket_Lifecycle) Reset() {
	*x = Bucket_Lifecycle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle) ProtoMessage() {}

func (x *Bucket_Lifecycle) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Bucket_Lifecycle) GetRule() []*Bucket_Lifecycle_Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

// Logging-related properties of a bucket.
type Bucket_Logging struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination bucket where the current bucket's logs should be placed.
	LogBucket string `protobuf:"bytes,1,opt,name=log_bucket,json=logBucket,proto3" json:"log_bucket,omitempty"`
	// A prefix for log object names.
	LogObjectPrefix string `protobuf:"bytes,2,opt,name=log_object_prefix,json=logObjectPrefix,proto3" json:"log_object_prefix,omitempty"`
}

func (x *Bucket_Logging) Reset() {
	*x = Bucket_Logging{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Logging) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Logging) ProtoMessage() {}

func (x *Bucket_Logging) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Logging.ProtoReflect.Descriptor instead.
func (*Bucket_Logging) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Bucket_Logging) GetLogBucket() string {
	if x != nil {
		return x.LogBucket
	}
	return ""
}

func (x *Bucket_Logging) GetLogObjectPrefix() string {
	if x != nil {
		return x.LogObjectPrefix
	}
	return ""
}

// Retention policy properties of a bucket.
type Bucket_RetentionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Server-determined value that indicates the time from which policy was
	// enforced and effective. This value is in
	// [https://tools.ietf.org/html/rfc3339][RFC 3339] format.
	EffectiveTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=effective_time,json=effectiveTime,proto3" json:"effective_time,omitempty"`
	// Once locked, an object retention policy cannot be modified.
	IsLocked bool `protobuf:"varint,2,opt,name=is_locked,json=isLocked,proto3" json:"is_locked,omitempty"`
	// The duration in seconds that objects need to be retained. Retention
	// duration must be greater than zero and less than 100 years. Note that
	// enforcement of retention periods less than a day is not guaranteed. Such
	// periods should only be used for testing purposes.
	RetentionPeriod int64 `protobuf:"varint,3,opt,name=retention_period,json=retentionPeriod,proto3" json:"retention_period,omitempty"`
}

func (x *Bucket_RetentionPolicy) Reset() {
	*x = Bucket_RetentionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_RetentionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_RetentionPolicy) ProtoMessage() {}

func (x *Bucket_RetentionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_RetentionPolicy.ProtoReflect.Descriptor instead.
func (*Bucket_RetentionPolicy) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Bucket_RetentionPolicy) GetEffectiveTime() *timestamp.Timestamp {
	if x != nil {
		return x.EffectiveTime
	}
	return nil
}

func (x *Bucket_RetentionPolicy) GetIsLocked() bool {
	if x != nil {
		return x.IsLocked
	}
	return false
}

func (x *Bucket_RetentionPolicy) GetRetentionPeriod() int64 {
	if x != nil {
		return x.RetentionPeriod
	}
	return 0
}

// Properties of a bucket related to versioning.
// For more on GCS versioning, see
// https://cloud.google.com/storage/docs/object-versioning.
type Bucket_Versioning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// While set to true, versioning is fully enabled for this bucket.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *Bucket_Versioning) Reset() {
	*x = Bucket_Versioning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Versioning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Versioning) ProtoMessage() {}

func (x *Bucket_Versioning) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Versioning.ProtoReflect.Descriptor instead.
func (*Bucket_Versioning) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Bucket_Versioning) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Properties of a bucket related to accessing the contents as a static
// website. For more on hosting a static website via GCS, see
// https://cloud.google.com/storage/docs/hosting-static-website.
type Bucket_Website struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the requested object path is missing, the service will ensure the path
	// has a trailing '/', append this suffix, and attempt to retrieve the
	// resulting object. This allows the creation of `index.html`
	// objects to represent directory pages.
	MainPageSuffix string `protobuf:"bytes,1,opt,name=main_page_suffix,json=mainPageSuffix,proto3" json:"main_page_suffix,omitempty"`
	// If the requested object path is missing, and any
	// `mainPageSuffix` object is missing, if applicable, the service
	// will return the named object from this bucket as the content for a
	// [https://tools.ietf.org/html/rfc7231#section-6.5.4][404 Not Found]
	// result.
	NotFoundPage string `protobuf:"bytes,2,opt,name=not_found_page,json=notFoundPage,proto3" json:"not_found_page,omitempty"`
}

func (x *Bucket_Website) Reset() {
	*x = Bucket_Website{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Website) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Website) ProtoMessage() {}

func (x *Bucket_Website) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Website.ProtoReflect.Descriptor instead.
func (*Bucket_Website) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Bucket_Website) GetMainPageSuffix() string {
	if x != nil {
		return x.MainPageSuffix
	}
	return ""
}

func (x *Bucket_Website) GetNotFoundPage() string {
	if x != nil {
		return x.NotFoundPage
	}
	return ""
}

type Bucket_IamConfiguration_UniformBucketLevelAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, access checks only use bucket-level IAM policies or above.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The deadline time for changing
	// <code>iamConfiguration.uniformBucketLevelAccess.enabled</code> from
	// true to false in [https://tools.ietf.org/html/rfc3339][RFC 3339]. After
	// the deadline is passed the field is immutable.
	LockedTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=locked_time,json=lockedTime,proto3" json:"locked_time,omitempty"`
}

func (x *Bucket_IamConfiguration_UniformBucketLevelAccess) Reset() {
	*x = Bucket_IamConfiguration_UniformBucketLevelAccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_IamConfiguration_UniformBucketLevelAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_IamConfiguration_UniformBucketLevelAccess) ProtoMessage() {}

func (x *Bucket_IamConfiguration_UniformBucketLevelAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_IamConfiguration_UniformBucketLevelAccess.ProtoReflect.Descriptor instead.
func (*Bucket_IamConfiguration_UniformBucketLevelAccess) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *Bucket_IamConfiguration_UniformBucketLevelAccess) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *Bucket_IamConfiguration_UniformBucketLevelAccess) GetLockedTime() *timestamp.Timestamp {
	if x != nil {
		return x.LockedTime
	}
	return nil
}

// A lifecycle Rule, combining an action to take on an object and a
// condition which will trigger that action.
type Bucket_Lifecycle_Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The action to take.
	Action *Bucket_Lifecycle_Rule_Action `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// The condition(s) under which the action will be taken.
	Condition *Bucket_Lifecycle_Rule_Condition `protobuf:"bytes,2,opt,name=condition,proto3" json:"condition,omitempty"`
}

func (x *Bucket_Lifecycle_Rule) Reset() {
	*x = Bucket_Lifecycle_Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle_Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle_Rule) ProtoMessage() {}

func (x *Bucket_Lifecycle_Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle_Rule.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle_Rule) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *Bucket_Lifecycle_Rule) GetAction() *Bucket_Lifecycle_Rule_Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule) GetCondition() *Bucket_Lifecycle_Rule_Condition {
	if x != nil {
		return x.Condition
	}
	return nil
}

// An action to take on an object.
type Bucket_Lifecycle_Rule_Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the action. Currently, only `Delete` and
	// `SetStorageClass` are supported.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Target storage class. Required iff the type of the action is
	// SetStorageClass.
	StorageClass string `protobuf:"bytes,2,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
}

func (x *Bucket_Lifecycle_Rule_Action) Reset() {
	*x = Bucket_Lifecycle_Rule_Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle_Rule_Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle_Rule_Action) ProtoMessage() {}

func (x *Bucket_Lifecycle_Rule_Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle_Rule_Action.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle_Rule_Action) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 4, 0, 0}
}

func (x *Bucket_Lifecycle_Rule_Action) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Bucket_Lifecycle_Rule_Action) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

// A condition of an object which triggers some action.
type Bucket_Lifecycle_Rule_Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Age of an object (in days). This condition is satisfied when an
	// object reaches the specified age.
	Age int32 `protobuf:"varint,1,opt,name=age,proto3" json:"age,omitempty"`
	// A date in [RFC 3339][1] format with only the date part (for
	// instance, "2013-01-15"). This condition is satisfied when an
	// object is created before midnight of the specified date in UTC.
	// [1]: https://tools.ietf.org/html/rfc3339
	CreatedBefore *timestamp.Timestamp `protobuf:"bytes,2,opt,name=created_before,json=createdBefore,proto3" json:"created_before,omitempty"`
	// Relevant only for versioned objects. If the value is
	// `true`, this condition matches live objects; if the value
	// is `false`, it matches archived objects.
	IsLive *wrappers.BoolValue `protobuf:"bytes,3,opt,name=is_live,json=isLive,proto3" json:"is_live,omitempty"`
	// Relevant only for versioned objects. If the value is N, this
	// condition is satisfied when there are at least N versions (including
	// the live version) newer than this version of the object.
	NumNewerVersions int32 `protobuf:"varint,4,opt,name=num_newer_versions,json=numNewerVersions,proto3" json:"num_newer_versions,omitempty"`
	// Objects having any of the storage classes specified by this condition
	// will be matched. Values include `MULTI_REGIONAL`, `REGIONAL`,
	// `NEARLINE`, `COLDLINE`, `STANDARD`, and
	// `DURABLE_REDUCED_AVAILABILITY`.
	MatchesStorageClass []string `protobuf:"bytes,5,rep,name=matches_storage_class,json=matchesStorageClass,proto3" json:"matches_storage_class,omitempty"`
	// A regular expression that satisfies the RE2 syntax. This condition is
	// satisfied when the name of the object matches the RE2 pattern.  Note:
	// This feature is currently in the "Early Access" launch stage and is
	// only available to a whitelisted set of users; that means that this
	// feature may be changed in backward-incompatible ways and that it is
	// not guaranteed to be released.
	MatchesPattern string `protobuf:"bytes,6,opt,name=matches_pattern,json=matchesPattern,proto3" json:"matches_pattern,omitempty"`
}

func (x *Bucket_Lifecycle_Rule_Condition) Reset() {
	*x = Bucket_Lifecycle_Rule_Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Bucket_Lifecycle_Rule_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket_Lifecycle_Rule_Condition) ProtoMessage() {}

func (x *Bucket_Lifecycle_Rule_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket_Lifecycle_Rule_Condition.ProtoReflect.Descriptor instead.
func (*Bucket_Lifecycle_Rule_Condition) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{0, 4, 0, 1}
}

func (x *Bucket_Lifecycle_Rule_Condition) GetAge() int32 {
	if x != nil {
		return x.Age
	}
	return 0
}

func (x *Bucket_Lifecycle_Rule_Condition) GetCreatedBefore() *timestamp.Timestamp {
	if x != nil {
		return x.CreatedBefore
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule_Condition) GetIsLive() *wrappers.BoolValue {
	if x != nil {
		return x.IsLive
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule_Condition) GetNumNewerVersions() int32 {
	if x != nil {
		return x.NumNewerVersions
	}
	return 0
}

func (x *Bucket_Lifecycle_Rule_Condition) GetMatchesStorageClass() []string {
	if x != nil {
		return x.MatchesStorageClass
	}
	return nil
}

func (x *Bucket_Lifecycle_Rule_Condition) GetMatchesPattern() string {
	if x != nil {
		return x.MatchesPattern
	}
	return ""
}

type ListChannelsResponse_Items struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User-specified name for a channel. Needed to unsubscribe.
	ChannelId string `protobuf:"bytes,1,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Opaque value generated by GCS representing a bucket. Needed to
	// unsubscribe.
	ResourceId string `protobuf:"bytes,2,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// Url used to identify where notifications are sent to.
	PushUrl string `protobuf:"bytes,3,opt,name=push_url,json=pushUrl,proto3" json:"push_url,omitempty"`
	// Email address of the subscriber.
	SubscriberEmail string `protobuf:"bytes,4,opt,name=subscriber_email,json=subscriberEmail,proto3" json:"subscriber_email,omitempty"`
	// Time when the channel was created.
	CreationTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
}

func (x *ListChannelsResponse_Items) Reset() {
	*x = ListChannelsResponse_Items{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListChannelsResponse_Items) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChannelsResponse_Items) ProtoMessage() {}

func (x *ListChannelsResponse_Items) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChannelsResponse_Items.ProtoReflect.Descriptor instead.
func (*ListChannelsResponse_Items) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ListChannelsResponse_Items) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *ListChannelsResponse_Items) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *ListChannelsResponse_Items) GetPushUrl() string {
	if x != nil {
		return x.PushUrl
	}
	return ""
}

func (x *ListChannelsResponse_Items) GetSubscriberEmail() string {
	if x != nil {
		return x.SubscriberEmail
	}
	return ""
}

func (x *ListChannelsResponse_Items) GetCreationTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

// Describes the customer-specified mechanism used to store the data at rest.
type Object_CustomerEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The encryption algorithm.
	EncryptionAlgorithm string `protobuf:"bytes,1,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	// SHA256 hash value of the encryption key.
	KeySha256 string `protobuf:"bytes,2,opt,name=key_sha256,json=keySha256,proto3" json:"key_sha256,omitempty"`
}

func (x *Object_CustomerEncryption) Reset() {
	*x = Object_CustomerEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storage_v1_storage_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Object_CustomerEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Object_CustomerEncryption) ProtoMessage() {}

func (x *Object_CustomerEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_storage_v1_storage_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Object_CustomerEncryption.ProtoReflect.Descriptor instead.
func (*Object_CustomerEncryption) Descriptor() ([]byte, []int) {
	return file_google_storage_v1_storage_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *Object_CustomerEncryption) GetEncryptionAlgorithm() string {
	if x != nil {
		return x.EncryptionAlgorithm
	}
	return ""
}

func (x *Object_CustomerEncryption) GetKeySha256() string {
	if x != nil {
		return x.KeySha256
	}
	return ""
}

var File_google_storage_v1_storage_resources_proto protoreflect.FileDescriptor

var file_google_storage_v1_storage_resources_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xc1, 0x16, 0x0a, 0x06, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x03, 0x61, 0x63,
	0x6c, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52,
	0x03, 0x61, 0x63, 0x6c, 0x12, 0x54, 0x0a, 0x12, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x63, 0x6c, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x41, 0x0a, 0x09, 0x6c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x52, 0x09, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x3d, 0x0a,
	0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x32, 0x0a, 0x04, 0x63, 0x6f, 0x72, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x43, 0x6f, 0x72, 0x73, 0x52, 0x04, 0x63,
	0x6f, 0x72, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x37,
	0x0a, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x64, 0x5f, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x61,
	0x73, 0x65, 0x64, 0x48, 0x6f, 0x6c, 0x64, 0x12, 0x3d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x52, 0x07, 0x77, 0x65, 0x62, 0x73,
	0x69, 0x74, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x07, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52,
	0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x44, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x07,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x52, 0x07, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x54, 0x0a, 0x10, 0x72, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x16, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x52,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f,
	0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x23, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x69, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x49, 0x61, 0x6d, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x69, 0x61, 0x6d,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a,
	0x0d, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x19,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x7a, 0x6f, 0x6e, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x1a, 0x30, 0x0a, 0x07, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x25, 0x0a,
	0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72,
	0x50, 0x61, 0x79, 0x73, 0x1a, 0x87, 0x01, 0x0a, 0x04, 0x43, 0x6f, 0x72, 0x73, 0x12, 0x16, 0x0a,
	0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x27, 0x0a,
	0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x6d, 0x61, 0x78, 0x41, 0x67, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x1a, 0x3d,
	0x0a, 0x0a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x14,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x8a, 0x02,
	0x0a, 0x10, 0x49, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x82, 0x01, 0x0a, 0x1b, 0x75, 0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x2e, 0x49, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x18, 0x75,
	0x6e, 0x69, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x1a, 0x71, 0x0a, 0x18, 0x55, 0x6e, 0x69, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3b, 0x0a,
	0x0b, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xd3, 0x04, 0x0a, 0x09, 0x4c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x1a, 0x87, 0x04, 0x0a, 0x04, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x47, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x2e, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x41, 0x0a, 0x06, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x1a, 0xa0, 0x02,
	0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x61, 0x67, 0x65, 0x12, 0x41, 0x0a,
	0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x12, 0x33, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6c, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x69,
	0x73, 0x4c, 0x69, 0x76, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x6e, 0x65, 0x77,
	0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x10, 0x6e, 0x75, 0x6d, 0x4e, 0x65, 0x77, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x13, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e,
	0x1a, 0x54, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x6c,
	0x6f, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6c, 0x6f, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f,
	0x67, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x1a, 0x9c, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x41, 0x0a, 0x0e, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d,
	0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x69, 0x73, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x69, 0x73, 0x4c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0x26, 0x0a, 0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x59, 0x0a,
	0x07, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x69, 0x6e,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x61, 0x67, 0x65, 0x53, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x46,
	0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x67, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x8b, 0x02, 0x0a, 0x13, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x72,
	0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x41,
	0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x65, 0x61, 0x6d, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61,
	0x6d, 0x22, 0x60, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x05, 0x69, 0x74,
	0x65, 0x6d, 0x73, 0x22, 0x6e, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x05, 0x69, 0x74,
	0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xf2, 0x02, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x55, 0x72, 0x69, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3a, 0x0a, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x1a, 0x39, 0x0a,
	0x0b, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xac, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x43, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0xce, 0x01, 0x0a, 0x05, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12,
	0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x70, 0x75, 0x73, 0x68, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x75, 0x73, 0x68, 0x55, 0x72, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x73,
	0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
	0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x61, 0x0a, 0x0f, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x6d, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x22, 0x62, 0x0a, 0x0f, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x73, 0x12, 0x34, 0x0a,
	0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x72, 0x63,
	0x33, 0x32, 0x63, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x64, 0x35, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x64, 0x35, 0x48, 0x61, 0x73, 0x68, 0x22, 0xa7,
	0x04, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x73, 0x22, 0x3e,
	0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x16,
	0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x5f, 0x41,
	0x43, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x22, 0xd5,
	0x01, 0x0a, 0x13, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x52, 0x45, 0x44, 0x45, 0x46,
	0x49, 0x4e, 0x45, 0x44, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a,
	0x1d, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x41, 0x55, 0x54, 0x48,
	0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01,
	0x12, 0x16, 0x0a, 0x12, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x42, 0x55, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x55, 0x43, 0x4b,
	0x45, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x10, 0x04, 0x12, 0x20, 0x0a, 0x1c, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x41,
	0x43, 0x4c, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57,
	0x52, 0x49, 0x54, 0x45, 0x10, 0x05, 0x22, 0xff, 0x01, 0x0a, 0x13, 0x50, 0x72, 0x65, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x6c, 0x12, 0x25,
	0x0a, 0x21, 0x50, 0x52, 0x45, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x4f, 0x42, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f,
	0x41, 0x43, 0x4c, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x45,
	0x44, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x4f, 0x42, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4f, 0x57,
	0x4e, 0x45, 0x52, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c,
	0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c,
	0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x5f, 0x52, 0x45,
	0x41, 0x44, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41,
	0x43, 0x4c, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a,
	0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16,
	0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x4c, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x43, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x06, 0x22, 0x5f, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10,
	0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64,
	0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0xb0, 0x02, 0x0a, 0x0f, 0x48, 0x6d,
	0x61, 0x63, 0x4b, 0x65, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x34, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xe7, 0x02, 0x0a,
	0x0c, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x62, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x2c, 0x0a, 0x12,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x1a, 0x43, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x52, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0xc9, 0x0b, 0x0a, 0x06, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x2f, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x61, 0x63, 0x68, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x38, 0x0a, 0x03, 0x61, 0x63, 0x6c, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x03, 0x61, 0x63, 0x6c,
	0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x6d,
	0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x06, 0x63, 0x72, 0x63, 0x33,
	0x32, 0x63, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x63, 0x72, 0x63, 0x33, 0x32, 0x63, 0x12, 0x27,
	0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x64, 0x35, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x64, 0x35, 0x48, 0x61,
	0x73, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x34, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x23, 0x0a, 0x0d,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x12, 0x20, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x1a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x17, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e,
	0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x48,
	0x6f, 0x6c, 0x64, 0x12, 0x56, 0x0a, 0x19, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x17, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x70,
	0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x44, 0x0a, 0x10, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x64, 0x5f,
	0x68, 0x6f, 0x6c, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x61, 0x73,
	0x65, 0x64, 0x48, 0x6f, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x1b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x52, 0x05, 0x6f, 0x77, 0x6e,
	0x65, 0x72, 0x12, 0x5d, 0x0a, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x66, 0x0a, 0x12, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x14, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x6b, 0x65,
	0x79, 0x5f, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x6b, 0x65, 0x79, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xc3, 0x02, 0x0a, 0x13, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x12,
	0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f,
	0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x41, 0x0a, 0x0c, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x52,
	0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x22, 0x60, 0x0a, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3c, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x8a,
	0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x65, 0x73, 0x12, 0x2f, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x05, 0x69, 0x74,
	0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x48, 0x0a, 0x0b, 0x50,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x65, 0x61, 0x6d, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x65, 0x61, 0x6d, 0x22, 0x35, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x3c, 0x0a, 0x05,
	0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x42, 0x6f, 0x0a, 0x15, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x42, 0x1a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_storage_v1_storage_resources_proto_rawDescOnce sync.Once
	file_google_storage_v1_storage_resources_proto_rawDescData = file_google_storage_v1_storage_resources_proto_rawDesc
)

func file_google_storage_v1_storage_resources_proto_rawDescGZIP() []byte {
	file_google_storage_v1_storage_resources_proto_rawDescOnce.Do(func() {
		file_google_storage_v1_storage_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storage_v1_storage_resources_proto_rawDescData)
	})
	return file_google_storage_v1_storage_resources_proto_rawDescData
}

var file_google_storage_v1_storage_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_storage_v1_storage_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_storage_v1_storage_resources_proto_goTypes = []interface{}{
	(CommonEnums_Projection)(0),              // 0: google.storage.v1.CommonEnums.Projection
	(CommonEnums_PredefinedBucketAcl)(0),     // 1: google.storage.v1.CommonEnums.PredefinedBucketAcl
	(CommonEnums_PredefinedObjectAcl)(0),     // 2: google.storage.v1.CommonEnums.PredefinedObjectAcl
	(*Bucket)(nil),                           // 3: google.storage.v1.Bucket
	(*BucketAccessControl)(nil),              // 4: google.storage.v1.BucketAccessControl
	(*ListBucketAccessControlsResponse)(nil), // 5: google.storage.v1.ListBucketAccessControlsResponse
	(*ListBucketsResponse)(nil),              // 6: google.storage.v1.ListBucketsResponse
	(*Channel)(nil),                          // 7: google.storage.v1.Channel
	(*ListChannelsResponse)(nil),             // 8: google.storage.v1.ListChannelsResponse
	(*ChecksummedData)(nil),                  // 9: google.storage.v1.ChecksummedData
	(*ObjectChecksums)(nil),                  // 10: google.storage.v1.ObjectChecksums
	(*CommonEnums)(nil),                      // 11: google.storage.v1.CommonEnums
	(*ContentRange)(nil),                     // 12: google.storage.v1.ContentRange
	(*HmacKeyMetadata)(nil),                  // 13: google.storage.v1.HmacKeyMetadata
	(*Notification)(nil),                     // 14: google.storage.v1.Notification
	(*ListNotificationsResponse)(nil),        // 15: google.storage.v1.ListNotificationsResponse
	(*Object)(nil),                           // 16: google.storage.v1.Object
	(*ObjectAccessControl)(nil),              // 17: google.storage.v1.ObjectAccessControl
	(*ListObjectAccessControlsResponse)(nil), // 18: google.storage.v1.ListObjectAccessControlsResponse
	(*ListObjectsResponse)(nil),              // 19: google.storage.v1.ListObjectsResponse
	(*ProjectTeam)(nil),                      // 20: google.storage.v1.ProjectTeam
	(*ServiceAccount)(nil),                   // 21: google.storage.v1.ServiceAccount
	(*Owner)(nil),                            // 22: google.storage.v1.Owner
	(*Bucket_Billing)(nil),                   // 23: google.storage.v1.Bucket.Billing
	(*Bucket_Cors)(nil),                      // 24: google.storage.v1.Bucket.Cors
	(*Bucket_Encryption)(nil),                // 25: google.storage.v1.Bucket.Encryption
	(*Bucket_IamConfiguration)(nil),          // 26: google.storage.v1.Bucket.IamConfiguration
	(*Bucket_Lifecycle)(nil),                 // 27: google.storage.v1.Bucket.Lifecycle
	(*Bucket_Logging)(nil),                   // 28: google.storage.v1.Bucket.Logging
	(*Bucket_RetentionPolicy)(nil),           // 29: google.storage.v1.Bucket.RetentionPolicy
	(*Bucket_Versioning)(nil),                // 30: google.storage.v1.Bucket.Versioning
	(*Bucket_Website)(nil),                   // 31: google.storage.v1.Bucket.Website
	nil,                                      // 32: google.storage.v1.Bucket.LabelsEntry
	(*Bucket_IamConfiguration_UniformBucketLevelAccess)(nil), // 33: google.storage.v1.Bucket.IamConfiguration.UniformBucketLevelAccess
	(*Bucket_Lifecycle_Rule)(nil),                            // 34: google.storage.v1.Bucket.Lifecycle.Rule
	(*Bucket_Lifecycle_Rule_Action)(nil),                     // 35: google.storage.v1.Bucket.Lifecycle.Rule.Action
	(*Bucket_Lifecycle_Rule_Condition)(nil),                  // 36: google.storage.v1.Bucket.Lifecycle.Rule.Condition
	nil,                                                      // 37: google.storage.v1.Channel.ParamsEntry
	(*ListChannelsResponse_Items)(nil),                       // 38: google.storage.v1.ListChannelsResponse.Items
	nil,                                                      // 39: google.storage.v1.Notification.CustomAttributesEntry
	(*Object_CustomerEncryption)(nil),                        // 40: google.storage.v1.Object.CustomerEncryption
	nil,                                                      // 41: google.storage.v1.Object.MetadataEntry
	(*timestamp.Timestamp)(nil),                              // 42: google.protobuf.Timestamp
	(*wrappers.UInt32Value)(nil),                             // 43: google.protobuf.UInt32Value
	(*wrappers.BoolValue)(nil),                               // 44: google.protobuf.BoolValue
}
var file_google_storage_v1_storage_resources_proto_depIdxs = []int32{
	4,  // 0: google.storage.v1.Bucket.acl:type_name -> google.storage.v1.BucketAccessControl
	17, // 1: google.storage.v1.Bucket.default_object_acl:type_name -> google.storage.v1.ObjectAccessControl
	27, // 2: google.storage.v1.Bucket.lifecycle:type_name -> google.storage.v1.Bucket.Lifecycle
	42, // 3: google.storage.v1.Bucket.time_created:type_name -> google.protobuf.Timestamp
	24, // 4: google.storage.v1.Bucket.cors:type_name -> google.storage.v1.Bucket.Cors
	42, // 5: google.storage.v1.Bucket.updated:type_name -> google.protobuf.Timestamp
	32, // 6: google.storage.v1.Bucket.labels:type_name -> google.storage.v1.Bucket.LabelsEntry
	31, // 7: google.storage.v1.Bucket.website:type_name -> google.storage.v1.Bucket.Website
	30, // 8: google.storage.v1.Bucket.versioning:type_name -> google.storage.v1.Bucket.Versioning
	28, // 9: google.storage.v1.Bucket.logging:type_name -> google.storage.v1.Bucket.Logging
	22, // 10: google.storage.v1.Bucket.owner:type_name -> google.storage.v1.Owner
	25, // 11: google.storage.v1.Bucket.encryption:type_name -> google.storage.v1.Bucket.Encryption
	23, // 12: google.storage.v1.Bucket.billing:type_name -> google.storage.v1.Bucket.Billing
	29, // 13: google.storage.v1.Bucket.retention_policy:type_name -> google.storage.v1.Bucket.RetentionPolicy
	26, // 14: google.storage.v1.Bucket.iam_configuration:type_name -> google.storage.v1.Bucket.IamConfiguration
	20, // 15: google.storage.v1.BucketAccessControl.project_team:type_name -> google.storage.v1.ProjectTeam
	4,  // 16: google.storage.v1.ListBucketAccessControlsResponse.items:type_name -> google.storage.v1.BucketAccessControl
	3,  // 17: google.storage.v1.ListBucketsResponse.items:type_name -> google.storage.v1.Bucket
	42, // 18: google.storage.v1.Channel.expiration:type_name -> google.protobuf.Timestamp
	37, // 19: google.storage.v1.Channel.params:type_name -> google.storage.v1.Channel.ParamsEntry
	38, // 20: google.storage.v1.ListChannelsResponse.items:type_name -> google.storage.v1.ListChannelsResponse.Items
	43, // 21: google.storage.v1.ChecksummedData.crc32c:type_name -> google.protobuf.UInt32Value
	43, // 22: google.storage.v1.ObjectChecksums.crc32c:type_name -> google.protobuf.UInt32Value
	42, // 23: google.storage.v1.HmacKeyMetadata.time_created:type_name -> google.protobuf.Timestamp
	42, // 24: google.storage.v1.HmacKeyMetadata.updated:type_name -> google.protobuf.Timestamp
	39, // 25: google.storage.v1.Notification.custom_attributes:type_name -> google.storage.v1.Notification.CustomAttributesEntry
	14, // 26: google.storage.v1.ListNotificationsResponse.items:type_name -> google.storage.v1.Notification
	17, // 27: google.storage.v1.Object.acl:type_name -> google.storage.v1.ObjectAccessControl
	42, // 28: google.storage.v1.Object.time_deleted:type_name -> google.protobuf.Timestamp
	42, // 29: google.storage.v1.Object.time_created:type_name -> google.protobuf.Timestamp
	43, // 30: google.storage.v1.Object.crc32c:type_name -> google.protobuf.UInt32Value
	42, // 31: google.storage.v1.Object.updated:type_name -> google.protobuf.Timestamp
	42, // 32: google.storage.v1.Object.time_storage_class_updated:type_name -> google.protobuf.Timestamp
	42, // 33: google.storage.v1.Object.retention_expiration_time:type_name -> google.protobuf.Timestamp
	41, // 34: google.storage.v1.Object.metadata:type_name -> google.storage.v1.Object.MetadataEntry
	44, // 35: google.storage.v1.Object.event_based_hold:type_name -> google.protobuf.BoolValue
	22, // 36: google.storage.v1.Object.owner:type_name -> google.storage.v1.Owner
	40, // 37: google.storage.v1.Object.customer_encryption:type_name -> google.storage.v1.Object.CustomerEncryption
	20, // 38: google.storage.v1.ObjectAccessControl.project_team:type_name -> google.storage.v1.ProjectTeam
	17, // 39: google.storage.v1.ListObjectAccessControlsResponse.items:type_name -> google.storage.v1.ObjectAccessControl
	16, // 40: google.storage.v1.ListObjectsResponse.items:type_name -> google.storage.v1.Object
	33, // 41: google.storage.v1.Bucket.IamConfiguration.uniform_bucket_level_access:type_name -> google.storage.v1.Bucket.IamConfiguration.UniformBucketLevelAccess
	34, // 42: google.storage.v1.Bucket.Lifecycle.rule:type_name -> google.storage.v1.Bucket.Lifecycle.Rule
	42, // 43: google.storage.v1.Bucket.RetentionPolicy.effective_time:type_name -> google.protobuf.Timestamp
	42, // 44: google.storage.v1.Bucket.IamConfiguration.UniformBucketLevelAccess.locked_time:type_name -> google.protobuf.Timestamp
	35, // 45: google.storage.v1.Bucket.Lifecycle.Rule.action:type_name -> google.storage.v1.Bucket.Lifecycle.Rule.Action
	36, // 46: google.storage.v1.Bucket.Lifecycle.Rule.condition:type_name -> google.storage.v1.Bucket.Lifecycle.Rule.Condition
	42, // 47: google.storage.v1.Bucket.Lifecycle.Rule.Condition.created_before:type_name -> google.protobuf.Timestamp
	44, // 48: google.storage.v1.Bucket.Lifecycle.Rule.Condition.is_live:type_name -> google.protobuf.BoolValue
	42, // 49: google.storage.v1.ListChannelsResponse.Items.creation_time:type_name -> google.protobuf.Timestamp
	50, // [50:50] is the sub-list for method output_type
	50, // [50:50] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_storage_v1_storage_resources_proto_init() }
func file_google_storage_v1_storage_resources_proto_init() {
	if File_google_storage_v1_storage_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_storage_v1_storage_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BucketAccessControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBucketAccessControlsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBucketsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Channel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChecksummedData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectChecksums); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommonEnums); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContentRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HmacKeyMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Notification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNotificationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Object); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectAccessControl); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListObjectAccessControlsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListObjectsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProjectTeam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Owner); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Billing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Cors); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Encryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_IamConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Logging); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_RetentionPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Versioning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Website); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_IamConfiguration_UniformBucketLevelAccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle_Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle_Rule_Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Bucket_Lifecycle_Rule_Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListChannelsResponse_Items); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storage_v1_storage_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Object_CustomerEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storage_v1_storage_resources_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_storage_v1_storage_resources_proto_goTypes,
		DependencyIndexes: file_google_storage_v1_storage_resources_proto_depIdxs,
		EnumInfos:         file_google_storage_v1_storage_resources_proto_enumTypes,
		MessageInfos:      file_google_storage_v1_storage_resources_proto_msgTypes,
	}.Build()
	File_google_storage_v1_storage_resources_proto = out.File
	file_google_storage_v1_storage_resources_proto_rawDesc = nil
	file_google_storage_v1_storage_resources_proto_goTypes = nil
	file_google_storage_v1_storage_resources_proto_depIdxs = nil
}
