/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.psvi;

import com.sun.msv.grammar.ElementExp;
import com.sun.msv.util.DatatypeRef;
import com.sun.msv.util.StartTagInfo;
import com.sun.msv.util.StringRef;
import com.sun.msv.verifier.Acceptor;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.ErrorInfo;
import com.sun.msv.verifier.ValidityViolation;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.psvi.TypedContentHandler;
import com.sun.msv.verifier.regexp.ComplexAcceptor;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.regexp.SimpleAcceptor;
import java.util.StringTokenizer;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class TypeDetector
extends Verifier {
    private StringBuffer text = new StringBuffer();
    protected TypedContentHandler handler;
    private final DatatypeRef characterType = new DatatypeRef();

    public TypeDetector(DocumentDeclaration documentDeclaration, ErrorHandler errorHandler) {
        super(documentDeclaration, errorHandler);
    }

    public TypeDetector(DocumentDeclaration documentDeclaration, TypedContentHandler typedContentHandler, ErrorHandler errorHandler) {
        this(documentDeclaration, errorHandler);
        this.setContentHandler(typedContentHandler);
    }

    public void setContentHandler(TypedContentHandler typedContentHandler) {
        this.handler = typedContentHandler;
    }

    protected void verifyText() throws SAXException {
        if (this.text.length() != 0) {
            String string = new String(this.text);
            if (!this.current.onText(string, this, null, this.characterType)) {
                StringRef stringRef = new StringRef();
                this.current.onText(string, this, stringRef, null);
                this.errorHandler.error(new ValidityViolation(this.locator, Verifier.localizeMessage("Verifier.Error.UnexpectedText", null), new ErrorInfo.BadText(string)));
            }
            this.reportCharacterChunks(string, this.characterType.types);
            this.text = new StringBuffer();
        }
    }

    private void reportCharacterChunks(String string, Datatype[] datatypeArray) throws SAXException {
        if (datatypeArray == null) {
            throw new AmbiguousDocumentException();
        }
        switch (datatypeArray.length) {
            case 0: {
                return;
            }
            case 1: {
                this.handler.characterChunk(string, datatypeArray[0]);
                return;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        while (n < datatypeArray.length) {
            this.handler.characterChunk(stringTokenizer.nextToken(), datatypeArray[n]);
            ++n;
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new Error();
        }
    }

    protected Datatype[] feedAttribute(Acceptor acceptor, String string, String string2, String string3, String string4) throws SAXException {
        Datatype[] datatypeArray = super.feedAttribute(acceptor, string, string2, string3, string4);
        this.handler.startAttribute(string, string2, string3);
        this.reportCharacterChunks(string4, datatypeArray);
        this.handler.endAttribute(string, string2, string3, ((REDocumentDeclaration)this.docDecl).attToken.matchedExp);
        return datatypeArray;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        this.handler.endAttributePart();
    }

    protected void onNextAcceptorReady(StartTagInfo startTagInfo, Acceptor acceptor) throws SAXException {
        this.handler.startElement(startTagInfo.namespaceURI, startTagInfo.localName, startTagInfo.qName);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        ElementExp elementExp;
        Acceptor acceptor = this.current;
        super.endElement(string, string2, string3);
        if (acceptor instanceof SimpleAcceptor) {
            elementExp = ((SimpleAcceptor)acceptor).owner;
        } else if (acceptor instanceof ComplexAcceptor) {
            ElementExp[] elementExpArray = ((ComplexAcceptor)acceptor).getSatisfiedOwners();
            if (elementExpArray.length != 1) {
                throw new AmbiguousDocumentException();
            }
            elementExp = elementExpArray[0];
        } else {
            throw new Error();
        }
        this.handler.endElement(string, string2, string3, elementExp);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.text.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.text.append(cArray, n, n2);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.handler.startDocument(this);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.handler.endDocument();
    }

    public class AmbiguousDocumentException
    extends SAXException {
        public AmbiguousDocumentException() {
            super("");
        }

        Locator getLocation() {
            return TypeDetector.this.getLocator();
        }
    }
}

