/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.optimization;

import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTThrowStatement;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.rules.optimization.AbstractOptimizationRule;

public class AvoidInstantiatingObjectsInLoops
extends AbstractOptimizationRule {
    public Object visit(ASTAllocationExpression node, Object data) {
        if (this.insideLoop(node) && this.fourthParentNotThrow(node) && this.fourthParentNotReturn(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean fourthParentNotThrow(ASTAllocationExpression node) {
        return !(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTThrowStatement);
    }

    private boolean fourthParentNotReturn(ASTAllocationExpression node) {
        return !(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTReturnStatement);
    }

    private boolean insideLoop(ASTAllocationExpression node) {
        if (node.getFirstParentOfType(ASTDoStatement.class) != null) {
            return true;
        }
        if (node.getFirstParentOfType(ASTWhileStatement.class) != null) {
            return true;
        }
        return node.getFirstParentOfType(ASTForStatement.class) != null;
    }
}

