package sas_api

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePerDateData invokes the sas_api.DescribePerDateData API synchronously
// api document: https://help.aliyun.com/api/sas-api/describeperdatedata.html
func (client *Client) DescribePerDateData(request *DescribePerDateDataRequest) (response *DescribePerDateDataResponse, err error) {
	response = CreateDescribePerDateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePerDateDataWithChan invokes the sas_api.DescribePerDateData API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describeperdatedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePerDateDataWithChan(request *DescribePerDateDataRequest) (<-chan *DescribePerDateDataResponse, <-chan error) {
	responseChan := make(chan *DescribePerDateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePerDateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePerDateDataWithCallback invokes the sas_api.DescribePerDateData API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describeperdatedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePerDateDataWithCallback(request *DescribePerDateDataRequest, callback func(response *DescribePerDateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePerDateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribePerDateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePerDateDataRequest is the request struct for api DescribePerDateData
type DescribePerDateDataRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	ApiType  requests.Integer `position:"Query" name:"ApiType"`
}

// DescribePerDateDataResponse is the response struct for api DescribePerDateData
type DescribePerDateDataResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	DataView  []DataView `json:"DataView" xml:"DataView"`
}

// CreateDescribePerDateDataRequest creates a request to invoke DescribePerDateData API
func CreateDescribePerDateDataRequest() (request *DescribePerDateDataRequest) {
	request = &DescribePerDateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas-api", "2017-07-05", "DescribePerDateData", "sas-api", "openAPI")
	return
}

// CreateDescribePerDateDataResponse creates a response to parse from DescribePerDateData response
func CreateDescribePerDateDataResponse() (response *DescribePerDateDataResponse) {
	response = &DescribePerDateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
