package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosticConfig invokes the netana.DescribeDiagnosticConfig API synchronously
// api document: https://help.aliyun.com/api/netana/describediagnosticconfig.html
func (client *Client) DescribeDiagnosticConfig(request *DescribeDiagnosticConfigRequest) (response *DescribeDiagnosticConfigResponse, err error) {
	response = CreateDescribeDiagnosticConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosticConfigWithChan invokes the netana.DescribeDiagnosticConfig API asynchronously
// api document: https://help.aliyun.com/api/netana/describediagnosticconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDiagnosticConfigWithChan(request *DescribeDiagnosticConfigRequest) (<-chan *DescribeDiagnosticConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosticConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosticConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosticConfigWithCallback invokes the netana.DescribeDiagnosticConfig API asynchronously
// api document: https://help.aliyun.com/api/netana/describediagnosticconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDiagnosticConfigWithCallback(request *DescribeDiagnosticConfigRequest, callback func(response *DescribeDiagnosticConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosticConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosticConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosticConfigRequest is the request struct for api DescribeDiagnosticConfig
type DescribeDiagnosticConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProductType          string           `position:"Query" name:"ProductType"`
}

// DescribeDiagnosticConfigResponse is the response struct for api DescribeDiagnosticConfig
type DescribeDiagnosticConfigResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	ApiList   ApiList `json:"ApiList" xml:"ApiList"`
}

// CreateDescribeDiagnosticConfigRequest creates a request to invoke DescribeDiagnosticConfig API
func CreateDescribeDiagnosticConfigRequest() (request *DescribeDiagnosticConfigRequest) {
	request = &DescribeDiagnosticConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "DescribeDiagnosticConfig", "Netana", "openAPI")
	return
}

// CreateDescribeDiagnosticConfigResponse creates a response to parse from DescribeDiagnosticConfig response
func CreateDescribeDiagnosticConfigResponse() (response *DescribeDiagnosticConfigResponse) {
	response = &DescribeDiagnosticConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
