package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetReserveDomainUrl invokes the domain.GetReserveDomainUrl API synchronously
func (client *Client) GetReserveDomainUrl(request *GetReserveDomainUrlRequest) (response *GetReserveDomainUrlResponse, err error) {
	response = CreateGetReserveDomainUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetReserveDomainUrlWithChan invokes the domain.GetReserveDomainUrl API asynchronously
func (client *Client) GetReserveDomainUrlWithChan(request *GetReserveDomainUrlRequest) (<-chan *GetReserveDomainUrlResponse, <-chan error) {
	responseChan := make(chan *GetReserveDomainUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetReserveDomainUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetReserveDomainUrlWithCallback invokes the domain.GetReserveDomainUrl API asynchronously
func (client *Client) GetReserveDomainUrlWithCallback(request *GetReserveDomainUrlRequest, callback func(response *GetReserveDomainUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetReserveDomainUrlResponse
		var err error
		defer close(result)
		response, err = client.GetReserveDomainUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetReserveDomainUrlRequest is the request struct for api GetReserveDomainUrl
type GetReserveDomainUrlRequest struct {
	*requests.RpcRequest
}

// GetReserveDomainUrlResponse is the response struct for api GetReserveDomainUrl
type GetReserveDomainUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Url       string `json:"Url" xml:"Url"`
}

// CreateGetReserveDomainUrlRequest creates a request to invoke GetReserveDomainUrl API
func CreateGetReserveDomainUrlRequest() (request *GetReserveDomainUrlRequest) {
	request = &GetReserveDomainUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "GetReserveDomainUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateGetReserveDomainUrlResponse creates a response to parse from GetReserveDomainUrl response
func CreateGetReserveDomainUrlResponse() (response *GetReserveDomainUrlResponse) {
	response = &GetReserveDomainUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
