package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApgroupConfig invokes the cloudwf.ListApgroupConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listapgroupconfig.html
func (client *Client) ListApgroupConfig(request *ListApgroupConfigRequest) (response *ListApgroupConfigResponse, err error) {
	response = CreateListApgroupConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListApgroupConfigWithChan invokes the cloudwf.ListApgroupConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapgroupconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApgroupConfigWithChan(request *ListApgroupConfigRequest) (<-chan *ListApgroupConfigResponse, <-chan error) {
	responseChan := make(chan *ListApgroupConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApgroupConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApgroupConfigWithCallback invokes the cloudwf.ListApgroupConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapgroupconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApgroupConfigWithCallback(request *ListApgroupConfigRequest, callback func(response *ListApgroupConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApgroupConfigResponse
		var err error
		defer close(result)
		response, err = client.ListApgroupConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApgroupConfigRequest is the request struct for api ListApgroupConfig
type ListApgroupConfigRequest struct {
	*requests.RpcRequest
	OrderCol      string           `position:"Query" name:"OrderCol"`
	SearchName    string           `position:"Query" name:"SearchName"`
	SearchCompany string           `position:"Query" name:"SearchCompany"`
	Length        requests.Integer `position:"Query" name:"Length"`
	PageIndex     requests.Integer `position:"Query" name:"PageIndex"`
	OrderDir      string           `position:"Query" name:"OrderDir"`
}

// ListApgroupConfigResponse is the response struct for api ListApgroupConfig
type ListApgroupConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApgroupConfigRequest creates a request to invoke ListApgroupConfig API
func CreateListApgroupConfigRequest() (request *ListApgroupConfigRequest) {
	request = &ListApgroupConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApgroupConfig", "cloudwf", "openAPI")
	return
}

// CreateListApgroupConfigResponse creates a response to parse from ListApgroupConfig response
func CreateListApgroupConfigResponse() (response *ListApgroupConfigResponse) {
	response = &ListApgroupConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
