package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterNetInfoItems invokes the clickhouse.DescribeDBClusterNetInfoItems API synchronously
func (client *Client) DescribeDBClusterNetInfoItems(request *DescribeDBClusterNetInfoItemsRequest) (response *DescribeDBClusterNetInfoItemsResponse, err error) {
	response = CreateDescribeDBClusterNetInfoItemsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterNetInfoItemsWithChan invokes the clickhouse.DescribeDBClusterNetInfoItems API asynchronously
func (client *Client) DescribeDBClusterNetInfoItemsWithChan(request *DescribeDBClusterNetInfoItemsRequest) (<-chan *DescribeDBClusterNetInfoItemsResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterNetInfoItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterNetInfoItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterNetInfoItemsWithCallback invokes the clickhouse.DescribeDBClusterNetInfoItems API asynchronously
func (client *Client) DescribeDBClusterNetInfoItemsWithCallback(request *DescribeDBClusterNetInfoItemsRequest, callback func(response *DescribeDBClusterNetInfoItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterNetInfoItemsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterNetInfoItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterNetInfoItemsRequest is the request struct for api DescribeDBClusterNetInfoItems
type DescribeDBClusterNetInfoItemsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterNetInfoItemsResponse is the response struct for api DescribeDBClusterNetInfoItems
type DescribeDBClusterNetInfoItemsResponse struct {
	*responses.BaseResponse
	ClusterNetworkType string       `json:"ClusterNetworkType" xml:"ClusterNetworkType"`
	RequestId          string       `json:"RequestId" xml:"RequestId"`
	NetInfoItems       NetInfoItems `json:"NetInfoItems" xml:"NetInfoItems"`
}

// CreateDescribeDBClusterNetInfoItemsRequest creates a request to invoke DescribeDBClusterNetInfoItems API
func CreateDescribeDBClusterNetInfoItemsRequest() (request *DescribeDBClusterNetInfoItemsRequest) {
	request = &DescribeDBClusterNetInfoItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeDBClusterNetInfoItems", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterNetInfoItemsResponse creates a response to parse from DescribeDBClusterNetInfoItems response
func CreateDescribeDBClusterNetInfoItemsResponse() (response *DescribeDBClusterNetInfoItemsResponse) {
	response = &DescribeDBClusterNetInfoItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
