package brinekingdom

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryQuotaPlanSchedule invokes the brinekingdom.QueryQuotaPlanSchedule API synchronously
func (client *Client) QueryQuotaPlanSchedule(request *QueryQuotaPlanScheduleRequest) (response *QueryQuotaPlanScheduleResponse, err error) {
	response = CreateQueryQuotaPlanScheduleResponse()
	err = client.DoAction(request, response)
	return
}

// QueryQuotaPlanScheduleWithChan invokes the brinekingdom.QueryQuotaPlanSchedule API asynchronously
func (client *Client) QueryQuotaPlanScheduleWithChan(request *QueryQuotaPlanScheduleRequest) (<-chan *QueryQuotaPlanScheduleResponse, <-chan error) {
	responseChan := make(chan *QueryQuotaPlanScheduleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryQuotaPlanSchedule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryQuotaPlanScheduleWithCallback invokes the brinekingdom.QueryQuotaPlanSchedule API asynchronously
func (client *Client) QueryQuotaPlanScheduleWithCallback(request *QueryQuotaPlanScheduleRequest, callback func(response *QueryQuotaPlanScheduleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryQuotaPlanScheduleResponse
		var err error
		defer close(result)
		response, err = client.QueryQuotaPlanSchedule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryQuotaPlanScheduleRequest is the request struct for api QueryQuotaPlanSchedule
type QueryQuotaPlanScheduleRequest struct {
	*requests.RpcRequest
	QuotaPlanIds *[]string `position:"Query" name:"QuotaPlanIds"  type:"Repeated"`
}

// QueryQuotaPlanScheduleResponse is the response struct for api QueryQuotaPlanSchedule
type QueryQuotaPlanScheduleResponse struct {
	*responses.BaseResponse
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	ResultCode   string       `json:"ResultCode" xml:"ResultCode"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateQueryQuotaPlanScheduleRequest creates a request to invoke QueryQuotaPlanSchedule API
func CreateQueryQuotaPlanScheduleRequest() (request *QueryQuotaPlanScheduleRequest) {
	request = &QueryQuotaPlanScheduleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("brinekingdom", "2019-06-27", "QueryQuotaPlanSchedule", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryQuotaPlanScheduleResponse creates a response to parse from QueryQuotaPlanSchedule response
func CreateQueryQuotaPlanScheduleResponse() (response *QueryQuotaPlanScheduleResponse) {
	response = &QueryQuotaPlanScheduleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
