# This is Bisqwit's generic subdirs.mak, included from Makefile.
# The same file is used in many different projects.
# For complex systems.
#
# subdirs.mak version 1.0.3
# 
# Required files:
#   depfun.mak
#   ./configure
#
# Generated files:
#   config.log
#
# Targets:
#   all
#   thisclean
#   clean
#   distclean
#   config.log
#
# Required settings:
#   PROGS=prog1 prog2 prog3...
#   SUBDIRS=dir1 dir2 dir3...

all: config.log $(PROGS) $(SUBDIRS)

# This addsuffix thing is to allow -j and -k to work smoothly.
# Propagated from the GNU make info pages.

$(SUBDIRS):
	@$(MAKE) -C $@
$(addsuffix .distclean,$(SUBDIRS)):
	@$(MAKE) -C $(basename $@) distclean
$(addsuffix .clean,$(SUBDIRS)):
	@$(MAKE) -C $(basename $@) clean

include depfun.mak

thisclean:
	rm -f $(PROGS) *.o
clean: thisclean $(addsuffix .clean,$(SUBDIRS))
distclean: thisclean $(addsuffix .distclean,$(SUBDIRS))
	rm -f *~ .depend config.log bb.out gmon.out
realclean: distclean

config.log: configure
	@ ./configure
	@ cat config.log >/dev/null 2>&1

.PHONY: all thisclean clean distclean realclean \
        $(SUBDIRS) \
        $(addsuffix .clean,$(SUBDIRS)) \
        $(addsuffix .distclean,$(SUBDIRS))
