//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontrolinteractionstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPageControlInteractionState(pub NSInteger);
impl UIPageControlInteractionState {
    /// The default interaction state, where no interaction has occurred.
    #[doc(alias = "UIPageControlInteractionStateNone")]
    pub const None: Self = Self(0);
    /// The interaction state for which the page was changed via a single, discrete interaction.
    #[doc(alias = "UIPageControlInteractionStateDiscrete")]
    pub const Discrete: Self = Self(1);
    /// The interaction state for which the page was changed via a continuous interaction.
    #[doc(alias = "UIPageControlInteractionStateContinuous")]
    pub const Continuous: Self = Self(2);
}

unsafe impl Encode for UIPageControlInteractionState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIPageControlInteractionState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontrolbackgroundstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPageControlBackgroundStyle(pub NSInteger);
impl UIPageControlBackgroundStyle {
    /// The default background style that adapts based on the current interaction state.
    #[doc(alias = "UIPageControlBackgroundStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    /// The background style that shows a full background regardless of the interaction
    #[doc(alias = "UIPageControlBackgroundStyleProminent")]
    pub const Prominent: Self = Self(1);
    /// The background style that shows a minimal background regardless of the interaction
    #[doc(alias = "UIPageControlBackgroundStyleMinimal")]
    pub const Minimal: Self = Self(2);
}

unsafe impl Encode for UIPageControlBackgroundStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIPageControlBackgroundStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontroldirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPageControlDirection(pub NSInteger);
impl UIPageControlDirection {
    /// Page indicators are laid out in the natural direction of the system locale.
    /// By default, this is equivalent to
    /// `UIPageControlDirectionLeftToRight`on LTR locales, and
    /// `UIPageControlDirectionRightToLeft`on RTL locales.
    #[doc(alias = "UIPageControlDirectionNatural")]
    pub const Natural: Self = Self(0);
    /// Page indicators are laid out from left to right.
    #[doc(alias = "UIPageControlDirectionLeftToRight")]
    pub const LeftToRight: Self = Self(1);
    /// Page indicators are laid out from right to left.
    #[doc(alias = "UIPageControlDirectionRightToLeft")]
    pub const RightToLeft: Self = Self(2);
    /// Page indicators are laid out from top to bottom.
    #[doc(alias = "UIPageControlDirectionTopToBottom")]
    pub const TopToBottom: Self = Self(3);
    /// Page indicators are laid out from bottom to top.
    #[doc(alias = "UIPageControlDirectionBottomToTop")]
    pub const BottomToTop: Self = Self(4);
}

unsafe impl Encode for UIPageControlDirection {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIPageControlDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipagecontrol?language=objc)
    #[unsafe(super(UIControl, UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
    pub struct UIPageControl;
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UIPageControl {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UIPageControl {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIPageControl {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearance for UIPageControl {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIPageControl {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UIPageControl {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UIPageControl {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIPageControl {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItem for UIPageControl {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UIPageControl {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIPageControl {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIPageControl {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIPageControl {
    extern_methods!(
        /// default is 0
        #[unsafe(method(numberOfPages))]
        #[unsafe(method_family = none)]
        pub fn numberOfPages(&self) -> NSInteger;

        /// Setter for [`numberOfPages`][Self::numberOfPages].
        #[unsafe(method(setNumberOfPages:))]
        #[unsafe(method_family = none)]
        pub fn setNumberOfPages(&self, number_of_pages: NSInteger);

        /// default is 0. Value is pinned to 0..numberOfPages-1
        #[unsafe(method(currentPage))]
        #[unsafe(method_family = none)]
        pub fn currentPage(&self) -> NSInteger;

        /// Setter for [`currentPage`][Self::currentPage].
        #[unsafe(method(setCurrentPage:))]
        #[unsafe(method_family = none)]
        pub fn setCurrentPage(&self, current_page: NSInteger);

        /// hides the indicator if there is only one page, default is NO
        #[unsafe(method(hidesForSinglePage))]
        #[unsafe(method_family = none)]
        pub fn hidesForSinglePage(&self) -> bool;

        /// Setter for [`hidesForSinglePage`][Self::hidesForSinglePage].
        #[unsafe(method(setHidesForSinglePage:))]
        #[unsafe(method_family = none)]
        pub fn setHidesForSinglePage(&self, hides_for_single_page: bool);

        #[cfg(feature = "UIPageControlProgress")]
        /// An object that defines the progress of the page control. Default is nil.
        #[unsafe(method(progress))]
        #[unsafe(method_family = none)]
        pub fn progress(&self) -> Option<Retained<UIPageControlProgress>>;

        #[cfg(feature = "UIPageControlProgress")]
        /// Setter for [`progress`][Self::progress].
        #[unsafe(method(setProgress:))]
        #[unsafe(method_family = none)]
        pub fn setProgress(&self, progress: Option<&UIPageControlProgress>);

        #[cfg(feature = "UIColor")]
        /// The tint color for non-selected indicators. Default is nil.
        #[unsafe(method(pageIndicatorTintColor))]
        #[unsafe(method_family = none)]
        pub fn pageIndicatorTintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`pageIndicatorTintColor`][Self::pageIndicatorTintColor].
        #[unsafe(method(setPageIndicatorTintColor:))]
        #[unsafe(method_family = none)]
        pub fn setPageIndicatorTintColor(&self, page_indicator_tint_color: Option<&UIColor>);

        #[cfg(feature = "UIColor")]
        /// The tint color for the currently-selected indicators. Default is nil.
        #[unsafe(method(currentPageIndicatorTintColor))]
        #[unsafe(method_family = none)]
        pub fn currentPageIndicatorTintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`currentPageIndicatorTintColor`][Self::currentPageIndicatorTintColor].
        #[unsafe(method(setCurrentPageIndicatorTintColor:))]
        #[unsafe(method_family = none)]
        pub fn setCurrentPageIndicatorTintColor(
            &self,
            current_page_indicator_tint_color: Option<&UIColor>,
        );

        /// The preferred background style. Default is UIPageControlBackgroundStyleAutomatic on iOS, and UIPageControlBackgroundStyleProminent on tvOS.
        #[unsafe(method(backgroundStyle))]
        #[unsafe(method_family = none)]
        pub fn backgroundStyle(&self) -> UIPageControlBackgroundStyle;

        /// Setter for [`backgroundStyle`][Self::backgroundStyle].
        #[unsafe(method(setBackgroundStyle:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundStyle(&self, background_style: UIPageControlBackgroundStyle);

        /// The layout direction of the page indicators. The default value is
        /// `UIPageControlDirectionNatural.`
        #[unsafe(method(direction))]
        #[unsafe(method_family = none)]
        pub fn direction(&self) -> UIPageControlDirection;

        /// Setter for [`direction`][Self::direction].
        #[unsafe(method(setDirection:))]
        #[unsafe(method_family = none)]
        pub fn setDirection(&self, direction: UIPageControlDirection);

        /// The current interaction state for when the current page changes. Default is UIPageControlInteractionStateNone
        #[unsafe(method(interactionState))]
        #[unsafe(method_family = none)]
        pub fn interactionState(&self) -> UIPageControlInteractionState;

        /// Returns YES if continuous interaction is supported and enabled, NO otherwise. Default is YES for platforms that support it.
        #[unsafe(method(allowsContinuousInteraction))]
        #[unsafe(method_family = none)]
        pub fn allowsContinuousInteraction(&self) -> bool;

        /// Setter for [`allowsContinuousInteraction`][Self::allowsContinuousInteraction].
        #[unsafe(method(setAllowsContinuousInteraction:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsContinuousInteraction(&self, allows_continuous_interaction: bool);

        #[cfg(feature = "UIImage")]
        /// The preferred image for indicators. Symbol images are recommended. Default is nil.
        #[unsafe(method(preferredIndicatorImage))]
        #[unsafe(method_family = none)]
        pub fn preferredIndicatorImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`preferredIndicatorImage`][Self::preferredIndicatorImage].
        #[unsafe(method(setPreferredIndicatorImage:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredIndicatorImage(&self, preferred_indicator_image: Option<&UIImage>);

        #[cfg(feature = "UIImage")]
        /// Returns the override indicator image for the specific page, nil if no override image was set.
        ///
        /// Parameter `page`: Must be in the range of 0..numberOfPages
        #[unsafe(method(indicatorImageForPage:))]
        #[unsafe(method_family = none)]
        pub fn indicatorImageForPage(&self, page: NSInteger) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Override the indicator image for a specific page. Symbol images are recommended.
        ///
        /// Parameter `image`: The image for the indicator. Resets to the default if image is nil.
        ///
        /// Parameter `page`: Must be in the range of 0..numberOfPages
        #[unsafe(method(setIndicatorImage:forPage:))]
        #[unsafe(method_family = none)]
        pub fn setIndicatorImage_forPage(&self, image: Option<&UIImage>, page: NSInteger);

        #[cfg(feature = "UIImage")]
        /// The preferred image for the current page indicator. Symbol images are recommended. Default is nil.
        /// If this value is nil, then UIPageControl will use
        /// `preferredPageIndicatorImage`(or its per-page variant) as
        /// the indicator image.
        #[unsafe(method(preferredCurrentPageIndicatorImage))]
        #[unsafe(method_family = none)]
        pub fn preferredCurrentPageIndicatorImage(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`preferredCurrentPageIndicatorImage`][Self::preferredCurrentPageIndicatorImage].
        #[unsafe(method(setPreferredCurrentPageIndicatorImage:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredCurrentPageIndicatorImage(
            &self,
            preferred_current_page_indicator_image: Option<&UIImage>,
        );

        #[cfg(feature = "UIImage")]
        /// Returns the override current page indicator image for the specific page, nil if no override image was set.
        ///
        /// Parameter `page`: Must be in the range of 0..numberOfPages
        #[unsafe(method(currentPageIndicatorImageForPage:))]
        #[unsafe(method_family = none)]
        pub fn currentPageIndicatorImageForPage(
            &self,
            page: NSInteger,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Override the current page indicator image for a specific page. Symbol images are recommended.
        ///
        /// Parameter `image`: The image for the indicator. Resets to the default if image is nil.
        ///
        /// Parameter `page`: Must be in the range of 0..numberOfPages
        #[unsafe(method(setCurrentPageIndicatorImage:forPage:))]
        #[unsafe(method_family = none)]
        pub fn setCurrentPageIndicatorImage_forPage(
            &self,
            image: Option<&UIImage>,
            page: NSInteger,
        );

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the minimum size required to display indicators for the given page count. Can be used to size the control if the page count could change.
        #[unsafe(method(sizeForNumberOfPages:))]
        #[unsafe(method_family = none)]
        pub fn sizeForNumberOfPages(&self, page_count: NSInteger) -> CGSize;

        /// if set, tapping to a new page won't update the currently displayed page until -updateCurrentPageDisplay is called. default is NO
        #[deprecated = "defersCurrentPageDisplay no longer does anything reasonable with the new interaction mode."]
        #[unsafe(method(defersCurrentPageDisplay))]
        #[unsafe(method_family = none)]
        pub fn defersCurrentPageDisplay(&self) -> bool;

        /// Setter for [`defersCurrentPageDisplay`][Self::defersCurrentPageDisplay].
        #[deprecated = "defersCurrentPageDisplay no longer does anything reasonable with the new interaction mode."]
        #[unsafe(method(setDefersCurrentPageDisplay:))]
        #[unsafe(method_family = none)]
        pub fn setDefersCurrentPageDisplay(&self, defers_current_page_display: bool);

        /// update page display to match the currentPage. ignored if defersCurrentPageDisplay is NO. setting the page value directly will update immediately
        #[deprecated = "updateCurrentPageDisplay no longer does anything reasonable with the new interaction mode."]
        #[unsafe(method(updateCurrentPageDisplay))]
        #[unsafe(method_family = none)]
        pub fn updateCurrentPageDisplay(&self);
    );
}

/// Methods declared on superclass `UIControl`.
#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIPageControl {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(all(
            feature = "UIAction",
            feature = "UIMenuElement",
            feature = "objc2-core-foundation"
        ))]
        /// Initializes the control and adds primaryAction for the UIControlEventPrimaryActionTriggered control event. Subclasses of UIControl may alter or add behaviors around the usage of primaryAction, see subclass documentation of this initializer for additional information.
        #[unsafe(method(initWithFrame:primaryAction:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame_primaryAction(
            this: Allocated<Self>,
            frame: CGRect,
            primary_action: Option<&UIAction>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UIView`.
#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIPageControl {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIPageControl {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
