//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffilesecurity?language=objc)
#[repr(C)]
pub struct CFFileSecurity {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFFileSecurity"]
    unsafe impl CFFileSecurity {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFFileSecurity {
    #[doc(alias = "CFFileSecurityGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFFileSecurityGetTypeID() -> CFTypeID;
        }
        unsafe { CFFileSecurityGetTypeID() }
    }
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityCreate(
    allocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFFileSecurity>> {
    extern "C-unwind" {
        fn CFFileSecurityCreate(allocator: Option<&CFAllocator>)
            -> Option<NonNull<CFFileSecurity>>;
    }
    let ret = unsafe { CFFileSecurityCreate(allocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityCreateCopy(
    allocator: Option<&CFAllocator>,
    file_sec: Option<&CFFileSecurity>,
) -> Option<CFRetained<CFFileSecurity>> {
    extern "C-unwind" {
        fn CFFileSecurityCreateCopy(
            allocator: Option<&CFAllocator>,
            file_sec: Option<&CFFileSecurity>,
        ) -> Option<NonNull<CFFileSecurity>>;
    }
    let ret = unsafe { CFFileSecurityCreateCopy(allocator, file_sec) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFUUID")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityCopyOwnerUUID(
    file_sec: &CFFileSecurity,
    owner_uuid: *mut *const CFUUID,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityCopyOwnerUUID(
            file_sec: &CFFileSecurity,
            owner_uuid: *mut *const CFUUID,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityCopyOwnerUUID(file_sec, owner_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecuritySetOwnerUUID(
    file_sec: &CFFileSecurity,
    owner_uuid: Option<&CFUUID>,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetOwnerUUID(
            file_sec: &CFFileSecurity,
            owner_uuid: Option<&CFUUID>,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetOwnerUUID(file_sec, owner_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityCopyGroupUUID(
    file_sec: &CFFileSecurity,
    group_uuid: *mut *const CFUUID,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityCopyGroupUUID(
            file_sec: &CFFileSecurity,
            group_uuid: *mut *const CFUUID,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityCopyGroupUUID(file_sec, group_uuid) };
    ret != 0
}

#[cfg(feature = "CFUUID")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecuritySetGroupUUID(
    file_sec: &CFFileSecurity,
    group_uuid: Option<&CFUUID>,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetGroupUUID(
            file_sec: &CFFileSecurity,
            group_uuid: Option<&CFUUID>,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetGroupUUID(file_sec, group_uuid) };
    ret != 0
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityGetOwner(
    file_sec: &CFFileSecurity,
    owner: *mut libc::uid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityGetOwner(file_sec: &CFFileSecurity, owner: *mut libc::uid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityGetOwner(file_sec, owner) };
    ret != 0
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecuritySetOwner(
    file_sec: &CFFileSecurity,
    owner: libc::uid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetOwner(file_sec: &CFFileSecurity, owner: libc::uid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetOwner(file_sec, owner) };
    ret != 0
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityGetGroup(
    file_sec: &CFFileSecurity,
    group: *mut libc::gid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityGetGroup(file_sec: &CFFileSecurity, group: *mut libc::gid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityGetGroup(file_sec, group) };
    ret != 0
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecuritySetGroup(
    file_sec: &CFFileSecurity,
    group: libc::gid_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetGroup(file_sec: &CFFileSecurity, group: libc::gid_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetGroup(file_sec, group) };
    ret != 0
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityGetMode(
    file_sec: &CFFileSecurity,
    mode: *mut libc::mode_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityGetMode(file_sec: &CFFileSecurity, mode: *mut libc::mode_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityGetMode(file_sec, mode) };
    ret != 0
}

#[cfg(feature = "libc")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecuritySetMode(
    file_sec: &CFFileSecurity,
    mode: libc::mode_t,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecuritySetMode(file_sec: &CFFileSecurity, mode: libc::mode_t) -> Boolean;
    }
    let ret = unsafe { CFFileSecuritySetMode(file_sec, mode) };
    ret != 0
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cffilesecurityclearoptions?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFFileSecurityClearOptions(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFFileSecurityClearOptions: CFOptionFlags {
        #[doc(alias = "kCFFileSecurityClearOwner")]
        const Owner = 1<<0;
        #[doc(alias = "kCFFileSecurityClearGroup")]
        const Group = 1<<1;
        #[doc(alias = "kCFFileSecurityClearMode")]
        const Mode = 1<<2;
        #[doc(alias = "kCFFileSecurityClearOwnerUUID")]
        const OwnerUUID = 1<<3;
        #[doc(alias = "kCFFileSecurityClearGroupUUID")]
        const GroupUUID = 1<<4;
        #[doc(alias = "kCFFileSecurityClearAccessControlList")]
        const AccessControlList = 1<<5;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFFileSecurityClearOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFFileSecurityClearOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFFileSecurityClearProperties(
    file_sec: &CFFileSecurity,
    clear_property_mask: CFFileSecurityClearOptions,
) -> bool {
    extern "C-unwind" {
        fn CFFileSecurityClearProperties(
            file_sec: &CFFileSecurity,
            clear_property_mask: CFFileSecurityClearOptions,
        ) -> Boolean;
    }
    let ret = unsafe { CFFileSecurityClearProperties(file_sec, clear_property_mask) };
    ret != 0
}
