package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkRule invokes the kms.CreateNetworkRule API synchronously
func (client *Client) CreateNetworkRule(request *CreateNetworkRuleRequest) (response *CreateNetworkRuleResponse, err error) {
	response = CreateCreateNetworkRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkRuleWithChan invokes the kms.CreateNetworkRule API asynchronously
func (client *Client) CreateNetworkRuleWithChan(request *CreateNetworkRuleRequest) (<-chan *CreateNetworkRuleResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkRuleWithCallback invokes the kms.CreateNetworkRule API asynchronously
func (client *Client) CreateNetworkRuleWithCallback(request *CreateNetworkRuleRequest, callback func(response *CreateNetworkRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkRuleRequest is the request struct for api CreateNetworkRule
type CreateNetworkRuleRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	Type            string `position:"Query" name:"Type"`
	Name            string `position:"Query" name:"Name"`
	SourcePrivateIp string `position:"Query" name:"SourcePrivateIp"`
}

// CreateNetworkRuleResponse is the response struct for api CreateNetworkRule
type CreateNetworkRuleResponse struct {
	*responses.BaseResponse
	Type            string `json:"Type" xml:"Type"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Description     string `json:"Description" xml:"Description"`
	SourcePrivateIp string `json:"SourcePrivateIp" xml:"SourcePrivateIp"`
	Name            string `json:"Name" xml:"Name"`
	Arn             string `json:"Arn" xml:"Arn"`
}

// CreateCreateNetworkRuleRequest creates a request to invoke CreateNetworkRule API
func CreateCreateNetworkRuleRequest() (request *CreateNetworkRuleRequest) {
	request = &CreateNetworkRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "CreateNetworkRule", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateNetworkRuleResponse creates a response to parse from CreateNetworkRule response
func CreateCreateNetworkRuleResponse() (response *CreateNetworkRuleResponse) {
	response = &CreateNetworkRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
