/**
 * Aften: A/52 audio encoder
 * Copyright (c) 2006 Justin Ruggles
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file dynrng.h
 * A/52 Dynamic Range Compression header
 */

#ifndef DYNRNG_H
#define DYNRNG_H

#include "common.h"

#include "aften.h"

void dynrng_init(void);

int calculate_block_dynrng(FLOAT *samples[A52_MAX_CHANNELS], int num_ch,
                           int dialnorm, DynRngProfile profile);

#endif
