package mobilemodels

import (
	"encoding/json"

	"0xacab.org/leap/bitmask-core/models"
	"github.com/rs/zerolog/log"
)

// Bridges is a gomobile compatible wrapper around an array of swagger generated
// models.ModelsBridge
type Bridges struct {
	bridges []*models.ModelsBridge
}

func NewBridges(bridges []*models.ModelsBridge) *Bridges {
	return &Bridges{
		bridges: bridges,
	}
}

func (a *Bridges) Length() int {
	return len(a.bridges)
}

func (a *Bridges) Get(i int) *models.ModelsBridge {
	if i < 0 || a.Length()-1 < i {
		return nil
	}
	return a.bridges[i]
}

func (a *Bridges) Add(bridge *models.ModelsBridge) {
	a.bridges = append(a.bridges, bridge)
}

func (a *Bridges) ToJson() (string, error) {
	res, err := json.Marshal(a.bridges)
	if err != nil {
		log.Debug().Msgf("Failed to serialize bridges: %v", err)
		return "", err
	}
	return string(res), nil
}
