/* SPDX-License-Identifier: GPL-2.0-only */

/* This file is created based on MT8169_DEVICE_APC_REG_DEVAPC_external.docx */

#include <console/console.h>
#include <soc/devapc.h>
#include <soc/devapc_common.h>

static const struct apc_infra_peri_dom_8 infra_ao_sys0_devices[] = {
	/* 0 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_TOPCKGEN",
				NO_PROTECTION, FORBIDDEN3,
				NO_PROTECTION, NO_PROTECTION, NO_PROTECTION, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_INFRASYS_CONFIG_REGS",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("IO_CFG_REG",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_ PERICFG",
				NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION,
				FORBIDDEN4),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_EFUSAO_DEBUG",
				SEC_RW_NS_R, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_GPIO",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SLEEP_CONTROLLER",
				NO_PROTECTION, NO_PROTECTION, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_TOPRGU",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_APXGPT",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_RESERVE",
				NO_PROTECTION, FORBIDDEN7),

	/* 10 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SEJ",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_AP_CIRQ_EINT",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_APMIXEDSYS",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				NO_PROTECTION, NO_PROTECTION, NO_PROTECTION, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PMIC_WRAP",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN3,
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_DEVICAPC_AO_INFRA_PERI",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_DEVICAPC_AO_MM",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_KEYPAD",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_TOP_MISC",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_ DVFS_CTRL_PROC",
				NO_PROTECTION, SEC_RW_NS_R, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_IFNRA_TOP_MBIST_CTRL",
				NO_PROTECTION, FORBIDDEN7),

	/* 20 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_DPMAIF_AO_TOP",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PMIF",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_AES_TOP_0",
				FORBIDDEN, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SYS_TIMER",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_MDEM_TEMP_SHARE",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_DEVICAPC_AO_MD",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SECURITY_AO",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SPMI_MST_WRAP",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SPM",
				NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SPM",
				NO_PROTECTION, FORBIDDEN7),

	/* 30 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SPM",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SPM",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_AP_DMA",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_SYS_CIRQ",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DEVICAPC",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DBG_TRACKER",
				NO_PROTECTION, FORBIDDEN7),

	/* 40 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF0_AP",
				NO_PROTECTION, SEC_RW_NS_R, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF0_MD",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF1_AP",
				NO_PROTECTION, SEC_RW_NS_R, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF1_MD",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_INFRA_PDN_REGISTER",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_TRNG",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DX_CC",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF4_AP",
				NO_PROTECTION, SEC_RW_NS_R, FORBIDDEN,
				NO_PROTECTION, FORBIDDEN4),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CQ_DMA",
				NO_PROTECTION, FORBIDDEN7),

	/* 50 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF4_MD",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN,
				NO_PROTECTION, FORBIDDEN4),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_SRAMROM",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_EMI",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DEVICMPU_LOW",
				SEC_RW_ONLY, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_EMI_MPU_REG",
				SEC_RW_NS_R, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DPMAIF_TOP",
				NO_PROTECTION, FORBIDDEN7),

	/* 60 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DPMAIF_TOP",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DPMAIF_TOP",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DPMAIF_TOP",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP0",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP2",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP3",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP4",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP5",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH0_TOP6",
				NO_PROTECTION, FORBIDDEN7),

	/* 70 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_GCE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP0",
				NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP1",
				NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP2",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP3",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP4",
				NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP5",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DRAMC_CH1_TOP6",
				NO_PROTECTION, FORBIDDEN4,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF2_AP",
				NO_PROTECTION, SEC_RW_NS_R, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF2_MD",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),

	/* 80 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF3_AP",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, FORBIDDEN,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_CCIF3_MD",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, FORBIDDEN,
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_1_1",
				FORBIDDEN, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_1_2",
				FORBIDDEN, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_1_3",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_2",
				SEC_RW_NS_R, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_3",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_4",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_5",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_6",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),

	/* 90 */
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_7",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_PWRMCU_8",
				FORBIDDEN, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_SCP",
				NO_PROTECTION, FORBIDDEN3,
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRA_AO_MCUCFG(*)",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("INFRASYS_DBUGSYS",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN5),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_AUXADC",
				NO_PROTECTION, FORBIDDEN3, NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_UART0",
				NO_PROTECTION, FORBIDDEN3, NO_PROTECTION, FORBIDDEN3),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_UART1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C7",
				NO_PROTECTION, FORBIDDEN7),

	/* 100 */
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C8",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_PWM",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C0",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C2",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_SPI0",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_PTP",
				NO_PROTECTION, FORBIDDEN, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_BTIF",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C6",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_DISP_PWM",
				NO_PROTECTION, FORBIDDEN7),

	/* 110 */
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C3",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_SPI1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C4",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_SPI2",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_SPI3",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_SPI4",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_SPI5",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C5",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_IMP_IIC_WRAP",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_UART2",
				NO_PROTECTION, FORBIDDEN7),

	/* 120 */
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_I2C9",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_USB",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN5, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_USB_2.0_SUB",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_MSDC0",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_MSDC1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_MSDC2",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_MSDC3",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_UFS",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISUS_USB3.0_SIF",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISUS_USB3.0_SIF2",
				NO_PROTECTION, FORBIDDEN7),

	/* 130 */
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_USB_2.0_SIF(**)",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_AUDIO",
				NO_PROTECTION, FORBIDDEN3,
				NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("EAST_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("EAST_ CSI_TOP_AO",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("EAST_ RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("EAST_ RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("SOUTH_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("SOUTH_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("SOUTH_RESERVE",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("SOUTH_RESERVE",
				NO_PROTECTION, FORBIDDEN7),

	/* 140 */
	DAPC_INFRA_AO_SYS0_ATTR("WEST_MIPI_TX_CONFIG",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("WEST_MSDC1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("WEST_USB20_PHY",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN6),
	DAPC_INFRA_AO_SYS0_ATTR("WEST_EFUSE",
				NO_PROTECTION, SEC_RW_NS_R, NO_PROTECTION, FORBIDDEN,
				FORBIDDEN, NO_PROTECTION, FORBIDDEN, FORBIDDEN),
	DAPC_INFRA_AO_SYS0_ATTR("NORTH_UFS_MPHY",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("NORTH_MSDC0",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("NORTH_RESERV0",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("NORTH_RESERV1",
				NO_PROTECTION, FORBIDDEN7),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_CONN",
				NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION,
				FORBIDDEN3, NO_PROTECTION),
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_MD1",
				NO_PROTECTION, FORBIDDEN7),

	/* 150 */
	DAPC_INFRA_AO_SYS0_ATTR("PERISYS_AUDIODSP",
				NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN),
};

/* module, AP permission, N/A, SSPM permission, N/A */
static const struct apc_infra_peri_dom_4 mm_ao_sys0_devices[] = {

	/* 0 */
	DAPC_MM_AO_SYS0_ATTR("IP",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DFD",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("G3D Secure Reg",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("G3D TestBench",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("G3D_CONFIG",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("MMSYS_CONFIG",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_MUTEX0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 10 */
	DAPC_MM_AO_SYS0_ATTR("SMI_COMMON",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("SMI_LARB0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("SMI_LARB1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_OVL0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_OVL0_2L",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_RDMA0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_RSZ0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_COLOR0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_CCORR0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 20 */
	DAPC_MM_AO_SYS0_ATTR("DISP_AAL0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_GAMMA0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_POSTMASK0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_DITHER0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_DSC_WRAP0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DSI0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_WDMA0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 30 */
	DAPC_MM_AO_SYS0_ATTR("MM_IOMMU_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("MM_IOMMU_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("MM_IOMMU_2",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("MM_IOMMU_3",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("MM_IOMMU_4",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_SMI_2X1_SUB_COMMON_U0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("DISP_SMI_2X1_SUB_COMMON_U1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("IMG1_SMI_2X1_SUB_COMMON",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 40 */
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (mfb_a)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (wpe_a)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (mss_a)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 50 */
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("imgsys1_top",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 60 */
	DAPC_MM_AO_SYS0_ATTR("dip_a2",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a3",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a4",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a5",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a6",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a7",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_a8)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_a9)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a10",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("dip_a11",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 70 */
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb9",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("2x1_sub_common",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mfb_b",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("wpe_b",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mss_b",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 80 */
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("imgsys2_top",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 90 */
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b0)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_a8)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b1)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b2)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b3)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b4)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b5)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b6)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b7)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b8)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 100 */
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b9)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b10)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (dip_b11)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb11",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved  (smi_larb12)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("rserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),

	/* 110 */
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),

	/* 120 */
	DAPC_MM_AO_SYS0_ATTR("vdec_core0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0_larb",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_core0_gcon",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("vdec_mini_mdp_top",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("venc_global_con",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb7",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("venc",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("jpgenc",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 130 */
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("venc_mbist_ctrl",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsys top",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb13",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb14",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_a",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_b",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_c",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 140 */
	DAPC_MM_AO_SYS0_ATTR("seninf_d",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_e",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_f",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_g",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("seninf_h",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_smi_3x1_sub_common_u0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_smi_4x1_sub_common_u0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb_16",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb_17",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 150 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 160 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 170 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 180 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_2",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_3",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_dma_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_dma_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_a_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_a_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_0_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 190 */
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_1_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_2_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_ip_group_3_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_dma_0_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_dma_1_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_a_0_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_a_1_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 200 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_set",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_clr",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_set_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_a_clr_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 210 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsys_a_config",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_2",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_3",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_dma_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_dma_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_b_0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 220 */
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_b_1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_0_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_1_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_2_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_ip_group_3_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_dma_0_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_dma_1_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_b_0_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ltm_curve_b_1_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 230 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_set",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_clr",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 240 */
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_set_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("cam_raw_b_clr_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsys_b_config",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 250 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 260 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 270 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_2",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 280 */
	DAPC_MM_AO_SYS0_ATTR("camsv_3",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_4",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_5",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_6",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_7",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_2_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_3_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_4_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 290 */
	DAPC_MM_AO_SYS0_ATTR("camsv_5_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_6_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("camsv_7_inner",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("asg",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 300 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 310 */
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("RESERVED",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdpsys_config",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 320 */
	DAPC_MM_AO_SYS0_ATTR("mdp_mutex0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_rdma0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_aal0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_hdr0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_rsz0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_rsz1",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_wrot0",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),

	/* 330 */
	DAPC_MM_AO_SYS0_ATTR("mdp_wrot1",
			     NO_PROTECTION, NO_PROTECTION, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("mdp_tdshp0",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ipesys_top",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("fdvt",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("Reserved (fe)",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("rsc",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 340 */
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("ipe_smi_2x1_sub_common",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 350 */
	DAPC_MM_AO_SYS0_ATTR("smi_larb20",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("depth",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),

	/* 360 */
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("smi_larb19",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
	DAPC_MM_AO_SYS0_ATTR("reserved",
			     NO_PROTECTION, FORBIDDEN, FORBIDDEN, NO_PROTECTION),
};

static const struct apc_infra_peri_dom_16 adsp_ao_sys0_devices[] = {
	/* 0 */
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_INFRA",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_INFRA_1",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_INFRA_2",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_EMI",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_AFE",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_AFE_1",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSP1",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSP1_1",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSP2",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSP2_1",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),

	/* 10 */
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_F_SRAM",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_H_SRAM",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPCFG",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPCKCTL",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DMA0_CFG",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSP_TIMER",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSP_UART",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_BUSMON_DRAM",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPMBOX_0",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPMBOX_1",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),

	/* 20 */
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPMBOX_2",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPMBOX_3",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPMBOX_4",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DSPCFG_SEC",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_BUSMON_INFRA",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DMA1_CFG",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_RESERVED",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_BUSCFG",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_TMBIST",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_BCRM",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),

	/* 30 */
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_BUS_DEBUG",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_SYSCFG_AO",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_MASRC",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DAPC_AO",
			      SEC_RW_ONLY, FORBIDDEN15),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_K_BCRM",
			      NO_PROTECTION, FORBIDDEN5, NO_PROTECTION, FORBIDDEN9),
	DAPC_AUD_AO_SYS0_ATTR("AUD_AO_DAPC",
			      SEC_RW_ONLY, FORBIDDEN15),
};

static const enum domain_id domain_map[] = {
	DOMAIN_0, DOMAIN_1, DOMAIN_2, DOMAIN_3,
	DOMAIN_4, DOMAIN_5, DOMAIN_6, DOMAIN_7,
	DOMAIN_8, DOMAIN_9, DOMAIN_10, DOMAIN_11,
	DOMAIN_12, DOMAIN_13, DOMAIN_14, DOMAIN_15,
};

static void set_infra_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(infra_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(infra_ao_sys0_devices[i].d_permission); j++)
			set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
				       infra_ao_sys0_devices[i].d_permission[j]);

	/*
	 * Extra apc setting.
	 * Block debugsys to avoid privilege escalation.
	 */
	if (!CONFIG(CONSOLE_SERIAL))
		set_module_apc(base + SYS0_D0_APC_0, DEVAPC_DEBUGSYS_INDEX,
			       DOMAIN_0, SEC_RW_NS_R);
}

static void set_mm_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(mm_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(mm_ao_sys0_devices[i].d_permission); j++)
			set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
				       mm_ao_sys0_devices[i].d_permission[j]);
}

#define AUD_DOMAIN_OFT 0x40
static void *adsp_getreg_domain(uintptr_t base, unsigned int offset,
				enum domain_id domain_id, unsigned int index)
{
	return (void *)(base + offset + domain_id * AUD_DOMAIN_OFT + index * IDX_OFT);
}

static void adsp_set_module_apc(uintptr_t base, uint32_t module, enum domain_id domain_id,
				enum devapc_perm_type perm)
{
	uint32_t apc_register_index;
	uint32_t apc_set_index;

	apc_register_index = module / MOD_NO_IN_1_DEVAPC;
	apc_set_index = module % MOD_NO_IN_1_DEVAPC;

	clrsetbits32(adsp_getreg_domain(base, 0, domain_id, apc_register_index),
		     0x3 << (apc_set_index * 2),
		     perm << (apc_set_index * 2));
}

static void set_adsp_ao_apc(uintptr_t base)
{
	int i, j;

	for (i = 0; i < ARRAY_SIZE(adsp_ao_sys0_devices); i++)
		for (j = 0; j < ARRAY_SIZE(adsp_ao_sys0_devices[i].d_permission); j++)
			adsp_set_module_apc(base + SYS0_D0_APC_0, i, domain_map[j],
					    adsp_ao_sys0_devices[i].d_permission[j]);
}

static void dump_infra_ao_apc(uintptr_t base)
{
	int reg_max;
	unsigned int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(infra_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (INFRA_AO_SYS0)D%d_APC_%d: %#x\n", d, i,
			       read32(getreg_domain(base, SYS0_D0_APC_0, d, i)));

	printk(BIOS_DEBUG, "[DEVAPC] (INFRA_AO)MAS_SEC_0: %#x\n",
	       read32(getreg(base, MAS_SEC_0)));
}

static void dump_mm_ao_apc(uintptr_t base)
{
	int reg_max;
	unsigned int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(mm_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_MM_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (MM_AO_SYS0)D%d_APC_%d: %#x\n", d, i,
			       read32(getreg_domain(base, SYS0_D0_APC_0, d, i)));

	printk(BIOS_DEBUG, "[DEVAPC] (MM_AO)MAS_SEC_0: %#x\n",
	       read32(getreg(base, MAS_SEC_0)));
}

static void dump_adsp_ao_apc(uintptr_t base)
{
	int reg_max;
	unsigned int d, i;

	reg_max = DIV_ROUND_UP(ARRAY_SIZE(adsp_ao_sys0_devices), MOD_NO_IN_1_DEVAPC);
	for (d = 0; d < DOM_NUM_AUD_AO_SYS0; d++)
		for (i = 0; i < reg_max; i++)
			printk(BIOS_DEBUG, "[DEVAPC] (AUD_AO_SYS0)D%d_APC_%d: %#x\n", d, i,
			       read32(adsp_getreg_domain(base, SYS0_D0_APC_0, d, i)));

	printk(BIOS_DEBUG, "[DEVAPC] (AUD_AO)MAS_0: %#x\n",
	       read32(getreg(base, AUD_DOM_0)));

	printk(BIOS_DEBUG, "[DEVAPC] (AUD_AO)SEC_0: %#x\n",
	       read32(getreg(base, AUD_SEC_0)));
}

static void infra_init(uintptr_t base)
{
	/* Side band */
	SET32_BITFIELDS(getreg(base, MAS_SEC_0), SCP_SSPM_SEC, SECURE_TRANS);

	/* Master Domain */
	SET32_BITFIELDS(getreg(base, MAS_DOM_1), SPM_DOM, DOMAIN_5);
	SET32_BITFIELDS(getreg(base, MAS_DOM_3), SCP_DOM, DOMAIN_4);
	/* Default APC Setting */
	set_infra_ao_apc(base);
}

static void mm_init(uintptr_t base)
{
	/* Default APC Setting */
	set_mm_ao_apc(base);

	/*
	 * Domain Remap: MMSYS slave domain remap (4-bit to 2-bit)
	 *     1. From domain 0          to domain 0 (no protection for all)
	 *     2. From domain 1, 2, 3, 5 to domain 2 (forbidden for all)
	 *     3. From domain 4          to domain 1
	 *     4. others from XXX        to domain 0
	 */
	SET32_BITFIELDS(getreg(base, DOM_REMAP_0_0),
			TWO_BIT_DOM_REMAP_0, DOMAIN_0,
			TWO_BIT_DOM_REMAP_1, DOMAIN_2,
			TWO_BIT_DOM_REMAP_2, DOMAIN_2,
			TWO_BIT_DOM_REMAP_3, DOMAIN_2,
			TWO_BIT_DOM_REMAP_4, DOMAIN_1,
			TWO_BIT_DOM_REMAP_5, DOMAIN_2);
}

static void adsp_init(uintptr_t base)
{
	set_adsp_ao_apc(base);

	/* Master domain/secure */
	SET32_BITFIELDS(getreg(base, AUD_DOM_0), ADSP_DOM, DOMAIN_6);
	write32(getreg(base, AUD_SEC_0), 0);
}

struct devapc_init_ops {
	uintptr_t base;
	void (*init)(uintptr_t base);
	void (*dump)(uintptr_t base);
} devapc_init[] = {
	{ DEVAPC_AO_INFRA_PERI_BASE, infra_init, dump_infra_ao_apc },
	{ DEVAPC_AO_MM_BASE, mm_init, dump_mm_ao_apc },
	{ DEVAPC_AO_AUD_BASE, adsp_init, dump_adsp_ao_apc },
};

void dapc_init(void)
{
	unsigned int i;
	uintptr_t devapc_ao_base;

	for (i = 0; i < ARRAY_SIZE(devapc_init); i++) {
		devapc_ao_base = devapc_init[i].base;

		/* Init dapc */
		write32(getreg(devapc_ao_base, AO_APC_CON), 0x0);
		write32(getreg(devapc_ao_base, AO_APC_CON), 0x1);

		/* Initialization */
		if (devapc_init[i].init)
			devapc_init[i].init(devapc_ao_base);

		/* Dump Setting */
		if (devapc_init[i].dump)
			devapc_init[i].dump(devapc_ao_base);
	}
}
