#!/usr/bin/perl -w
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

#
# This tool unpacks a full update package generated by make_full_update.sh
# Author: Benjamin Smedberg
#

# -----------------------------------------------------------------------------
# By default just assume that these tools exist on our path

use Getopt::Std;

my ($MAR, $XZ, $archive, @marentries, @marfiles);

if (defined($ENV{"MAR"})) {
    $MAR = $ENV{"MAR"};
}
else {
    $MAR = "mar";
}

if (defined($ENV{"XZ"})) {
    $XZ = $ENV{"XZ"};
}
else {
    if (system("xz --version > /dev/null 2>&1") != 0) {
        # Some of the Windows build systems have xz.exe in topsrcdir/xz/.
        my $xzwinpath = __FILE__;
        $xzwinpath = substr($xzwinpath, 0, rindex($xzwinpath, '/'));
        $xzwinpath = substr($xzwinpath, 0, rindex($xzwinpath, '/'));
        $xzwinpath = substr($xzwinpath, 0, rindex($xzwinpath, '/'));
        my $xzwin = $xzwinpath . "/xz/xz.exe";
        if (-e $xzwin) {
            $XZ = $xzwin;
        }
        else {
            $xzwinpath = substr($xzwinpath, 0, rindex($xzwinpath, '/'));
            $xzwin = $xzwinpath . "/xz/xz.exe";
            if (-e $xzwin) {
                $XZ = $xzwin;
            }
            else {
                # If the xz executable was not found fallback to trying to execute
                # xz and follow the normal failure path if it isn't found.
                $XZ = "xz";
            }
        }
    }
    else {
        $XZ = "xz";
    }
}

sub print_usage
{
    print "Usage: unwrap_full_update.pl [OPTIONS] ARCHIVE\n\n";
    print "The contents of ARCHIVE will be unpacked into the current directory.\n\n";
    print "Options:\n";
    print "  -h show this help text\n";
}

my %opts;
getopts("h", \%opts);

if (defined($opts{'h'}) || scalar(@ARGV) != 1) {
    print_usage();
    exit 1;
}

$archive = $ARGV[0];
@marentries = `"$MAR" -t "$archive"`;
$? && die("Couldn't run \"$MAR\" -t");

system($MAR, "-x", $archive) == 0 ||
  die "Couldn't run $MAR -x";

shift @marentries;

foreach (@marentries) {
    tr/\n\r//d;
    my @splits = split(/\t/,$_);
    my $file = $splits[2];

    print "Decompressing: " . $file . "\n";
    system("mv", $file, "$file.xz") == 0 ||
      die "Couldn't mv \"$file\"";
    system($XZ, "-d", "$file.xz") == 0 ||
      die "Couldn't decompress \"$file\"";
}

print "Finished\n";

