/* arch-tag: 4fbc3b21-07fd-468a-a1b3-d8b101b53ffe */

/*  eXperience GTK engine: utils.h
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __UTILS_H
#define __UTILS_H

#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "experience.h"

#define PIXEL_SIZE_WITHOUT_ALPHA 3
#define PIXEL_SIZE_WITH_ALPHA 4

#define RED_OFFSET 0
#define GREEN_OFFSET 1
#define BLUE_OFFSET 2
#define ALPHA_OFFSET 3

/* Macro used to ensure valid values */
#define CLAMP_UCHAR(value) CLAMP(value,0,255)
                                  
typedef enum {
	ROTATE_NONE   = 0,
	ROTATE_CW     = 1,
	ROTATE_CCW    = 3,
	ROTATE_AROUND = 2
} eXperienceRotate;

typedef enum {
	ROUND_CEIL,
	ROUND_FLOOR,
	ROUND_NORMAL,
	ROUND_TO_ZERO
} eXperienceRoundingMethod;

typedef enum {
	ORIENTATION_HORIZONTAL = 1 << 0,
	ORIENTATION_VERTICAL   = 1 << 1
} eXperienceOrientation;

#include "render.h"

gint experience_round (eXperienceRoundingMethod method, gfloat value) EXPERIENCE_INTERNAL;

void experience_rectangle_union (GdkRectangle * src1, GdkRectangle * src2, GdkRectangle * dest) EXPERIENCE_INTERNAL;

/* The following functions exist to save time used for creating GdkPixbufs */
GdkPixbuf * experience_evil_pixbuf_scale_or_ref (GdkPixbuf * pixbuf, gboolean need_persistent, GdkRectangle * src, gint dest_width, gint dest_height, GdkInterpType interp_type, gboolean must_scale) EXPERIENCE_INTERNAL;
GdkPixbuf * experience_pixbuf_scale_simple_or_ref (GdkPixbuf * pixbuf, gint width, gint height, GdkInterpType interp_type) EXPERIENCE_INTERNAL;

GdkPixbuf * experience_change_pixbuf_opacity (GdkPixbuf * pixbuf, gfloat opacity) EXPERIENCE_INTERNAL;
GdkPixbuf * experience_rotate (GdkPixbuf * pixbuf, eXperienceRotate rotation) EXPERIENCE_INTERNAL;
GdkPixbuf * experience_mirror (GdkPixbuf * pixbuf, eXperienceRotate rotation) EXPERIENCE_INTERNAL;
void experience_set_pixbuf_brightness (GdkPixbuf * pixbuf, gfloat brightness) EXPERIENCE_INTERNAL;

void experience_gdk_rectangle_union (GdkRectangle * src1, GdkRectangle * src2, GdkRectangle * dest) EXPERIENCE_INTERNAL;

typedef GdkPixbuf * (*experience_get_image_from_info) (GdkInterpType interp_type, gpointer info, gboolean must_scale);

void experience_pixbuf_composite (eXperienceRenderContext * dest, GdkRectangle * dst_area, GdkRectangle * clip_area, GdkInterpType interp_type, experience_get_image_from_info get_image, gpointer info) EXPERIENCE_INTERNAL;

guint experience_hash_mem (gpointer start, guint count, guint init) EXPERIENCE_INTERNAL;

#endif /* __UTILS_H */
