/* arch-tag: b9e8e988-1edb-4e10-a8e4-5b50c55e28a4 */

/*  eXperience GTK engine: render.c
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __RENDER_H
#define __RENDER_H

#include "experience.h"
#include "gtk/gtk.h"

typedef enum {
	TYPE_PIXBUF,
	TYPE_DRAWABLE,
} eXperienceRenderContextType;

typedef struct {
	eXperienceRenderContextType type;
	GdkRectangle clip_area;
	GdkGC *clip_gc;
	
	GdkDrawable *drawable;
	
	GdkPixbuf *pixbuf;
	GdkRegion *dirty_region;
} eXperienceRenderContext;

/* THIS SUCKS ... got a circular dependency */
#ifndef GROUP_DEFINED
typedef struct _eXperienceGroup eXperienceGroup;
#define GROUP_DEFINED 1
#endif


gboolean experience_render_group (eXperienceGroup * group, GdkWindow *window, GdkRectangle * object_area, GdkRectangle * area, GtkStyle * style, GdkRegion *subtract_region) EXPERIENCE_INTERNAL;

void experience_render_cleanup (void) EXPERIENCE_INTERNAL;


#endif /* __RENDER_H */
