import { workerData, parentPort } from 'node:worker_threads';
import debugWrap from 'debug';
import { P as PLUGIN_NAME, a as getFilter, i as initializeESLint, l as lintFiles, s as shouldIgnoreModule } from './shared/vite-plugin-eslint2.7280f04e.mjs';
import 'tty';
import '@rollup/pluginutils';

var _a;
const debug = debugWrap(`${PLUGIN_NAME}:worker`);
const options = workerData.options;
const filter = getFilter(options);
let eslintInstance;
let formatter;
let outputFixes;
(async () => {
  debug(`Initialize ESLint`);
  const result = await initializeESLint(options);
  eslintInstance = result.eslintInstance;
  formatter = result.formatter;
  outputFixes = result.outputFixes;
  if (options.lintOnStart) {
    debug(`Lint on start`);
    lintFiles({
      files: options.include,
      eslintInstance,
      formatter,
      outputFixes,
      options
    });
  }
})();
(_a = parentPort) == null ? void 0 : _a.on("message", async (files) => {
  debug(`==== message event ====`);
  debug(`message: ${files}`);
  const shouldIgnore = await shouldIgnoreModule(files, filter, eslintInstance);
  debug(`should ignore: ${shouldIgnore}`);
  if (shouldIgnore)
    return;
  lintFiles({
    files: options.lintDirtyOnly ? files : options.include,
    eslintInstance,
    formatter,
    outputFixes,
    options
  });
});
