import { browserTracingIntegration } from '@sentry/browser';
import { Integration } from '@sentry/types';
import * as React from 'react';
import { CreateRouterFunction, CreateRoutesFromChildren, MatchRoutes, Router, RouterState, UseEffect, UseLocation, UseNavigationType, UseRoutes } from './types';
interface ReactRouterOptions {
    useEffect: UseEffect;
    useLocation: UseLocation;
    useNavigationType: UseNavigationType;
    createRoutesFromChildren: CreateRoutesFromChildren;
    matchRoutes: MatchRoutes;
    stripBasename?: boolean;
}
/**
 * A browser tracing integration that uses React Router v6 to instrument navigations.
 * Expects `useEffect`, `useLocation`, `useNavigationType`, `createRoutesFromChildren` and `matchRoutes` to be passed as options.
 */
export declare function reactRouterV6BrowserTracingIntegration(options: Parameters<typeof browserTracingIntegration>[0] & ReactRouterOptions): Integration;
export declare function withSentryReactRouterV6Routing<P extends Record<string, any>, R extends React.FC<P>>(Routes: R): R;
export declare function wrapUseRoutes(origUseRoutes: UseRoutes): UseRoutes;
export declare function wrapCreateBrowserRouter<TState extends RouterState = RouterState, TRouter extends Router<TState> = Router<TState>>(createRouterFunction: CreateRouterFunction<TState, TRouter>): CreateRouterFunction<TState, TRouter>;
export {};
//# sourceMappingURL=reactrouterv6.d.ts.map
