/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.sandmann;

import eu.geekplace.scala.systemd.Systemd$;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Logging$
implements Serializable {
    private static final LoggerContext context;
    public static final Logging$ MODULE$;

    private Logging$() {
    }

    static {
        MODULE$ = new Logging$();
        ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder().setConfigurationName("sandmann").setPackages("de.bwaldvogel.log4j");
        String consoleAppenderName = "console";
        AppenderComponentBuilder consoleAppender = builder.newAppender(consoleAppenderName, "Console");
        LayoutComponentBuilder consolePattern = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{HH:mm:ss} %-5level: %msg [%t]%n%throwable");
        consoleAppender.add(consolePattern);
        builder.add(consoleAppender);
        String systemdJournalAppenderName = "journal";
        AppenderComponentBuilder systemdJournalAppender = (AppenderComponentBuilder)builder.newAppender(systemdJournalAppenderName, "SystemdJournal").addAttribute("logSource", true).addAttribute("syslogIdentifier", "sandmann");
        builder.add(systemdJournalAppender);
        String appenderName = Systemd$.MODULE$.isRunningUnderSystemd() ? systemdJournalAppenderName : consoleAppenderName;
        Predef$.MODULE$.println(new StringBuilder(19).append("Set root logger to ").append(appenderName).toString());
        AppenderRefComponentBuilder appenderRef = builder.newAppenderRef(appenderName);
        RootLoggerComponentBuilder rootLogger = (RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(appenderRef);
        builder.add(rootLogger);
        context = Configurator.initialize(MODULE$.getClass().getClassLoader(), (Configuration)builder.build());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logging$.class);
    }

    public LoggerContext context() {
        return context;
    }

    public void initialize() {
        this.context().getRootLogger().debug(new StringBuilder(29).append("Initializing logging context=").append(this.context()).toString());
    }

    public void configure(Level logLevel) {
        Level noisyLoggerLevel = logLevel.isLessSpecificThan(Level.TRACE) ? logLevel : Level.INFO;
        Tuple2[] tuple2Array = new Tuple2[3];
        String string2 = Predef$.MODULE$.ArrowAssoc("");
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, logLevel);
        String string3 = Predef$.MODULE$.ArrowAssoc("org.freedesktop.dbus");
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, noisyLoggerLevel);
        String string4 = Predef$.MODULE$.ArrowAssoc("com.rm5248.dbusjava");
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, noisyLoggerLevel);
        Seq levelConfig = (Seq)((IterableOnceOps)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).toSeq().sortBy((Function1<Tuple2, int> & Serializable)_$1 -> ((String)_$1._1()).length(), Ordering$Int$.MODULE$);
        Configuration config = this.context().getConfiguration();
        Seq initialLoggerResults = (Seq)((IterableOps)levelConfig.map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String loggerName = (String)tuple2._1();
                Level loggerLevel = (Level)tuple2._2();
                Tuple2 $1$ = tuple2;
                LoggerConfig loggerConfig = config.getLoggerConfig(loggerName);
                return Tuple2$.MODULE$.apply($1$, loggerConfig);
            }
            throw new MatchError(tuple2);
        })).map((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String loggerName = (String)tuple2._1();
                Level loggerLevel = (Level)tuple2._2();
                LoggerConfig loggerConfig = (LoggerConfig)tuple22._2();
                if (loggerName.equals(loggerConfig.getName())) {
                    return this.setLevel$1(loggerConfig, loggerLevel);
                }
                LoggerConfig newLoggerConfig = new LoggerConfig(loggerName, loggerLevel, true);
                config.addLogger(loggerName, newLoggerConfig);
                return true;
            }
            throw new MatchError(tuple22);
        });
        Set setLevelResults = (Set)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(config.getLoggers().entrySet()).asScala().map((Function1<Map.Entry, Tuple2> & Serializable)e -> Tuple2$.MODULE$.apply(e.getKey(), e.getValue()))).map((Function1<Tuple2, Tuple2> & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String loggerName = (String)tuple2._1();
                LoggerConfig loggerConfig = (LoggerConfig)tuple2._2();
                Tuple2 $2$ = tuple2;
                Level desiredLevel = (Level)levelConfig.findLast((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                    String string2 = (String)x$1._1();
                    Level level = (Level)x$1._2();
                    return loggerName.startsWith(string2);
                }).map((Function1<Tuple2, Level> & Serializable)_$3 -> (Level)_$3._2()).get();
                return Tuple2$.MODULE$.apply($2$, desiredLevel);
            }
            throw new MatchError(tuple2);
        })).map((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String loggerName = (String)tuple2._1();
                LoggerConfig loggerConfig = (LoggerConfig)tuple2._2();
                Level desiredLevel = (Level)tuple22._2();
                return this.setLevel$1(loggerConfig, desiredLevel);
            }
            throw new MatchError(tuple22);
        });
        boolean updatedConfig = BoxesRunTime.unboxToBoolean(setLevelResults.$plus$plus(initialLoggerResults).foldLeft((Boolean)BoxesRunTime.boxToBoolean(false), (Function2<Object, Object, boolean> & Serializable)(_$4, _$5) -> Logging$.$anonfun$9(BoxesRunTime.unboxToBoolean(_$4), BoxesRunTime.unboxToBoolean(_$5))));
        if (updatedConfig) {
            this.context().updateLoggers();
            return;
        }
    }

    private final boolean setLevel$1(LoggerConfig loggerConfig, Level level) {
        if (loggerConfig.getLevel().equals(level)) {
            return false;
        }
        loggerConfig.setLevel(level);
        return true;
    }

    private static final /* synthetic */ boolean $anonfun$9(boolean _$4, boolean _$5) {
        return _$4 || _$5;
    }
}

