/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Assembles directive details string, useful for error messages.
export function imgDirectiveDetails(ngSrc, includeNgSrc = true) {
    const ngSrcInfo = includeNgSrc ? `(activated on an <img> element with the \`ngSrc="${ngSrc}"\`) ` : '';
    return `The NgOptimizedImage directive ${ngSrcInfo}has detected that`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3JfaGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29tbW9uL3NyYy9kaXJlY3RpdmVzL25nX29wdGltaXplZF9pbWFnZS9lcnJvcl9oZWxwZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsaUVBQWlFO0FBQ2pFLE1BQU0sVUFBVSxtQkFBbUIsQ0FBQyxLQUFhLEVBQUUsWUFBWSxHQUFHLElBQUk7SUFDcEUsTUFBTSxTQUFTLEdBQ1gsWUFBWSxDQUFDLENBQUMsQ0FBQyxvREFBb0QsS0FBSyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztJQUN6RixPQUFPLGtDQUFrQyxTQUFTLG1CQUFtQixDQUFDO0FBQ3hFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuLy8gQXNzZW1ibGVzIGRpcmVjdGl2ZSBkZXRhaWxzIHN0cmluZywgdXNlZnVsIGZvciBlcnJvciBtZXNzYWdlcy5cbmV4cG9ydCBmdW5jdGlvbiBpbWdEaXJlY3RpdmVEZXRhaWxzKG5nU3JjOiBzdHJpbmcsIGluY2x1ZGVOZ1NyYyA9IHRydWUpIHtcbiAgY29uc3QgbmdTcmNJbmZvID1cbiAgICAgIGluY2x1ZGVOZ1NyYyA/IGAoYWN0aXZhdGVkIG9uIGFuIDxpbWc+IGVsZW1lbnQgd2l0aCB0aGUgXFxgbmdTcmM9XCIke25nU3JjfVwiXFxgKSBgIDogJyc7XG4gIHJldHVybiBgVGhlIE5nT3B0aW1pemVkSW1hZ2UgZGlyZWN0aXZlICR7bmdTcmNJbmZvfWhhcyBkZXRlY3RlZCB0aGF0YDtcbn1cbiJdfQ==