package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAsrVadConfig invokes the voicenavigator.DescribeAsrVadConfig API synchronously
func (client *Client) DescribeAsrVadConfig(request *DescribeAsrVadConfigRequest) (response *DescribeAsrVadConfigResponse, err error) {
	response = CreateDescribeAsrVadConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAsrVadConfigWithChan invokes the voicenavigator.DescribeAsrVadConfig API asynchronously
func (client *Client) DescribeAsrVadConfigWithChan(request *DescribeAsrVadConfigRequest) (<-chan *DescribeAsrVadConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeAsrVadConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAsrVadConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAsrVadConfigWithCallback invokes the voicenavigator.DescribeAsrVadConfig API asynchronously
func (client *Client) DescribeAsrVadConfigWithCallback(request *DescribeAsrVadConfigRequest, callback func(response *DescribeAsrVadConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAsrVadConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeAsrVadConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAsrVadConfigRequest is the request struct for api DescribeAsrVadConfig
type DescribeAsrVadConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeAsrVadConfigResponse is the response struct for api DescribeAsrVadConfig
type DescribeAsrVadConfigResponse struct {
	*responses.BaseResponse
	SpeechNoiseThreshold string `json:"SpeechNoiseThreshold" xml:"SpeechNoiseThreshold"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeAsrVadConfigRequest creates a request to invoke DescribeAsrVadConfig API
func CreateDescribeAsrVadConfigRequest() (request *DescribeAsrVadConfigRequest) {
	request = &DescribeAsrVadConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DescribeAsrVadConfig", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeAsrVadConfigResponse creates a response to parse from DescribeAsrVadConfig response
func CreateDescribeAsrVadConfigResponse() (response *DescribeAsrVadConfigResponse) {
	response = &DescribeAsrVadConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
