package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayBlockVolume invokes the sgw.UpdateGatewayBlockVolume API synchronously
func (client *Client) UpdateGatewayBlockVolume(request *UpdateGatewayBlockVolumeRequest) (response *UpdateGatewayBlockVolumeResponse, err error) {
	response = CreateUpdateGatewayBlockVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayBlockVolumeWithChan invokes the sgw.UpdateGatewayBlockVolume API asynchronously
func (client *Client) UpdateGatewayBlockVolumeWithChan(request *UpdateGatewayBlockVolumeRequest) (<-chan *UpdateGatewayBlockVolumeResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayBlockVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayBlockVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayBlockVolumeWithCallback invokes the sgw.UpdateGatewayBlockVolume API asynchronously
func (client *Client) UpdateGatewayBlockVolumeWithCallback(request *UpdateGatewayBlockVolumeRequest, callback func(response *UpdateGatewayBlockVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayBlockVolumeResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayBlockVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayBlockVolumeRequest is the request struct for api UpdateGatewayBlockVolume
type UpdateGatewayBlockVolumeRequest struct {
	*requests.RpcRequest
	ChapEnabled    requests.Boolean `position:"Query" name:"ChapEnabled"`
	Size           requests.Integer `position:"Query" name:"Size"`
	SecurityToken  string           `position:"Query" name:"SecurityToken"`
	ChapInUser     string           `position:"Query" name:"ChapInUser"`
	IndexId        string           `position:"Query" name:"IndexId"`
	ChapInPassword string           `position:"Query" name:"ChapInPassword"`
	GatewayId      string           `position:"Query" name:"GatewayId"`
}

// UpdateGatewayBlockVolumeResponse is the response struct for api UpdateGatewayBlockVolume
type UpdateGatewayBlockVolumeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateUpdateGatewayBlockVolumeRequest creates a request to invoke UpdateGatewayBlockVolume API
func CreateUpdateGatewayBlockVolumeRequest() (request *UpdateGatewayBlockVolumeRequest) {
	request = &UpdateGatewayBlockVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "UpdateGatewayBlockVolume", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayBlockVolumeResponse creates a response to parse from UpdateGatewayBlockVolume response
func CreateUpdateGatewayBlockVolumeResponse() (response *UpdateGatewayBlockVolumeResponse) {
	response = &UpdateGatewayBlockVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
