package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartFileShares invokes the sgw.RestartFileShares API synchronously
func (client *Client) RestartFileShares(request *RestartFileSharesRequest) (response *RestartFileSharesResponse, err error) {
	response = CreateRestartFileSharesResponse()
	err = client.DoAction(request, response)
	return
}

// RestartFileSharesWithChan invokes the sgw.RestartFileShares API asynchronously
func (client *Client) RestartFileSharesWithChan(request *RestartFileSharesRequest) (<-chan *RestartFileSharesResponse, <-chan error) {
	responseChan := make(chan *RestartFileSharesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartFileShares(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartFileSharesWithCallback invokes the sgw.RestartFileShares API asynchronously
func (client *Client) RestartFileSharesWithCallback(request *RestartFileSharesRequest, callback func(response *RestartFileSharesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartFileSharesResponse
		var err error
		defer close(result)
		response, err = client.RestartFileShares(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartFileSharesRequest is the request struct for api RestartFileShares
type RestartFileSharesRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	ShareProtocol string `position:"Query" name:"ShareProtocol"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// RestartFileSharesResponse is the response struct for api RestartFileShares
type RestartFileSharesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateRestartFileSharesRequest creates a request to invoke RestartFileShares API
func CreateRestartFileSharesRequest() (request *RestartFileSharesRequest) {
	request = &RestartFileSharesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "RestartFileShares", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartFileSharesResponse creates a response to parse from RestartFileShares response
func CreateRestartFileSharesResponse() (response *RestartFileSharesResponse) {
	response = &RestartFileSharesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
