package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobInstance invokes the schedulerx2.GetJobInstance API synchronously
func (client *Client) GetJobInstance(request *GetJobInstanceRequest) (response *GetJobInstanceResponse, err error) {
	response = CreateGetJobInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobInstanceWithChan invokes the schedulerx2.GetJobInstance API asynchronously
func (client *Client) GetJobInstanceWithChan(request *GetJobInstanceRequest) (<-chan *GetJobInstanceResponse, <-chan error) {
	responseChan := make(chan *GetJobInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobInstanceWithCallback invokes the schedulerx2.GetJobInstance API asynchronously
func (client *Client) GetJobInstanceWithCallback(request *GetJobInstanceRequest, callback func(response *GetJobInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetJobInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobInstanceRequest is the request struct for api GetJobInstance
type GetJobInstanceRequest struct {
	*requests.RpcRequest
	NamespaceSource string           `position:"Query" name:"NamespaceSource"`
	GroupId         string           `position:"Query" name:"GroupId"`
	JobId           requests.Integer `position:"Query" name:"JobId"`
	Namespace       string           `position:"Query" name:"Namespace"`
	JobInstanceId   requests.Integer `position:"Query" name:"JobInstanceId"`
}

// GetJobInstanceResponse is the response struct for api GetJobInstance
type GetJobInstanceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetJobInstanceRequest creates a request to invoke GetJobInstance API
func CreateGetJobInstanceRequest() (request *GetJobInstanceRequest) {
	request = &GetJobInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "GetJobInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateGetJobInstanceResponse creates a response to parse from GetJobInstance response
func CreateGetJobInstanceResponse() (response *GetJobInstanceResponse) {
	response = &GetJobInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
