package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReportCoverJobResult invokes the mts.ReportCoverJobResult API synchronously
func (client *Client) ReportCoverJobResult(request *ReportCoverJobResultRequest) (response *ReportCoverJobResultResponse, err error) {
	response = CreateReportCoverJobResultResponse()
	err = client.DoAction(request, response)
	return
}

// ReportCoverJobResultWithChan invokes the mts.ReportCoverJobResult API asynchronously
func (client *Client) ReportCoverJobResultWithChan(request *ReportCoverJobResultRequest) (<-chan *ReportCoverJobResultResponse, <-chan error) {
	responseChan := make(chan *ReportCoverJobResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReportCoverJobResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReportCoverJobResultWithCallback invokes the mts.ReportCoverJobResult API asynchronously
func (client *Client) ReportCoverJobResultWithCallback(request *ReportCoverJobResultRequest, callback func(response *ReportCoverJobResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReportCoverJobResultResponse
		var err error
		defer close(result)
		response, err = client.ReportCoverJobResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReportCoverJobResultRequest is the request struct for api ReportCoverJobResult
type ReportCoverJobResultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Result               string           `position:"Query" name:"Result"`
	JobId                string           `position:"Query" name:"JobId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ReportCoverJobResultResponse is the response struct for api ReportCoverJobResult
type ReportCoverJobResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateReportCoverJobResultRequest creates a request to invoke ReportCoverJobResult API
func CreateReportCoverJobResultRequest() (request *ReportCoverJobResultRequest) {
	request = &ReportCoverJobResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ReportCoverJobResult", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReportCoverJobResultResponse creates a response to parse from ReportCoverJobResult response
func CreateReportCoverJobResultResponse() (response *ReportCoverJobResultResponse) {
	response = &ReportCoverJobResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
