package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOTAModuleVersionsByDevice invokes the iot.ListOTAModuleVersionsByDevice API synchronously
func (client *Client) ListOTAModuleVersionsByDevice(request *ListOTAModuleVersionsByDeviceRequest) (response *ListOTAModuleVersionsByDeviceResponse, err error) {
	response = CreateListOTAModuleVersionsByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListOTAModuleVersionsByDeviceWithChan invokes the iot.ListOTAModuleVersionsByDevice API asynchronously
func (client *Client) ListOTAModuleVersionsByDeviceWithChan(request *ListOTAModuleVersionsByDeviceRequest) (<-chan *ListOTAModuleVersionsByDeviceResponse, <-chan error) {
	responseChan := make(chan *ListOTAModuleVersionsByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOTAModuleVersionsByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOTAModuleVersionsByDeviceWithCallback invokes the iot.ListOTAModuleVersionsByDevice API asynchronously
func (client *Client) ListOTAModuleVersionsByDeviceWithCallback(request *ListOTAModuleVersionsByDeviceRequest, callback func(response *ListOTAModuleVersionsByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOTAModuleVersionsByDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListOTAModuleVersionsByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOTAModuleVersionsByDeviceRequest is the request struct for api ListOTAModuleVersionsByDevice
type ListOTAModuleVersionsByDeviceRequest struct {
	*requests.RpcRequest
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// ListOTAModuleVersionsByDeviceResponse is the response struct for api ListOTAModuleVersionsByDevice
type ListOTAModuleVersionsByDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string                              `json:"RequestId" xml:"RequestId"`
	Success      bool                                `json:"Success" xml:"Success"`
	Code         string                              `json:"Code" xml:"Code"`
	ErrorMessage string                              `json:"ErrorMessage" xml:"ErrorMessage"`
	Total        int                                 `json:"Total" xml:"Total"`
	PageSize     int                                 `json:"PageSize" xml:"PageSize"`
	PageCount    int                                 `json:"PageCount" xml:"PageCount"`
	CurrentPage  int                                 `json:"CurrentPage" xml:"CurrentPage"`
	Data         DataInListOTAModuleVersionsByDevice `json:"Data" xml:"Data"`
}

// CreateListOTAModuleVersionsByDeviceRequest creates a request to invoke ListOTAModuleVersionsByDevice API
func CreateListOTAModuleVersionsByDeviceRequest() (request *ListOTAModuleVersionsByDeviceRequest) {
	request = &ListOTAModuleVersionsByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListOTAModuleVersionsByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateListOTAModuleVersionsByDeviceResponse creates a response to parse from ListOTAModuleVersionsByDevice response
func CreateListOTAModuleVersionsByDeviceResponse() (response *ListOTAModuleVersionsByDeviceResponse) {
	response = &ListOTAModuleVersionsByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
