package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterDetails invokes the foas.GetClusterDetails API synchronously
func (client *Client) GetClusterDetails(request *GetClusterDetailsRequest) (response *GetClusterDetailsResponse, err error) {
	response = CreateGetClusterDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterDetailsWithChan invokes the foas.GetClusterDetails API asynchronously
func (client *Client) GetClusterDetailsWithChan(request *GetClusterDetailsRequest) (<-chan *GetClusterDetailsResponse, <-chan error) {
	responseChan := make(chan *GetClusterDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterDetailsWithCallback invokes the foas.GetClusterDetails API asynchronously
func (client *Client) GetClusterDetailsWithCallback(request *GetClusterDetailsRequest, callback func(response *GetClusterDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterDetailsResponse
		var err error
		defer close(result)
		response, err = client.GetClusterDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterDetailsRequest is the request struct for api GetClusterDetails
type GetClusterDetailsRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"clusterId"`
}

// GetClusterDetailsResponse is the response struct for api GetClusterDetails
type GetClusterDetailsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Details   Details `json:"Details" xml:"Details"`
}

// CreateGetClusterDetailsRequest creates a request to invoke GetClusterDetails API
func CreateGetClusterDetailsRequest() (request *GetClusterDetailsRequest) {
	request = &GetClusterDetailsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetClusterDetails", "/api/v2/clusters/[clusterId]/details", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetClusterDetailsResponse creates a response to parse from GetClusterDetails response
func CreateGetClusterDetailsResponse() (response *GetClusterDetailsResponse) {
	response = &GetClusterDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
