package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryApiAvgDurationGroupTrend invokes the emas_appmonitor.QueryApiAvgDurationGroupTrend API synchronously
func (client *Client) QueryApiAvgDurationGroupTrend(request *QueryApiAvgDurationGroupTrendRequest) (response *QueryApiAvgDurationGroupTrendResponse, err error) {
	response = CreateQueryApiAvgDurationGroupTrendResponse()
	err = client.DoAction(request, response)
	return
}

// QueryApiAvgDurationGroupTrendWithChan invokes the emas_appmonitor.QueryApiAvgDurationGroupTrend API asynchronously
func (client *Client) QueryApiAvgDurationGroupTrendWithChan(request *QueryApiAvgDurationGroupTrendRequest) (<-chan *QueryApiAvgDurationGroupTrendResponse, <-chan error) {
	responseChan := make(chan *QueryApiAvgDurationGroupTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryApiAvgDurationGroupTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryApiAvgDurationGroupTrendWithCallback invokes the emas_appmonitor.QueryApiAvgDurationGroupTrend API asynchronously
func (client *Client) QueryApiAvgDurationGroupTrendWithCallback(request *QueryApiAvgDurationGroupTrendRequest, callback func(response *QueryApiAvgDurationGroupTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryApiAvgDurationGroupTrendResponse
		var err error
		defer close(result)
		response, err = client.QueryApiAvgDurationGroupTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryApiAvgDurationGroupTrendRequest is the request struct for api QueryApiAvgDurationGroupTrend
type QueryApiAvgDurationGroupTrendRequest struct {
	*requests.RpcRequest
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	Group              string           `position:"Body" name:"Group"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
}

// QueryApiAvgDurationGroupTrendResponse is the response struct for api QueryApiAvgDurationGroupTrend
type QueryApiAvgDurationGroupTrendResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQueryApiAvgDurationGroupTrendRequest creates a request to invoke QueryApiAvgDurationGroupTrend API
func CreateQueryApiAvgDurationGroupTrendRequest() (request *QueryApiAvgDurationGroupTrendRequest) {
	request = &QueryApiAvgDurationGroupTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QueryApiAvgDurationGroupTrend", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryApiAvgDurationGroupTrendResponse creates a response to parse from QueryApiAvgDurationGroupTrend response
func CreateQueryApiAvgDurationGroupTrendResponse() (response *QueryApiAvgDurationGroupTrendResponse) {
	response = &QueryApiAvgDurationGroupTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
