package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhoneNumberAttribute invokes the dytnsapi.DescribePhoneNumberAttribute API synchronously
func (client *Client) DescribePhoneNumberAttribute(request *DescribePhoneNumberAttributeRequest) (response *DescribePhoneNumberAttributeResponse, err error) {
	response = CreateDescribePhoneNumberAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhoneNumberAttributeWithChan invokes the dytnsapi.DescribePhoneNumberAttribute API asynchronously
func (client *Client) DescribePhoneNumberAttributeWithChan(request *DescribePhoneNumberAttributeRequest) (<-chan *DescribePhoneNumberAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribePhoneNumberAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhoneNumberAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhoneNumberAttributeWithCallback invokes the dytnsapi.DescribePhoneNumberAttribute API asynchronously
func (client *Client) DescribePhoneNumberAttributeWithCallback(request *DescribePhoneNumberAttributeRequest, callback func(response *DescribePhoneNumberAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhoneNumberAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribePhoneNumberAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhoneNumberAttributeRequest is the request struct for api DescribePhoneNumberAttribute
type DescribePhoneNumberAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePhoneNumberAttributeResponse is the response struct for api DescribePhoneNumberAttribute
type DescribePhoneNumberAttributeResponse struct {
	*responses.BaseResponse
	Code                 string               `json:"Code" xml:"Code"`
	Message              string               `json:"Message" xml:"Message"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	PhoneNumberAttribute PhoneNumberAttribute `json:"PhoneNumberAttribute" xml:"PhoneNumberAttribute"`
}

// CreateDescribePhoneNumberAttributeRequest creates a request to invoke DescribePhoneNumberAttribute API
func CreateDescribePhoneNumberAttributeRequest() (request *DescribePhoneNumberAttributeRequest) {
	request = &DescribePhoneNumberAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "DescribePhoneNumberAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePhoneNumberAttributeResponse creates a response to parse from DescribePhoneNumberAttribute response
func CreateDescribePhoneNumberAttributeResponse() (response *DescribePhoneNumberAttributeResponse) {
	response = &DescribePhoneNumberAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
