package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDataSourceShare invokes the dataworks_public.SetDataSourceShare API synchronously
func (client *Client) SetDataSourceShare(request *SetDataSourceShareRequest) (response *SetDataSourceShareResponse, err error) {
	response = CreateSetDataSourceShareResponse()
	err = client.DoAction(request, response)
	return
}

// SetDataSourceShareWithChan invokes the dataworks_public.SetDataSourceShare API asynchronously
func (client *Client) SetDataSourceShareWithChan(request *SetDataSourceShareRequest) (<-chan *SetDataSourceShareResponse, <-chan error) {
	responseChan := make(chan *SetDataSourceShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDataSourceShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDataSourceShareWithCallback invokes the dataworks_public.SetDataSourceShare API asynchronously
func (client *Client) SetDataSourceShareWithCallback(request *SetDataSourceShareRequest, callback func(response *SetDataSourceShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDataSourceShareResponse
		var err error
		defer close(result)
		response, err = client.SetDataSourceShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDataSourceShareRequest is the request struct for api SetDataSourceShare
type SetDataSourceShareRequest struct {
	*requests.RpcRequest
	ProjectPermissions string           `position:"Query" name:"ProjectPermissions"`
	DatasourceName     string           `position:"Query" name:"DatasourceName"`
	UserPermissions    string           `position:"Query" name:"UserPermissions"`
	EnvType            string           `position:"Query" name:"EnvType"`
	ProjectId          requests.Integer `position:"Query" name:"ProjectId"`
}

// SetDataSourceShareResponse is the response struct for api SetDataSourceShare
type SetDataSourceShareResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSetDataSourceShareRequest creates a request to invoke SetDataSourceShare API
func CreateSetDataSourceShareRequest() (request *SetDataSourceShareRequest) {
	request = &SetDataSourceShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "SetDataSourceShare", "", "")
	request.Method = requests.POST
	return
}

// CreateSetDataSourceShareResponse creates a response to parse from SetDataSourceShare response
func CreateSetDataSourceShareResponse() (response *SetDataSourceShareResponse) {
	response = &SetDataSourceShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
