package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceConfigurationTimeline invokes the config.GetResourceConfigurationTimeline API synchronously
func (client *Client) GetResourceConfigurationTimeline(request *GetResourceConfigurationTimelineRequest) (response *GetResourceConfigurationTimelineResponse, err error) {
	response = CreateGetResourceConfigurationTimelineResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceConfigurationTimelineWithChan invokes the config.GetResourceConfigurationTimeline API asynchronously
func (client *Client) GetResourceConfigurationTimelineWithChan(request *GetResourceConfigurationTimelineRequest) (<-chan *GetResourceConfigurationTimelineResponse, <-chan error) {
	responseChan := make(chan *GetResourceConfigurationTimelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceConfigurationTimeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceConfigurationTimelineWithCallback invokes the config.GetResourceConfigurationTimeline API asynchronously
func (client *Client) GetResourceConfigurationTimelineWithCallback(request *GetResourceConfigurationTimelineRequest, callback func(response *GetResourceConfigurationTimelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceConfigurationTimelineResponse
		var err error
		defer close(result)
		response, err = client.GetResourceConfigurationTimeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceConfigurationTimelineRequest is the request struct for api GetResourceConfigurationTimeline
type GetResourceConfigurationTimelineRequest struct {
	*requests.RpcRequest
	ResourceId   string           `position:"Query" name:"ResourceId"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
	Region       string           `position:"Query" name:"Region"`
}

// GetResourceConfigurationTimelineResponse is the response struct for api GetResourceConfigurationTimeline
type GetResourceConfigurationTimelineResponse struct {
	*responses.BaseResponse
	RequestId                     string                        `json:"RequestId" xml:"RequestId"`
	ResourceConfigurationTimeline ResourceConfigurationTimeline `json:"ResourceConfigurationTimeline" xml:"ResourceConfigurationTimeline"`
}

// CreateGetResourceConfigurationTimelineRequest creates a request to invoke GetResourceConfigurationTimeline API
func CreateGetResourceConfigurationTimelineRequest() (request *GetResourceConfigurationTimelineRequest) {
	request = &GetResourceConfigurationTimelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetResourceConfigurationTimeline", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourceConfigurationTimelineResponse creates a response to parse from GetResourceConfigurationTimeline response
func CreateGetResourceConfigurationTimelineResponse() (response *GetResourceConfigurationTimelineResponse) {
	response = &GetResourceConfigurationTimelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
