package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIpControlPolicyItem invokes the cloudapi.ModifyIpControlPolicyItem API synchronously
// api document: https://help.aliyun.com/api/cloudapi/modifyipcontrolpolicyitem.html
func (client *Client) ModifyIpControlPolicyItem(request *ModifyIpControlPolicyItemRequest) (response *ModifyIpControlPolicyItemResponse, err error) {
	response = CreateModifyIpControlPolicyItemResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIpControlPolicyItemWithChan invokes the cloudapi.ModifyIpControlPolicyItem API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/modifyipcontrolpolicyitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIpControlPolicyItemWithChan(request *ModifyIpControlPolicyItemRequest) (<-chan *ModifyIpControlPolicyItemResponse, <-chan error) {
	responseChan := make(chan *ModifyIpControlPolicyItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIpControlPolicyItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIpControlPolicyItemWithCallback invokes the cloudapi.ModifyIpControlPolicyItem API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/modifyipcontrolpolicyitem.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIpControlPolicyItemWithCallback(request *ModifyIpControlPolicyItemRequest, callback func(response *ModifyIpControlPolicyItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIpControlPolicyItemResponse
		var err error
		defer close(result)
		response, err = client.ModifyIpControlPolicyItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIpControlPolicyItemRequest is the request struct for api ModifyIpControlPolicyItem
type ModifyIpControlPolicyItemRequest struct {
	*requests.RpcRequest
	IpControlId   string `position:"Query" name:"IpControlId"`
	PolicyItemId  string `position:"Query" name:"PolicyItemId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	AppId         string `position:"Query" name:"AppId"`
	CidrIp        string `position:"Query" name:"CidrIp"`
}

// ModifyIpControlPolicyItemResponse is the response struct for api ModifyIpControlPolicyItem
type ModifyIpControlPolicyItemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIpControlPolicyItemRequest creates a request to invoke ModifyIpControlPolicyItem API
func CreateModifyIpControlPolicyItemRequest() (request *ModifyIpControlPolicyItemRequest) {
	request = &ModifyIpControlPolicyItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyIpControlPolicyItem", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyIpControlPolicyItemResponse creates a response to parse from ModifyIpControlPolicyItem response
func CreateModifyIpControlPolicyItemResponse() (response *ModifyIpControlPolicyItemResponse) {
	response = &ModifyIpControlPolicyItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
