package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResumeCampaign invokes the ccc.ResumeCampaign API synchronously
func (client *Client) ResumeCampaign(request *ResumeCampaignRequest) (response *ResumeCampaignResponse, err error) {
	response = CreateResumeCampaignResponse()
	err = client.DoAction(request, response)
	return
}

// ResumeCampaignWithChan invokes the ccc.ResumeCampaign API asynchronously
func (client *Client) ResumeCampaignWithChan(request *ResumeCampaignRequest) (<-chan *ResumeCampaignResponse, <-chan error) {
	responseChan := make(chan *ResumeCampaignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResumeCampaign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResumeCampaignWithCallback invokes the ccc.ResumeCampaign API asynchronously
func (client *Client) ResumeCampaignWithCallback(request *ResumeCampaignRequest, callback func(response *ResumeCampaignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResumeCampaignResponse
		var err error
		defer close(result)
		response, err = client.ResumeCampaign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResumeCampaignRequest is the request struct for api ResumeCampaign
type ResumeCampaignRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	CampaignId string `position:"Query" name:"CampaignId"`
}

// ResumeCampaignResponse is the response struct for api ResumeCampaign
type ResumeCampaignResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateResumeCampaignRequest creates a request to invoke ResumeCampaign API
func CreateResumeCampaignRequest() (request *ResumeCampaignRequest) {
	request = &ResumeCampaignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ResumeCampaign", "", "")
	request.Method = requests.POST
	return
}

// CreateResumeCampaignResponse creates a response to parse from ResumeCampaign response
func CreateResumeCampaignResponse() (response *ResumeCampaignResponse) {
	response = &ResumeCampaignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
