package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RegisterDevices invokes the ccc.RegisterDevices API synchronously
func (client *Client) RegisterDevices(request *RegisterDevicesRequest) (response *RegisterDevicesResponse, err error) {
	response = CreateRegisterDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// RegisterDevicesWithChan invokes the ccc.RegisterDevices API asynchronously
func (client *Client) RegisterDevicesWithChan(request *RegisterDevicesRequest) (<-chan *RegisterDevicesResponse, <-chan error) {
	responseChan := make(chan *RegisterDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RegisterDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RegisterDevicesWithCallback invokes the ccc.RegisterDevices API asynchronously
func (client *Client) RegisterDevicesWithCallback(request *RegisterDevicesRequest, callback func(response *RegisterDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RegisterDevicesResponse
		var err error
		defer close(result)
		response, err = client.RegisterDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RegisterDevicesRequest is the request struct for api RegisterDevices
type RegisterDevicesRequest struct {
	*requests.RpcRequest
	UserIdListJson string `position:"Query" name:"UserIdListJson"`
	DeviceId       string `position:"Query" name:"DeviceId"`
	Password       string `position:"Query" name:"Password"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// RegisterDevicesResponse is the response struct for api RegisterDevices
type RegisterDevicesResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
}

// CreateRegisterDevicesRequest creates a request to invoke RegisterDevices API
func CreateRegisterDevicesRequest() (request *RegisterDevicesRequest) {
	request = &RegisterDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "RegisterDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateRegisterDevicesResponse creates a response to parse from RegisterDevices response
func CreateRegisterDevicesResponse() (response *RegisterDevicesResponse) {
	response = &RegisterDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
