package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPersonalNumbersOfUser invokes the ccc.ListPersonalNumbersOfUser API synchronously
func (client *Client) ListPersonalNumbersOfUser(request *ListPersonalNumbersOfUserRequest) (response *ListPersonalNumbersOfUserResponse, err error) {
	response = CreateListPersonalNumbersOfUserResponse()
	err = client.DoAction(request, response)
	return
}

// ListPersonalNumbersOfUserWithChan invokes the ccc.ListPersonalNumbersOfUser API asynchronously
func (client *Client) ListPersonalNumbersOfUserWithChan(request *ListPersonalNumbersOfUserRequest) (<-chan *ListPersonalNumbersOfUserResponse, <-chan error) {
	responseChan := make(chan *ListPersonalNumbersOfUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPersonalNumbersOfUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPersonalNumbersOfUserWithCallback invokes the ccc.ListPersonalNumbersOfUser API asynchronously
func (client *Client) ListPersonalNumbersOfUserWithCallback(request *ListPersonalNumbersOfUserRequest, callback func(response *ListPersonalNumbersOfUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPersonalNumbersOfUserResponse
		var err error
		defer close(result)
		response, err = client.ListPersonalNumbersOfUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPersonalNumbersOfUserRequest is the request struct for api ListPersonalNumbersOfUser
type ListPersonalNumbersOfUserRequest struct {
	*requests.RpcRequest
	UserId        string           `position:"Query" name:"UserId"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	IsMember      requests.Boolean `position:"Query" name:"IsMember"`
	SearchPattern string           `position:"Query" name:"SearchPattern"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListPersonalNumbersOfUserResponse is the response struct for api ListPersonalNumbersOfUser
type ListPersonalNumbersOfUserResponse struct {
	*responses.BaseResponse
	Code           string                          `json:"Code" xml:"Code"`
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                          `json:"Message" xml:"Message"`
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Data           DataInListPersonalNumbersOfUser `json:"Data" xml:"Data"`
}

// CreateListPersonalNumbersOfUserRequest creates a request to invoke ListPersonalNumbersOfUser API
func CreateListPersonalNumbersOfUserRequest() (request *ListPersonalNumbersOfUserRequest) {
	request = &ListPersonalNumbersOfUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListPersonalNumbersOfUser", "", "")
	request.Method = requests.POST
	return
}

// CreateListPersonalNumbersOfUserResponse creates a response to parse from ListPersonalNumbersOfUser response
func CreateListPersonalNumbersOfUserResponse() (response *ListPersonalNumbersOfUserResponse) {
	response = &ListPersonalNumbersOfUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
