/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.search.SearchExecute;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeNameAndType;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeTableModel;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValueCellEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

public class SmartPopupTableTool
extends JPopupMenu
implements ActionListener {
    JMenuItem delete;
    JMenuItem newValue;
    JMenuItem findDN;
    JMenuItem makeNaming;
    JMenuItem removeNaming;
    JXplorerBrowser browser;
    JTable table;
    AttributeTableModel model;
    String attributeName = null;
    int currentRow;
    AttributeValue currentValue;
    AttributeNameAndType currentType;
    DN currentDN = null;
    AttributeValueCellEditor cellEditor = null;
    private static Logger log = Logger.getLogger(SmartPopupTableTool.class.getName());
    boolean readOnly = false;

    public SmartPopupTableTool(JTable t, AttributeTableModel m, JXplorerBrowser jxplorer) {
        this.browser = jxplorer;
        this.table = t;
        this.model = m;
        this.newValue = new JMenuItem(CBIntText.get("Add Another Value"));
        this.add(this.newValue);
        this.delete = new JMenuItem(CBIntText.get("Delete Value"));
        this.add(this.delete);
        this.makeNaming = new JMenuItem(CBIntText.get("Make Naming Value"));
        this.add(this.makeNaming);
        this.removeNaming = new JMenuItem(CBIntText.get("Remove Naming Value"));
        this.add(this.removeNaming);
        this.add(new JSeparator());
        this.findDN = new JMenuItem(CBIntText.get("Find DN"));
        this.add(this.findDN);
        this.removeNaming.setVisible(false);
        this.findDN.addActionListener(this);
        this.newValue.addActionListener(this);
        this.delete.addActionListener(this);
        this.makeNaming.addActionListener(this);
        this.removeNaming.addActionListener(this);
        this.setVisible(false);
    }

    public void registerCurrentRow(AttributeNameAndType type, AttributeValue value, int row, RDN currentRDN) {
        this.currentType = type;
        this.currentValue = value;
        this.currentRow = row;
        try {
            LdapName test = new LdapName(value.toString());
            this.findDN.setVisible(true);
        }
        catch (NamingException e) {
            this.findDN.setVisible(false);
        }
        if (this.readOnly) {
            this.newValue.setVisible(false);
            this.delete.setVisible(false);
            this.removeNaming.setVisible(false);
            this.makeNaming.setVisible(false);
            return;
        }
        if (this.currentType.toString().equalsIgnoreCase("objectclass")) {
            this.newValue.setEnabled(false);
            this.delete.setEnabled(false);
        } else if (this.readOnly) {
            this.newValue.setVisible(false);
            this.delete.setVisible(false);
        } else {
            this.newValue.setEnabled(true);
            this.delete.setEnabled(true);
        }
        if (value.isNaming()) {
            this.removeNaming.setVisible(true);
            this.makeNaming.setVisible(false);
        } else if (this.currentType.isMandatory()) {
            this.removeNaming.setVisible(false);
            this.makeNaming.setVisible(true);
        } else {
            this.removeNaming.setVisible(false);
            this.makeNaming.setVisible(false);
        }
    }

    public void setReadWrite(boolean readWrite) {
        this.readOnly = !readWrite;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.setVisible(false);
        Object eventSource = ev.getSource();
        if (eventSource == this.newValue) {
            this.cellEditor.stopCellEditing();
            this.newValue();
        } else if (eventSource == this.delete) {
            this.delete();
        } else if (eventSource == this.removeNaming) {
            this.removeRDNComponent();
        } else if (eventSource == this.makeNaming) {
            this.addRDNComponent();
        } else if (eventSource == this.findDN) {
            this.findDNComponent();
        } else {
            log.log(Level.WARNING, "Unknown event in popup menu:\n", ev);
        }
        this.repaint();
    }

    public void findDNComponent() {
        if ("".equals(this.currentValue.getStringValue())) {
            this.browser.getSearchTree().clearTree();
            this.browser.getTreeTabPane().setSelectedComponent(this.browser.getResultsPanel());
            return;
        }
        String filter = "(objectclass=*)";
        DN dn = new DN(this.currentValue.getStringValue());
        String aliasOption = "always";
        log.info("Setting search alias option to: [" + aliasOption + "]");
        JXConfig.setProperty("option.ldap.searchAliasBehaviour", aliasOption);
        this.browser.getSearchBroker().setGUIQuiet(true);
        SearchExecute.run(this.browser.getSearchTree(), dn, filter, new String[]{"objectClass"}, 0, this.browser.getSearchBroker());
        this.browser.getTreeTabPane().setSelectedComponent(this.browser.getResultsPanel());
    }

    public void newValue() {
        int type = this.currentType.isMandatory() ? 1 : 0;
        String attName = this.currentType.getName();
        AttributeValue newVal = new AttributeValue(this.currentValue.getBaseAttribute(), null);
        this.model.addAttribute(newVal, type, this.currentRow + 1);
        this.model.fireChange();
    }

    public void delete() {
        this.model.deleteAttribute(this.currentType.getName(), this.currentRow);
        if (this.currentValue.isNonStringData()) {
            this.currentValue.setValue(null);
        }
        this.model.fireChange();
        if (this.currentType.getName().equalsIgnoreCase("jpegPhoto")) {
            CBCache.cleanCache(this.currentDN.toString());
        }
    }

    public void removeRDNComponent() {
        if (this.model.getRDNSize() == 1) {
            CBUtility.error(CBIntText.get("Cannot remove the last naming component!"));
        } else {
            this.model.removeNamingComponent(this.currentType, this.currentValue);
        }
    }

    public void addRDNComponent() {
        if (this.currentValue.isNonStringData()) {
            CBUtility.error(CBIntText.get("Binary naming components are not supported."));
        } else if (this.currentValue.isEmpty()) {
            CBUtility.error(CBIntText.get("A Naming Component must have an actual value."));
        } else {
            this.model.addNamingComponent(this.currentType, this.currentValue);
        }
    }

    public void setDN(DN dn) {
        this.currentDN = dn;
    }

    public void registerCellEditor(AttributeValueCellEditor myEditor) {
        this.cellEditor = myEditor;
    }
}

