/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert;

import com.ca.commons.cbutil.CBToolBarButton;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.security.cert.CertDetailsTableModel;
import com.ca.commons.security.cert.LabelRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileOutputStream;
import java.security.cert.X509Certificate;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CertDetailsViewPanel
extends JPanel {
    private X509Certificate cert = null;
    private CBToolBarButton editPropertiesButton = new CBToolBarButton("&Edit Properties...", "Edit Properties...");
    private CBToolBarButton copyToFileButton = new CBToolBarButton("&Copy to File...", "Copy to File...");
    private JLabel showLabel = new JLabel("Show:");
    private String[] showOptions = new String[]{"<All>", "Version 1 Fields Only", "Extensions Only", "Critical Extensions Only", "Properties Only"};
    private JComboBox showCombo = new JComboBox<String>(this.showOptions);
    private JTable certDetailsTable = new JTable();
    private JTextArea fieldText = new JTextArea(5, 20);

    public CertDetailsViewPanel(X509Certificate cert) {
        this.cert = cert;
        this.certDetailsTable.setDefaultRenderer(JLabel.class, new LabelRenderer(true));
        this.certDetailsTable.setRowHeight(19);
        this.certDetailsTable.setShowGrid(false);
        this.editPropertiesButton.setWidthHeight(110, 23);
        this.copyToFileButton.setWidthHeight(110, 23);
        this.editPropertiesButton.setEnabled(false);
        this.showCombo.setPreferredSize(new Dimension(200, 23));
        this.showCombo.setMinimumSize(new Dimension(200, 23));
        this.certDetailsTable.setModel(new CertDetailsTableModel(cert, 0));
        this.certDetailsTable.getSelectionModel().setSelectionMode(0);
        this.certDetailsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CertDetailsViewPanel.this.certDetailsTable_selectionChanged(e);
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add(this.copyToFileButton);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.showLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.showCombo, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.add((Component)new JScrollPane(this.certDetailsTable), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)new JScrollPane(this.fieldText), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 6, 10), 0, 0));
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 6, 5), 0, 0));
        this.editPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertDetailsViewPanel.this.editPropertiesButton_actionPerformed(e);
            }
        });
        this.copyToFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertDetailsViewPanel.this.copyToFileButton_actionPerformed(e);
            }
        });
        this.showCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CertDetailsViewPanel.this.showCombo_itemStateChanged(e);
            }
        });
    }

    private void editPropertiesButton_actionPerformed(ActionEvent e) {
        System.out.println("Edit the selected property ");
    }

    private void copyToFileButton_actionPerformed(ActionEvent e) {
        String filename = CBUtility.chooseFileToSave(this, "Please specify a location to save this certificate", new String[]{"der"}, "Certificate file (*.der)");
        if (filename == null) {
            return;
        }
        if (!filename.toLowerCase().endsWith(".der")) {
            filename = filename + ".der";
        }
        if (!CBUtility.okToWriteFile(CBUtility.getParentFrame(this), filename)) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            byte[] derout = this.cert.getEncoded();
            fos.write(derout);
            fos.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error!", 0);
        }
    }

    private void certDetailsTable_selectionChanged(ListSelectionEvent e) {
        int selectedRow = this.certDetailsTable.getSelectedRow();
        if (selectedRow >= 0) {
            String selectedValue = this.certDetailsTable.getValueAt(selectedRow, 1).toString();
            CertDetailsTableModel model = (CertDetailsTableModel)this.certDetailsTable.getModel();
            Object details = model.getDetails(selectedValue);
            if (details != null) {
                this.fieldText.setText(details.toString());
            } else {
                this.fieldText.setText(selectedValue);
            }
        }
    }

    private void showCombo_itemStateChanged(ItemEvent e) {
        ((CertDetailsTableModel)this.certDetailsTable.getModel()).setViewMode(this.showCombo.getSelectedIndex());
        this.fieldText.setText("");
    }
}

